/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.entity.Algorithm;
import at.tugraz.genome.tma.ejb.entity.AlgorithmUtil;
import at.tugraz.genome.tma.ejb.entity.Algorithmspersection;
import at.tugraz.genome.tma.ejb.entity.AlgorithmspersectionUtil;
import at.tugraz.genome.tma.ejb.entity.Arraypunchassociation;
import at.tugraz.genome.tma.ejb.entity.ArraypunchassociationUtil;
import at.tugraz.genome.tma.ejb.entity.Punch;
import at.tugraz.genome.tma.ejb.entity.PunchUtil;
import at.tugraz.genome.tma.ejb.entity.Punchimage;
import at.tugraz.genome.tma.ejb.entity.PunchimageUtil;
import at.tugraz.genome.tma.ejb.entity.Result;
import at.tugraz.genome.tma.ejb.entity.ResultUtil;
import at.tugraz.genome.tma.ejb.vos.AlgorithmVO;
import at.tugraz.genome.tma.ejb.vos.AlgorithmspersectionVO;
import at.tugraz.genome.tma.ejb.vos.ArrayblockVO;
import at.tugraz.genome.tma.ejb.vos.ArraypunchassociationVO;
import at.tugraz.genome.tma.ejb.vos.PunchVO;
import at.tugraz.genome.tma.ejb.vos.PunchimageVO;
import at.tugraz.genome.tma.ejb.vos.ResultVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AlgorithmPunchServiceBean
implements SessionBean {
    Log log = LogFactory.getLog(this.getClass());
    protected SessionContext _ctx = null;

    public AlgorithmVO findAlgorithmByAlgorithmname(String algorithmname, String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAlgorithmByAlgorithmname: begin");
            Algorithm entity = AlgorithmUtil.getLocalHome().findAlgorithmByAlgorithmname(algorithmname);
            AlgorithmVO item = (AlgorithmVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
            this.log.debug("findAlgorithmByAlgorithmname: found item vo=" + item);
            return item;
        }
        catch (ObjectNotFoundException onfex) {
            this.log.error("findAlgorithmByAlgorithmname: ObjectNotFoundException thrown");
            this.log.error((Object)onfex);
            throw new TmaGlobalException(onfex.getMessage());
        }
        catch (FinderException fex) {
            this.log.error("findAlgorithmByAlgorithmname: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("findAlgorithmByAlgorithmname: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Long addAlgorithm(AlgorithmVO vo) throws TmaGlobalException {
        this.log.debug("addAlgorithm: begin vo=" + vo);
        Algorithm entity = null;
        try {
            entity = AlgorithmUtil.getLocalHome().create(vo);
            this.log.info("addAlgorithm(): finished id=" + entity.getAlgorithmId());
        }
        catch (CreateException cex) {
            this.log.error("addAlgorithm: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addAlgorithm: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getAlgorithmId();
    }

    public AlgorithmVO findAlgorithmById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findAlgorithmById: begin id=" + id + " includeTree=" + includeTree);
        Algorithm entity = null;
        try {
            entity = AlgorithmUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findAlgorithmById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAlgorithmById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        AlgorithmVO returnVO = (AlgorithmVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findAlgorithmById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Collection findAllAlgorithms(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllAlgorithms: includeTree=" + includeTree);
            Collection items = AlgorithmUtil.getLocalHome().findAll();
            ArrayList<AlgorithmVO> vos = new ArrayList<AlgorithmVO>();
            this.log.info("findAllAlgorithms: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((AlgorithmVO)ValueTreeBuilder.getValueTree((Algorithm)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllAlgorithms: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllAlgorithms: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeAlgorithmById(Long id) throws TmaGlobalException {
        this.log.info("removeAlgorithmById: begin id=" + id);
        Object entity = null;
        try {
            AlgorithmUtil.getLocalHome().remove(id);
            this.log.info("removeAlgorithmById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeAlgorithmById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeAlgorithmById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void updateAlgorithm(AlgorithmVO vo) throws TmaGlobalException {
        this.log.info("updateAlgorithm: begin vo=" + vo);
        Algorithm entity = null;
        Long id = vo.getAlgorithmId();
        if (id == null) {
            throw new TmaGlobalException("updateAlgorithm(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = AlgorithmUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateAlgorithm: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateAlgorithm(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateAlgorithm(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateAlgorithm(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPAlgorithm(AlgorithmVO vo) throws TmaGlobalException {
        this.log.info("updateAlgorithm: begin vo=" + vo);
        Algorithm entity = null;
        Long id = vo.getAlgorithmId();
        if (id == null) {
            throw new TmaGlobalException("updateAlgorithm(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = AlgorithmUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPAlgorithm: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPAlgorithm(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPAlgorithm(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPAlgorithm(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public Long addPunch(PunchVO vo) throws TmaGlobalException {
        this.log.debug("addPunch: begin vo=" + vo);
        Punch entity = null;
        try {
            entity = PunchUtil.getLocalHome().create(vo);
            this.log.info("addPunch(): finished id=" + entity.getPunchId());
        }
        catch (CreateException cex) {
            this.log.error("addPunch: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addPunch: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getPunchId();
    }

    public PunchVO findPunchById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findPunchById: begin id=" + id + " includeTree=" + includeTree);
        Punch entity = null;
        try {
            entity = PunchUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findPunchById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findPunchById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        PunchVO returnVO = (PunchVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findPunchById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Collection findAllPunchs(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllPunchs: includeTree=" + includeTree);
            Collection items = PunchUtil.getLocalHome().findAll();
            ArrayList<PunchVO> vos = new ArrayList<PunchVO>();
            this.log.info("findAllPunchs: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((PunchVO)ValueTreeBuilder.getValueTree((Punch)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllPunchs: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllPunchs: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removePunchById(Long id) throws TmaGlobalException {
        this.log.info("removePunchById: begin id=" + id);
        Object entity = null;
        try {
            PunchUtil.getLocalHome().remove(id);
            this.log.info("removePunchById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removePunchById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removePunchById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void updatePunch(PunchVO vo) throws TmaGlobalException {
        this.log.info("updatePunch: begin vo=" + vo);
        Punch entity = null;
        Long id = vo.getPunchId();
        if (id == null) {
            throw new TmaGlobalException("updatePunch(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = PunchUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updatePunch: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updatePunch(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updatePunch(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updatePunch(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPPunch(PunchVO vo) throws TmaGlobalException {
        this.log.info("updatePunch: begin vo=" + vo);
        Punch entity = null;
        Long id = vo.getPunchId();
        if (id == null) {
            throw new TmaGlobalException("updatePunch(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = PunchUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPPunch: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPPunch(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPPunch(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPPunch(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public Collection findByAlgorithmId(Long algorithmId, String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findByAlgorithmId: begin");
            Collection items = AlgorithmspersectionUtil.getLocalHome().findByAlgorithmId(algorithmId);
            this.log.info("findByAlgorithmId: found " + items.size() + " items");
            ArrayList<AlgorithmspersectionVO> vos = new ArrayList<AlgorithmspersectionVO>();
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((AlgorithmspersectionVO)ValueTreeBuilder.getValueTree((Algorithmspersection)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findByAlgorithmId: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("findByAlgorithmId: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Long addAlgorithmspersection(AlgorithmspersectionVO vo) throws TmaGlobalException {
        this.log.debug("addAlgorithmspersection: begin vo=" + vo);
        Algorithmspersection entity = null;
        try {
            entity = AlgorithmspersectionUtil.getLocalHome().create(vo);
            this.log.info("addAlgorithmspersection(): finished id=" + entity.getApersectionId());
        }
        catch (CreateException cex) {
            this.log.error("addAlgorithmspersection: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addAlgorithmspersection: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getApersectionId();
    }

    public AlgorithmspersectionVO findAlgorithmspersectionById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findAlgorithmspersectionById: begin id=" + id + " includeTree=" + includeTree);
        Algorithmspersection entity = null;
        try {
            entity = AlgorithmspersectionUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findAlgorithmspersectionById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAlgorithmspersectionById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        AlgorithmspersectionVO returnVO = (AlgorithmspersectionVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findAlgorithmspersectionById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Collection findAllAlgorithmspersections(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllAlgorithmspersections: includeTree=" + includeTree);
            Collection items = AlgorithmspersectionUtil.getLocalHome().findAll();
            ArrayList<AlgorithmspersectionVO> vos = new ArrayList<AlgorithmspersectionVO>();
            this.log.info("findAllAlgorithmspersections: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((AlgorithmspersectionVO)ValueTreeBuilder.getValueTree((Algorithmspersection)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllAlgorithmspersections: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllAlgorithmspersections: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeAlgorithmspersectionById(Long id) throws TmaGlobalException {
        this.log.info("removeAlgorithmspersectionById: begin id=" + id);
        Object entity = null;
        try {
            AlgorithmspersectionUtil.getLocalHome().remove(id);
            this.log.info("removeAlgorithmspersectionById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeAlgorithmspersectionById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeAlgorithmspersectionById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void updateAlgorithmspersection(AlgorithmspersectionVO vo) throws TmaGlobalException {
        this.log.info("updateAlgorithmspersection: begin vo=" + vo);
        Algorithmspersection entity = null;
        Long id = vo.getApersectionId();
        if (id == null) {
            throw new TmaGlobalException("updateAlgorithmspersection(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = AlgorithmspersectionUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateAlgorithmspersection: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateAlgorithmspersection(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateAlgorithmspersection(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateAlgorithmspersection(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPAlgorithmspersection(AlgorithmspersectionVO vo) throws TmaGlobalException {
        this.log.info("updateAlgorithmspersection: begin vo=" + vo);
        Algorithmspersection entity = null;
        Long id = vo.getApersectionId();
        if (id == null) {
            throw new TmaGlobalException("updateAlgorithmspersection(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = AlgorithmspersectionUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPAlgorithmspersection: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPAlgorithmspersection(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPAlgorithmspersection(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPAlgorithmspersection(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public Long addResult(ResultVO vo) throws TmaGlobalException {
        this.log.debug("addResult: begin vo=" + vo);
        Result entity = null;
        try {
            entity = ResultUtil.getLocalHome().create(vo);
            this.log.info("addResult(): finished id=" + entity.getResultId());
        }
        catch (CreateException cex) {
            this.log.error("addResult: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addResult: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getResultId();
    }

    public ResultVO findResultById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findResultById: begin id=" + id + " includeTree=" + includeTree);
        Result entity = null;
        try {
            entity = ResultUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findResultById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findResultById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        ResultVO returnVO = (ResultVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findResultById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Collection findAllResults(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllResults: includeTree=" + includeTree);
            Collection items = ResultUtil.getLocalHome().findAll();
            ArrayList<ResultVO> vos = new ArrayList<ResultVO>();
            this.log.info("findAllResults: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((ResultVO)ValueTreeBuilder.getValueTree((Result)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllResults: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllResults: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeResultById(Long id) throws TmaGlobalException {
        this.log.info("removeResultById: begin id=" + id);
        Object entity = null;
        try {
            ResultUtil.getLocalHome().remove(id);
            this.log.info("removeResultById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeResultById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeResultById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void updateResult(ResultVO vo) throws TmaGlobalException {
        this.log.info("updateResult: begin vo=" + vo);
        Result entity = null;
        Long id = vo.getResultId();
        if (id == null) {
            throw new TmaGlobalException("updateResult(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = ResultUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateResult: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateResult(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateResult(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateResult(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPResult(ResultVO vo) throws TmaGlobalException {
        this.log.info("updateResult: begin vo=" + vo);
        Result entity = null;
        Long id = vo.getResultId();
        if (id == null) {
            throw new TmaGlobalException("updateResult(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = ResultUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPResult: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPResult(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPResult(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPResult(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public Long addArraypunchassociation(ArraypunchassociationVO vo) throws TmaGlobalException {
        this.log.debug("addArraypunchassociation: begin vo=" + vo);
        Arraypunchassociation entity = null;
        try {
            entity = ArraypunchassociationUtil.getLocalHome().create(vo);
            this.log.info("addArraypunchassociation(): finished id=" + entity.getApassociationId());
        }
        catch (CreateException cex) {
            this.log.error("addArraypunchassociation: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addArraypunchassociation: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getApassociationId();
    }

    public ArraypunchassociationVO findArraypunchassociationById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findArraypunchassociationById: begin id=" + id + " includeTree=" + includeTree);
        Arraypunchassociation entity = null;
        try {
            entity = ArraypunchassociationUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findArraypunchassociationById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findArraypunchassociationById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        ArraypunchassociationVO returnVO = (ArraypunchassociationVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findArraypunchassociationById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Collection findAllArraypunchassociations(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllArraypunchassociations: includeTree=" + includeTree);
            Collection items = ArraypunchassociationUtil.getLocalHome().findAll();
            ArrayList<ArraypunchassociationVO> vos = new ArrayList<ArraypunchassociationVO>();
            this.log.info("findAllArraypunchassociations: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((ArraypunchassociationVO)ValueTreeBuilder.getValueTree((Arraypunchassociation)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllArraypunchassociations: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllArraypunchassociations: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeArraypunchassociationById(Long id) throws TmaGlobalException {
        this.log.info("removeArraypunchassociationById: begin id=" + id);
        Object entity = null;
        try {
            ArraypunchassociationUtil.getLocalHome().remove(id);
            this.log.info("removeArraypunchassociationById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeArraypunchassociationById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeArraypunchassociationById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void updateArraypunchassociation(ArraypunchassociationVO vo) throws TmaGlobalException {
        this.log.info("updateArraypunchassociation: begin vo=" + vo);
        Arraypunchassociation entity = null;
        Long id = vo.getApassociationId();
        if (id == null) {
            throw new TmaGlobalException("updateArraypunchassociation(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = ArraypunchassociationUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateArraypunchassociation: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateArraypunchassociation(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateArraypunchassociation(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateArraypunchassociation(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPArraypunchassociation(ArraypunchassociationVO vo) throws TmaGlobalException {
        this.log.info("updateArraypunchassociation: begin vo=" + vo);
        Arraypunchassociation entity = null;
        Long id = vo.getApassociationId();
        if (id == null) {
            throw new TmaGlobalException("updateArraypunchassociation(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = ArraypunchassociationUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPArraypunchassociation: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPArraypunchassociation(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPArraypunchassociation(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPArraypunchassociation(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public Long addPunchimage(PunchimageVO vo) throws TmaGlobalException {
        this.log.debug("addPunchimage: begin vo=" + vo);
        Punchimage entity = null;
        try {
            entity = PunchimageUtil.getLocalHome().create(vo);
            this.log.info("addPunchimage(): finished id=" + entity.getPunchimageId());
        }
        catch (CreateException cex) {
            this.log.error("addPunchimage: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addPunchimage: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getPunchimageId();
    }

    public PunchimageVO findPunchimageById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findPunchimageById: begin id=" + id + " includeTree=" + includeTree);
        Punchimage entity = null;
        try {
            entity = PunchimageUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findPunchimageById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findPunchimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        PunchimageVO returnVO = (PunchimageVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findPunchimageById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Collection findAllPunchimages(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllPunchimages: includeTree=" + includeTree);
            Collection items = PunchimageUtil.getLocalHome().findAll();
            ArrayList<PunchimageVO> vos = new ArrayList<PunchimageVO>();
            this.log.info("findAllPunchimages: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((PunchimageVO)ValueTreeBuilder.getValueTree((Punchimage)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllPunchimages: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllPunchimages: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removePunchimageById(Long id) throws TmaGlobalException {
        this.log.info("removePunchimageById: begin id=" + id);
        Object entity = null;
        try {
            PunchimageUtil.getLocalHome().remove(id);
            this.log.info("removePunchimageById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removePunchimageById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removePunchimageById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void updatePunchimage(PunchimageVO vo) throws TmaGlobalException {
        this.log.info("updatePunchimage: begin vo=" + vo);
        Punchimage entity = null;
        Long id = vo.getPunchimageId();
        if (id == null) {
            throw new TmaGlobalException("updatePunchimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = PunchimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updatePunchimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updatePunchimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updatePunchimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updatePunchimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPPunchimage(PunchimageVO vo) throws TmaGlobalException {
        this.log.info("updatePunchimage: begin vo=" + vo);
        Punchimage entity = null;
        Long id = vo.getPunchimageId();
        if (id == null) {
            throw new TmaGlobalException("updatePunchimage(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = PunchimageUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPPunchimage: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPPunchimage(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPPunchimage(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPPunchimage(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public abstract Collection getAllPunchimageExtendedVOs(Long var1) throws TmaGlobalException;

    public abstract void startAnalysisOnPunch(String var1, Long var2, Hashtable var3) throws TmaGlobalException;

    public abstract void startAnalysisOnPunches(String var1, Vector var2, Hashtable var3) throws TmaGlobalException;

    public abstract void startAnalysisOnSection(Long var1, String var2, Hashtable var3) throws TmaGlobalException;

    public abstract boolean existsAlgorithmName(String var1) throws TmaGlobalException;

    public abstract boolean existsAlgorithmJndi(String var1) throws TmaGlobalException;

    public abstract void deleteSectionResults(Long var1) throws TmaGlobalException;

    public abstract Collection getSectionResults(Long var1) throws TmaGlobalException;

    public abstract Hashtable getAlgorithmInfoPerSection(Long var1) throws TmaGlobalException;

    public abstract ArrayList getPunchImagesBySectionimageID(Long var1) throws TmaGlobalException;

    public abstract Dimension getArrayDimensionBySectionID(Long var1) throws TmaGlobalException;

    public abstract ArrayblockVO getArrayblockVOBySectionID(Long var1) throws TmaGlobalException;

    public abstract Dimension getArrayDimension(ArrayblockVO var1) throws TmaGlobalException;

    public abstract Vector getEmptyArrayPositions(ArrayblockVO var1) throws TmaGlobalException;

    public abstract Vector getOccupiedArrayPositions(ArrayblockVO var1) throws TmaGlobalException;

    public abstract Hashtable getSectionImageIDs(Long var1) throws TmaGlobalException;

    public abstract boolean canStartRGCalibration(Long var1) throws TmaGlobalException;

    public abstract Collection getPunchImagesByPunchID(Long var1) throws TmaGlobalException;

    public abstract void insertResult(AlgorithmVO var1, PunchVO var2, ArrayList var3, String var4, String var5) throws TmaGlobalException;

    public abstract void ejbCreate() throws CreateException;

    public void ejbPostCreate() throws CreateException {
    }

    public void setSessionContext(SessionContext ctx) {
        this._ctx = ctx;
    }

    protected SessionContext getSessionContext() {
        return this._ctx;
    }
}

