/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.entity.Algorithm;
import at.tugraz.genome.tma.ejb.entity.AlgorithmUtil;
import at.tugraz.genome.tma.ejb.entity.Algorithmspersection;
import at.tugraz.genome.tma.ejb.entity.AlgorithmspersectionUtil;
import at.tugraz.genome.tma.ejb.entity.Punch;
import at.tugraz.genome.tma.ejb.entity.PunchUtil;
import at.tugraz.genome.tma.ejb.entity.Punchimage;
import at.tugraz.genome.tma.ejb.entity.Result;
import at.tugraz.genome.tma.ejb.entity.ResultUtil;
import at.tugraz.genome.tma.ejb.entity.Section;
import at.tugraz.genome.tma.ejb.entity.SectionUtil;
import at.tugraz.genome.tma.ejb.entity.Sectionimage;
import at.tugraz.genome.tma.ejb.entity.SectionimageUtil;
import at.tugraz.genome.tma.ejb.service.AlgorithmPunchServiceBean;
import at.tugraz.genome.tma.ejb.vos.AlgorithmInfoPerSectionVO;
import at.tugraz.genome.tma.ejb.vos.AlgorithmVO;
import at.tugraz.genome.tma.ejb.vos.ArrayblockVO;
import at.tugraz.genome.tma.ejb.vos.ArraypunchassociationVO;
import at.tugraz.genome.tma.ejb.vos.EmptyarraypositionVO;
import at.tugraz.genome.tma.ejb.vos.PunchVO;
import at.tugraz.genome.tma.ejb.vos.PunchimageExtendedVO;
import at.tugraz.genome.tma.ejb.vos.PunchimageVO;
import at.tugraz.genome.tma.ejb.vos.ResultVO;
import at.tugraz.genome.tma.ejb.vos.SectionVO;
import at.tugraz.genome.tma.ejb.vos.SectionimageVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.awt.Dimension;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class AlgorithmPunchServiceBeanImpl
extends AlgorithmPunchServiceBean
implements SessionBean {
    private SessionContext context;

    public boolean existsAlgorithmName(String algorithmname) throws TmaGlobalException {
        return this.existName(algorithmname);
    }

    public boolean existsAlgorithmJndi(String algorithmname) throws TmaGlobalException {
        return this.existJNDI(algorithmname);
    }

    public Hashtable getAlgorithmInfoPerSection(Long sectionId) throws TmaGlobalException {
        this.log.debug("getAlgorithmInfoPerSection(java.lang.Long sectionId): begin");
        Hashtable<String, Object> returnHashtable = new Hashtable<String, Object>();
        ArrayList<AlgorithmInfoPerSectionVO> algoInfos = new ArrayList<AlgorithmInfoPerSectionVO>();
        try {
            InitialContext ctx = new InitialContext();
            Connection con = null;
            DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/MySqlDS");
            con = ds.getConnection();
            StringBuffer sqlstmt_buf = new StringBuffer(" SELECT ");
            sqlstmt_buf.append(" Algorithms.AlgorithmID,Algorithms.Algoname,Algorithmspersection.SectionID,");
            sqlstmt_buf.append(" if(Algorithmspersection.SectionID <=> '" + sectionId + "','yes','no') AS isPerformed  ");
            sqlstmt_buf.append("  FROM  ");
            sqlstmt_buf.append(" Algorithms LEFT JOIN Algorithmspersection ");
            sqlstmt_buf.append(" ON (Algorithms.AlgorithmID = Algorithmspersection.AlgorithmID  AND Algorithmspersection.SectionID <=> '" + sectionId + "') ");
            PreparedStatement ps = con.prepareStatement(sqlstmt_buf.toString());
            ResultSet rs = ps.executeQuery();
            int startcount = 0;
            while (rs.next()) {
                String algorithmname = rs.getString("Algorithms.Algoname");
                String isPerformed = rs.getString("isPerformed");
                AlgorithmInfoPerSectionVO info = new AlgorithmInfoPerSectionVO();
                info.setAlgorithmID(new Long(rs.getLong("Algorithms.AlgorithmID")));
                info.setAlgoname(algorithmname);
                info.setSectionID(new Long(rs.getLong("Algorithmspersection.SectionID")));
                if (isPerformed.equalsIgnoreCase("yes")) {
                    info.setIsPerformed("algorithm.showstart.isperformed.yes");
                } else {
                    info.setIsPerformed("algorithm.showstart.isperformed.no");
                    info.setStart("on");
                }
                if (this.existsAlgorithmJndi(algorithmname)) {
                    info.setStatus("algorithms.statusfound");
                } else {
                    info.setStatus("algorithms.statusnotfound");
                    info.resetStart();
                }
                if (algorithmname.equalsIgnoreCase("RGCalibration")) {
                    info.resetStart();
                }
                if (info.getStart() != null) {
                    ++startcount;
                }
                algoInfos.add(info);
            }
            rs.close();
            ps.close();
            con.close();
            returnHashtable.put("Collection", algoInfos);
            String startable = "true";
            if (startcount == 0) {
                startable = "false";
            }
            returnHashtable.put("Startable", startable);
            return returnHashtable;
        }
        catch (SQLException ex) {
            System.out.println("Caught SQLException!");
            throw new TmaGlobalException(ex.getMessage());
        }
        catch (NamingException ex) {
            System.out.println("Caught NamingException!");
            throw new TmaGlobalException(ex.getMessage());
        }
    }

    public Collection getAllPunchimageExtendedVOs(Long sectionimageId) throws TmaGlobalException {
        this.log.debug("getAllPunchimageExtendedVOs(java.lang.Long sectionimageId): begin");
        ArrayList<PunchimageExtendedVO> results = new ArrayList<PunchimageExtendedVO>();
        try {
            InitialContext ctx = new InitialContext();
            Connection con = null;
            DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/MySqlDS");
            con = ds.getConnection();
            StringBuffer sql_buf = new StringBuffer("SELECT");
            sql_buf.append(" ");
            sql_buf.append("Arraypunchassociation.ApassociationID,Arraypunchassociation.ArrayblockID,");
            sql_buf.append("Arraypunchassociation.Sectrow,Arraypunchassociation.Sectcolumn,Arraypunchassociation.DonorID,");
            sql_buf.append("Punch.PunchID,Punch.SectionID,");
            sql_buf.append("Punchimages.ImageID,Punchimages.SectionimageID,Punchimages.Image,Punchimages.Imagename");
            sql_buf.append(" ");
            sql_buf.append("FROM Punch,Punchimages,Arraypunchassociation");
            sql_buf.append(" ");
            sql_buf.append("WHERE Arraypunchassociation.ApassociationID=Punch.ApassociationID AND Punch.PunchID=Punchimages.PunchID");
            sql_buf.append(" ");
            sql_buf.append("AND Punchimages.SectionimageID='" + sectionimageId.toString() + "'");
            PreparedStatement ps = con.prepareStatement(sql_buf.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PunchimageExtendedVO result = new PunchimageExtendedVO();
                result.setApassociationId(new Long(rs.getLong("ApassociationID")));
                result.setArrayBlockID(new Long(rs.getLong("ArrayblockID")));
                result.setRow(new Integer(rs.getInt("Sectrow")));
                result.setColumn(new Integer(rs.getInt("Sectcolumn")));
                result.setDonorID(new Long(rs.getLong("DonorID")));
                result.setPunchID(new Long(rs.getLong("PunchID")));
                result.setSectionID(new Long(rs.getLong("SectionID")));
                result.setImageID(new Long(rs.getLong("ImageID")));
                result.setSectionImageID(new Long(rs.getLong("SectionimageID")));
                result.setImageName(rs.getString("Imagename"));
                result.setImage(rs.getBytes("Image"));
                results.add(result);
            }
            rs.close();
            ps.close();
            con.close();
        }
        catch (SQLException ex) {
            System.out.println("getAllPunchimageExtendedVOs:Caught SQLException!");
            throw new TmaGlobalException(ex.getMessage());
        }
        catch (NamingException ex) {
            System.out.println("getAllPunchimageExtendedVOs:Caught NamingException!");
            throw new TmaGlobalException(ex.getMessage());
        }
        return results;
    }

    public void startAnalysisOnPunch(String algorithmname, Long punchId, Hashtable analysisparameter) throws TmaGlobalException {
        this.log.debug("startAnalysisOnPunch(java.lang.String algorithmname, java.lang.Long punchId, java.util.Hashtable analysisparameter): begin");
        if (!this.existJNDI(algorithmname)) {
            throw new TmaGlobalException("Algorithm not deployed");
        }
        try {
            InitialContext ctx = new InitialContext();
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("java:/JmsXA");
            Queue executeAlgorithmQueue = (Queue)ctx.lookup("queue/AlgorithmQueue");
            QueueConnection con = factory.createQueueConnection();
            QueueSession session = con.createQueueSession(true, 1);
            QueueSender sender = session.createSender(executeAlgorithmQueue);
            ObjectMessage objectMessage = session.createObjectMessage();
            objectMessage.setStringProperty("Algorithm", algorithmname);
            objectMessage.setLongProperty("punchID", punchId.longValue());
            objectMessage.setObject((Serializable)analysisparameter);
            sender.send((Message)objectMessage);
            sender.close();
            session.close();
            con.close();
        }
        catch (NamingException namingExc) {
            this.log.error("Cannont find AlgorithmQueue: " + namingExc);
            throw new TmaGlobalException(namingExc.getMessage());
        }
        catch (JMSException jmsExc) {
            this.log.error("JMSException thrown");
            throw new TmaGlobalException(jmsExc.getMessage());
        }
    }

    public void startAnalysisOnPunches(String algorithmname, Vector punchIds, Hashtable analysisparameter) throws TmaGlobalException {
        this.log.debug("startAnalysisOnPunches(java.lang.String algorithname, java.util.Vector punchIds, java.util.Hashtable analysisparameter): begin");
        if (!this.existJNDI(algorithmname)) {
            throw new TmaGlobalException("Algorithm not deployed");
        }
        try {
            InitialContext ctx = new InitialContext();
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("java:/JmsXA");
            Queue executeAlgorithmQueue = (Queue)ctx.lookup("queue/AlgorithmQueue");
            QueueConnection con = factory.createQueueConnection();
            QueueSession session = con.createQueueSession(true, 1);
            QueueSender sender = session.createSender(executeAlgorithmQueue);
            Iterator iter = punchIds.iterator();
            while (iter.hasNext()) {
                ObjectMessage objectMessage = session.createObjectMessage();
                objectMessage.setStringProperty("Algorithm", algorithmname);
                Long punchid = (Long)iter.next();
                objectMessage.setLongProperty("punchID", punchid.longValue());
                objectMessage.setObject((Serializable)analysisparameter);
                sender.send((Message)objectMessage);
            }
            sender.close();
            session.close();
            con.close();
        }
        catch (NamingException namingExc) {
            this.log.error("Cannont find AlgorithmQueue: " + namingExc);
            throw new TmaGlobalException(namingExc.getMessage());
        }
        catch (JMSException jmsExc) {
            this.log.error("JMSException thrown");
            throw new TmaGlobalException(jmsExc.getMessage());
        }
    }

    public void startAnalysisOnSection(Long sectionId, String algorithmname, Hashtable analysisparameter) throws TmaGlobalException {
        this.log.debug("startAnalysisOnSection(java.lang.Long sectionId, java.lang.String algorithmname, java.util.Hashtable analysisparameter): begin");
        if (!this.existJNDI(algorithmname)) {
            throw new TmaGlobalException("Algorithm not deployed");
        }
        try {
            InitialContext ctx = new InitialContext();
            QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup("java:/JmsXA");
            Queue executeAlgorithmQueue = (Queue)ctx.lookup("queue/AlgorithmQueue");
            QueueConnection con = factory.createQueueConnection();
            QueueSession session = con.createQueueSession(true, 1);
            QueueSender sender = session.createSender(executeAlgorithmQueue);
            ObjectMessage objectMessage = session.createObjectMessage();
            objectMessage.setStringProperty("Algorithm", algorithmname);
            objectMessage.setLongProperty("sectionID", sectionId.longValue());
            objectMessage.setObject((Serializable)analysisparameter);
            sender.send((Message)objectMessage);
            sender.close();
            session.close();
            con.close();
        }
        catch (NamingException namingExc) {
            this.log.error("Cannont find AlgorithmQueue: " + namingExc);
            throw new TmaGlobalException(namingExc.getMessage());
        }
        catch (JMSException jmsExc) {
            this.log.error((Object)jmsExc);
            throw new TmaGlobalException(jmsExc.getMessage());
        }
        catch (Exception ex) {
            throw new TmaGlobalException(ex.getMessage());
        }
    }

    public void deleteSectionResults(Long sectionId) throws TmaGlobalException {
        this.log.debug("deleteSectionResults: sectionId= " + sectionId);
        Section sectionEntity = null;
        try {
            sectionEntity = SectionUtil.getLocalHome().findByPrimaryKey(sectionId);
            SectionVO sectionVO = (SectionVO)ValueTreeBuilder.getValueTree(sectionEntity, ValueTreeBuilder.createIncludeTree("Punchs,Punchs.Results,Punchs.Results.Algorithm"));
            Collection punchs = sectionVO.getPunchs();
            this.log.info("deleteSectionResults: found " + punchs.size() + " punchs");
            Iterator punch_iter = punchs.iterator();
            while (punch_iter.hasNext()) {
                Collection results = new ArrayList();
                results = ((PunchVO)punch_iter.next()).getResults();
                Iterator results_iter = results.iterator();
                while (results_iter.hasNext()) {
                    ResultVO resultVO = (ResultVO)results_iter.next();
                    Long algopersecId = this.getAlgorithmpersectionID(sectionId, resultVO.getAlgorithm().getAlgorithmId());
                    System.out.println("algorithmID:" + resultVO.getAlgorithm().getAlgorithmId());
                    System.out.println(algopersecId);
                    this.removeResult(resultVO.getResultId());
                    if (algopersecId == null) continue;
                    this.removeAlgorithmspersection(algopersecId);
                }
            }
        }
        catch (FinderException fex) {
            this.log.error("deleteSectionResults: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("deleteSectionResults: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Collection getSectionResults(Long sectionId) throws TmaGlobalException {
        ArrayList<ResultVO> results_col = new ArrayList<ResultVO>();
        Section sectionEntity = null;
        try {
            sectionEntity = SectionUtil.getLocalHome().findByPrimaryKey(sectionId);
            Collection punchs = sectionEntity.getPunchs();
            this.log.info("getSectionResults: found " + punchs.size() + " punchs");
            Iterator punch_iter = punchs.iterator();
            while (punch_iter.hasNext()) {
                Collection results = new ArrayList();
                results = ((Punch)punch_iter.next()).getResults();
                Iterator result_iter = results.iterator();
                while (result_iter.hasNext()) {
                    results_col.add((ResultVO)ValueTreeBuilder.getValueTree((Result)result_iter.next(), ValueTreeBuilder.createIncludeTree("Algorithm")));
                }
            }
        }
        catch (FinderException fex) {
            this.log.error("deleteSectionResults: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("deleteSectionResults: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return results_col;
    }

    public ArrayList getPunchImagesBySectionimageID(Long sectionimageId) throws TmaGlobalException {
        this.log.debug("getPunchImagesBySectionimageID: begin sectionimageId=" + sectionimageId);
        ArrayList<PunchimageVO> ret = new ArrayList<PunchimageVO>();
        Sectionimage entity = this.getSectionimageByID(sectionimageId);
        Collection punchimages = entity.getPunchimages();
        Iterator iter = punchimages.iterator();
        while (iter.hasNext()) {
            Punchimage punchimage = (Punchimage)iter.next();
            PunchimageVO returnVO = (PunchimageVO)ValueTreeBuilder.getValueTree(punchimage, ValueTreeBuilder.createIncludeTree(""));
            ret.add(returnVO);
        }
        return ret;
    }

    public ArrayblockVO getArrayblockVOBySectionID(Long sectionId) throws TmaGlobalException {
        this.log.debug("getArrayblockVOBySectionID: begin sectionId=" + sectionId);
        return this.getArrayblockVO(sectionId);
    }

    public Dimension getArrayDimensionBySectionID(Long sectionId) throws TmaGlobalException {
        this.log.debug("getArrayDimensionBySectionID: begin sectionId=" + sectionId);
        ArrayblockVO vo = this.getArrayblockVO(sectionId);
        return this.getDimension(vo);
    }

    public Dimension getArrayDimension(ArrayblockVO arrayblockVO) throws TmaGlobalException {
        this.log.debug("getArrayDimension: begin");
        return this.getDimension(arrayblockVO);
    }

    public Vector getEmptyArrayPositions(ArrayblockVO arrayblockVO) throws TmaGlobalException {
        this.log.debug("getEmptyArrayPositions: begin");
        Vector ret = null;
        try {
            Iterator iter = arrayblockVO.getArraytype().getEmptyarraypositions().iterator();
            while (iter.hasNext()) {
                EmptyarraypositionVO emptyarraypositionVo = (EmptyarraypositionVO)iter.next();
                Dimension dim = null;
                dim.setSize(emptyarraypositionVo.getColoumn(), emptyarraypositionVo.getRow());
                ret.add(dim);
            }
        }
        catch (Exception ex) {
            this.log.error("getEmptyArrayPositions: Exception thrown");
            this.log.error(ex);
            throw new TmaGlobalException(ex.getMessage());
        }
        return ret;
    }

    public Vector getOccupiedArrayPositions(ArrayblockVO arrayblockVO) throws TmaGlobalException {
        this.log.debug("getOccupiedArrayPositions: begin");
        Vector<Dimension> ret = new Vector<Dimension>();
        try {
            Iterator iter = arrayblockVO.getArraypunchassociations().iterator();
            while (iter.hasNext()) {
                ArraypunchassociationVO arraypunchassociationVo = (ArraypunchassociationVO)iter.next();
                Dimension dim = new Dimension();
                dim.setSize(arraypunchassociationVo.getSectcolumn().doubleValue(), arraypunchassociationVo.getSectrow().doubleValue());
                ret.add(dim);
            }
        }
        catch (Exception ex) {
            this.log.error("getOccupiedArrayPositions: Exception thrown");
            this.log.error(ex);
            throw new TmaGlobalException(ex.getMessage());
        }
        return ret;
    }

    public boolean canStartRGCalibration(Long sectionId) throws TmaGlobalException {
        this.log.debug("canStartRGCalibration:begin sectionId=" + sectionId);
        boolean green = false;
        boolean red = false;
        SectionVO section_vo = this.getSectionVOById(sectionId, "Sectionimages,Sectionimages.Staining.DatadictionaryColor");
        if (!section_vo.getSectionimages().isEmpty()) {
            Collection sectionimages = section_vo.getSectionimages();
            Iterator iter = sectionimages.iterator();
            while (iter.hasNext()) {
                SectionimageVO sectionimage_vo = (SectionimageVO)iter.next();
                if (sectionimage_vo.getStaining() == null) continue;
                String color = sectionimage_vo.getStaining().getDatadictionaryColor().getDatavalue();
                if (color.equalsIgnoreCase("Cy3") && sectionimage_vo.getGridded().equals(new Integer(1))) {
                    red = true;
                }
                if (!color.equalsIgnoreCase("Cy5") || !sectionimage_vo.getGridded().equals(new Integer(1))) continue;
                green = true;
            }
        }
        return red && green;
    }

    public Hashtable getSectionImageIDs(Long sectionId) throws TmaGlobalException {
        this.log.debug("getSectionImageIDs:begin sectionId=" + sectionId);
        Hashtable<String, Long> ret = new Hashtable<String, Long>();
        SectionVO section_vo = this.getSectionVOById(sectionId, "Sectionimages,Sectionimages.Staining,Sectionimages.Staining.DatadictionaryColor");
        if (!section_vo.getSectionimages().isEmpty()) {
            Collection sectionimages = section_vo.getSectionimages();
            Iterator iter = sectionimages.iterator();
            while (iter.hasNext()) {
                SectionimageVO sectionimage_vo = (SectionimageVO)iter.next();
                String color = sectionimage_vo.getStaining() == null ? "unstained" : sectionimage_vo.getStaining().getDatadictionaryColor().getDatavalue();
                ret.put(color, sectionimage_vo.getSectionimageId());
            }
        }
        return ret;
    }

    public Collection getPunchImagesByPunchID(Long punchId) throws TmaGlobalException {
        this.log.debug("getPunchImagesByPunchID: begin punchId=" + punchId);
        PunchVO punchvo = this.getPunchVOById(punchId);
        return punchvo.getPunchimages();
    }

    public void insertResult(AlgorithmVO algorithmVO, PunchVO punchVO, ArrayList punchimages, String resultName, String resultValue) throws TmaGlobalException {
        this.log.info("insertResult: begin algorithm=" + algorithmVO.getAlgorithmname() + ", punchID=" + punchVO.getPunchId() + ", resultName=" + resultName + ", resultValue=" + resultValue);
        ResultVO resVO = new ResultVO();
        resVO.setPunch(punchVO);
        resVO.setResultname(resultName);
        resVO.setResultvalue(resultValue);
        resVO.setAlgorithm(algorithmVO);
        resVO.setPunchimages(punchimages);
        Result entity = null;
        try {
            entity = ResultUtil.getLocalHome().create(resVO);
            this.log.info("insertResult(): finished id=" + entity.getResultId());
        }
        catch (CreateException cex) {
            this.log.error("insertResult: vo=" + resVO + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("insertResult: vo=" + resVO + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private ArrayblockVO getArrayblockVO(Long sectionId) throws TmaGlobalException {
        this.log.debug("getArrayblockVO: begin sectionId=" + sectionId);
        ArrayblockVO returnVO = this.getSectionVOById(sectionId, "Arrayblock,Arrayblock.Arraytype.*,Arrayblock.Arraypunchassociations").getArrayblock();
        this.log.debug("getArrayblockVO: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private Dimension getDimension(ArrayblockVO vo) throws TmaGlobalException {
        Dimension dim = new Dimension();
        try {
            dim.setSize(vo.getArraytype().getCols(), vo.getArraytype().getRows());
        }
        catch (Exception ex) {
            this.log.error("getArrayDimension: Exception thrown");
            this.log.error(ex);
            throw new TmaGlobalException(ex.getMessage());
        }
        return dim;
    }

    private Sectionimage getSectionimageByID(Long sectionimageId) throws TmaGlobalException {
        this.log.debug("getSectionimageByID: begin sectionimageId=" + sectionimageId);
        try {
            return SectionimageUtil.getLocalHome().findByPrimaryKey(sectionimageId);
        }
        catch (FinderException fex) {
            this.log.error("getArrayblockVOBySectionimageID:FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getArrayblockVOBySectionimageID: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private SectionVO getSectionVOById(Long id, String includetree) throws TmaGlobalException {
        this.log.debug("getSectionVOById: begin id=" + id + " includetree=" + includetree);
        Section entity = null;
        try {
            entity = SectionUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getSectionVOById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getSectionVOById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        SectionVO returnVO = (SectionVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includetree));
        this.log.debug("getSectionVOById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    private boolean existName(String algorithmname) throws TmaGlobalException {
        this.log.debug("existName: begin algorithmname=" + algorithmname);
        Algorithm entity = null;
        try {
            entity = AlgorithmUtil.getLocalHome().findAlgorithmByAlgorithmname(algorithmname);
            return true;
        }
        catch (FinderException fex) {
            this.log.debug("algorithmname not exists");
            return false;
        }
        catch (NamingException nex) {
            this.log.debug("existName(algorithmname=" + algorithmname + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private boolean existJNDI(String algorithmname) throws TmaGlobalException {
        this.log.debug("existJNDI: begin algorithmname=" + algorithmname);
        try {
            InitialContext iniContext = new InitialContext();
            Object ref = iniContext.lookup(algorithmname);
            iniContext.close();
            return true;
        }
        catch (NameNotFoundException nex) {
            this.log.debug("existJNDI:caught NameNotFoundException");
            return false;
        }
        catch (Exception ex) {
            this.log.debug("existJNDI(algorithmname=" + algorithmname + "):thrown");
            this.log.error(ex.getMessage());
            throw new TmaGlobalException(ex.getMessage());
        }
    }

    private void removeResult(Long id) throws TmaGlobalException {
        this.log.info("removeResult: begin id=" + id);
        Object entity = null;
        try {
            ResultUtil.getLocalHome().remove(id);
            this.log.info("removeResult: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeResult(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeResult(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private void removeAlgorithmspersection(Long id) throws TmaGlobalException {
        this.log.info("removeAlgorithmspersection: begin id=" + id);
        Object entity = null;
        try {
            AlgorithmspersectionUtil.getLocalHome().remove(id);
            this.log.info("removeAlgorithmspersection: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeAlgorithmspersection(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeAlgorithmspersection(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    private PunchVO getPunchVOById(Long id) throws TmaGlobalException {
        this.log.debug("getPunchVOById: begin id=" + id);
        Punch entity = null;
        try {
            entity = PunchUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("getPunchVOById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("getPunchVOById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        PunchVO returnVO = (PunchVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree("Punchimages"));
        this.log.info("getPunchVOById: finished successfuly");
        return returnVO;
    }

    private Long getAlgorithmpersectionID(Long sectionId, Long algorithmId) throws TmaGlobalException {
        try {
            this.log.debug("getAlgorithmpersectionID: begin algorithmId=" + algorithmId + " sectionId=" + sectionId);
            Collection algorithms = AlgorithmspersectionUtil.getLocalHome().findByAlgorithmId(algorithmId);
            Long ret = null;
            ArrayList items = new ArrayList(algorithms);
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                Algorithmspersection entity = (Algorithmspersection)iter.next();
                if (!entity.getSection().getSectionId().equals(sectionId)) continue;
                ret = entity.getApersectionId();
                break;
            }
            return ret;
        }
        catch (FinderException fex) {
            this.log.error("getAlgorithmpersectionID: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("getAlgorithmpersectionID: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }
}

