/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.entity.Datadictionary;
import at.tugraz.genome.tma.ejb.entity.DatadictionaryUtil;
import at.tugraz.genome.tma.ejb.vos.DatadictionaryVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DataDictionaryServiceBean
implements SessionBean {
    Log log = LogFactory.getLog(this.getClass());
    protected SessionContext _ctx = null;

    public Collection findByDataType(String datatype, Integer disable, String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findByDataType: begin");
            Collection items = DatadictionaryUtil.getLocalHome().findByDataType(datatype, disable);
            this.log.info("findByDataType: found " + items.size() + " items");
            ArrayList<DatadictionaryVO> vos = new ArrayList<DatadictionaryVO>();
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((DatadictionaryVO)ValueTreeBuilder.getValueTree((Datadictionary)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findByDataType: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("findByDataType: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public DatadictionaryVO findByValueAndType(String datavalue, String datatype, String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findByValueAndType: begin");
            Datadictionary entity = DatadictionaryUtil.getLocalHome().findByValueAndType(datavalue, datatype);
            DatadictionaryVO item = (DatadictionaryVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
            this.log.debug("findByValueAndType: found item vo=" + item);
            return item;
        }
        catch (ObjectNotFoundException onfex) {
            this.log.error("findByValueAndType: ObjectNotFoundException thrown");
            this.log.error((Object)onfex);
            throw new TmaGlobalException(onfex.getMessage());
        }
        catch (FinderException fex) {
            this.log.error("findByValueAndType: FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("findByValueAndType: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public Long addDatadictionary(DatadictionaryVO vo) throws TmaGlobalException {
        this.log.debug("addDatadictionary: begin vo=" + vo);
        Datadictionary entity = null;
        try {
            entity = DatadictionaryUtil.getLocalHome().create(vo);
            this.log.info("addDatadictionary(): finished id=" + entity.getDataId());
        }
        catch (CreateException cex) {
            this.log.error("addDatadictionary: vo=" + vo + "CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("addDatadictionary: vo=" + vo + "NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        return entity.getDataId();
    }

    public DatadictionaryVO findDatadictionaryById(Long id, String includeTree) throws TmaGlobalException {
        this.log.debug("findDatadictionaryById: begin id=" + id + " includeTree=" + includeTree);
        Datadictionary entity = null;
        try {
            entity = DatadictionaryUtil.getLocalHome().findByPrimaryKey(id);
        }
        catch (FinderException fex) {
            this.log.error("findDatadictionaryById(id=" + id + "): FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findDatadictionaryById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        DatadictionaryVO returnVO = (DatadictionaryVO)ValueTreeBuilder.getValueTree(entity, ValueTreeBuilder.createIncludeTree(includeTree));
        this.log.info("findDatadictionaryById: finished successfuly returnVO=" + returnVO);
        return returnVO;
    }

    public Collection findAllDatadictionarys(String includeTree) throws TmaGlobalException {
        try {
            this.log.debug("findAllDatadictionarys: includeTree=" + includeTree);
            Collection items = DatadictionaryUtil.getLocalHome().findAll();
            ArrayList<DatadictionaryVO> vos = new ArrayList<DatadictionaryVO>();
            this.log.info("findAllDatadictionarys: " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((DatadictionaryVO)ValueTreeBuilder.getValueTree((Datadictionary)iter.next(), ValueTreeBuilder.createIncludeTree(includeTree)));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAllDatadictionarys: FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAllDatadictionarys: NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void removeDatadictionaryById(Long id) throws TmaGlobalException {
        this.log.info("removeDatadictionaryById: begin id=" + id);
        Object entity = null;
        try {
            DatadictionaryUtil.getLocalHome().remove(id);
            this.log.info("removeDatadictionaryById: finished successfuly");
        }
        catch (RemoveException rex) {
            this.log.error("removeDatadictionaryById(id=" + id + "): RemoveException thrown");
            this.log.error((Object)rex);
            throw new TmaGlobalException(rex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("removeDatadictionaryById(id=" + id + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void updateDatadictionary(DatadictionaryVO vo) throws TmaGlobalException {
        this.log.info("updateDatadictionary: begin vo=" + vo);
        Datadictionary entity = null;
        Long id = vo.getDataId();
        if (id == null) {
            throw new TmaGlobalException("updateDatadictionary(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = DatadictionaryUtil.getLocalHome().findByPrimaryKey(id);
            entity.update(vo);
            this.log.info("updateDatadictionary: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateDatadictionary(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateDatadictionary(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateDatadictionary(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public void updateCMPDatadictionary(DatadictionaryVO vo) throws TmaGlobalException {
        this.log.info("updateDatadictionary: begin vo=" + vo);
        Datadictionary entity = null;
        Long id = vo.getDataId();
        if (id == null) {
            throw new TmaGlobalException("updateDatadictionary(vo=" + vo + "): the primaryKey of the vo is null!");
        }
        try {
            entity = DatadictionaryUtil.getLocalHome().findByPrimaryKey(id);
            entity.updateCMP(vo);
            this.log.info("updateCMPDatadictionary: finished successfuly");
        }
        catch (FinderException fex) {
            this.log.error("updateCMPDatadictionary(vo=" + vo + "): FinderException thrown");
            this.log.error((Object)fex);
            throw new TmaGlobalException(fex.getMessage());
        }
        catch (NamingException nex) {
            this.log.error("updateCMPDatadictionary(vo=" + vo + "): NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
        catch (CreateException cex) {
            this.log.error("updateCMPDatadictionary(vo=" + vo + "): javax.ejb.CreateException thrown");
            this.log.error((Object)cex);
            throw new TmaGlobalException(cex.getMessage());
        }
    }

    public abstract Collection findAllPersons() throws TmaGlobalException;

    public abstract Collection findAllSpecies() throws TmaGlobalException;

    public abstract Collection findAllCustomer() throws TmaGlobalException;

    public abstract Collection findAllMicrotomeTypes() throws TmaGlobalException;

    public abstract Collection findAllParaffinTypes() throws TmaGlobalException;

    public abstract Collection findAllSlideTypes() throws TmaGlobalException;

    public abstract Collection findAllDeyingMethods() throws TmaGlobalException;

    public abstract Collection findAllCutter() throws TmaGlobalException;

    public abstract Collection findAllCompanies() throws TmaGlobalException;

    public abstract Collection findAllIgTypes() throws TmaGlobalException;

    public abstract Collection findAllColors() throws TmaGlobalException;

    public abstract Collection findAllDomains() throws TmaGlobalException;

    public abstract Collection findAllAntibodyTypes() throws TmaGlobalException;

    public abstract Collection findAllSites() throws TmaGlobalException;

    public abstract Collection findAllSources() throws TmaGlobalException;

    public abstract void ejbCreate() throws CreateException;

    public void ejbPostCreate() throws CreateException {
    }

    public void setSessionContext(SessionContext ctx) {
        this._ctx = ctx;
    }

    protected SessionContext getSessionContext() {
        return this._ctx;
    }
}

