/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.entity.Datadictionary;
import at.tugraz.genome.tma.ejb.entity.DatadictionaryUtil;
import at.tugraz.genome.tma.ejb.service.DataDictionaryServiceBean;
import at.tugraz.genome.tma.ejb.vos.DatadictionaryVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import at.tugraz.genome.voutils.ValueTreeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

public class DataDictionaryServiceBeanImpl
extends DataDictionaryServiceBean
implements SessionBean {
    private SessionContext context;

    public Collection findAllPersons() throws TmaGlobalException {
        this.log.debug("findAllPerson(): begin");
        return this.findAllDatadictionaryDataByDomain("PERSON");
    }

    public Collection findAllSpecies() throws TmaGlobalException {
        this.log.debug("findAllSpecies(): begin");
        return this.findAllDatadictionaryDataByDomain("SPECIES");
    }

    public Collection findAllCustomer() throws TmaGlobalException {
        this.log.debug("findAllCustomer(): begin");
        return this.findAllDatadictionaryDataByDomain("CUSTOMER");
    }

    public Collection findAllMicrotomeTypes() throws TmaGlobalException {
        this.log.debug("findAllMicrotomeTypes(): begin");
        return this.findAllDatadictionaryDataByDomain("MICROTOME");
    }

    public Collection findAllParaffinTypes() throws TmaGlobalException {
        this.log.debug("findAllParaffinTyps(): begin");
        return this.findAllDatadictionaryDataByDomain("PARAFFIN");
    }

    public Collection findAllSlideTypes() throws TmaGlobalException {
        this.log.debug("findAllSlideTypes(): begin");
        return this.findAllDatadictionaryDataByDomain("SLIDE");
    }

    public Collection findAllDeyingMethods() throws TmaGlobalException {
        this.log.debug("findAllDeyingMethods(): begin");
        return this.findAllDatadictionaryDataByDomain("DYEINGMETHOD");
    }

    public Collection findAllCutter() throws TmaGlobalException {
        this.log.debug("findAllCutter(): begin");
        return this.findAllDatadictionaryDataByDomain("CUTTER");
    }

    public Collection findAllCompanies() throws TmaGlobalException {
        this.log.debug("findAllCompanies(): begin");
        return this.findAllDatadictionaryDataByDomain("COMPANY");
    }

    public Collection findAllIgTypes() throws TmaGlobalException {
        this.log.debug("findAllIgTypes(): begin");
        return this.findAllDatadictionaryDataByDomain("IGTYPE");
    }

    public Collection findAllAntibodyTypes() throws TmaGlobalException {
        this.log.debug("findAllAntibodyTypes(): begin");
        return this.findAllDatadictionaryDataByDomain("ANTIBODYTYPE");
    }

    public Collection findAllColors() throws TmaGlobalException {
        this.log.debug("findAllColors(): begin");
        return this.findAllDatadictionaryDataByDomain("COLOR");
    }

    public Collection findAllSites() throws TmaGlobalException {
        this.log.debug("findAllSites(): begin");
        return this.findAllDatadictionaryDataByDomain("SITE");
    }

    public Collection findAllSources() throws TmaGlobalException {
        this.log.debug("findAllSources(): begin");
        return this.findAllDatadictionaryDataByDomain("SOURCE");
    }

    public Collection findAllDomains() throws TmaGlobalException {
        this.log.debug("findAllDomains(): begin");
        return this.findAllDatadictionaryDataByDomain("DOMAIN");
    }

    private Collection findAllDatadictionaryDataByDomain(String domain) throws TmaGlobalException {
        try {
            Collection items = DatadictionaryUtil.getLocalHome().findByDataType(domain, new Integer(0));
            ArrayList<DatadictionaryVO> vos = new ArrayList<DatadictionaryVO>();
            this.log.info("findAll" + domain + ": " + items.size() + " items found");
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                vos.add((DatadictionaryVO)ValueTreeBuilder.getValueTree((Datadictionary)iter.next(), ValueTreeBuilder.createIncludeTree("")));
            }
            return vos;
        }
        catch (FinderException fex) {
            this.log.error("findAll" + domain + ":  FinderException thrown");
            this.log.error((Object)fex);
            return null;
        }
        catch (NamingException nex) {
            this.log.error("findAll" + domain + ": NamingException thrown");
            this.log.error(nex);
            throw new TmaGlobalException(nex.getMessage());
        }
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }
}

