/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.service;

import at.tugraz.genome.tma.ejb.service.ImageServiceBean;
import at.tugraz.genome.tma.ejb.vos.SmallimageVO;
import at.tugraz.genome.tma.exceptions.TmaGlobalException;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class ImageServiceBeanImpl
extends ImageServiceBean
implements SessionBean {
    private SessionContext context;

    public SmallimageVO createSmallimageVO(String imagename, byte[] image) throws TmaGlobalException {
        this.log.debug("createSmallimageVO: begin");
        SmallimageVO smallimageVO = null;
        if (imagename.trim().toLowerCase().endsWith("tif") || imagename.trim().toLowerCase().endsWith("tiff")) {
            this.log.debug("Tiff image, create jpeg image");
            try {
                smallimageVO = this.createJpgImage(image);
            }
            catch (IOException ioex) {
                this.log.debug("Caught IOException in createJpgImage()");
                this.log.error(ioex);
                throw new TmaGlobalException("Caught IOException in createJpgImage()");
            }
            catch (ImageFormatException imgex) {
                this.log.debug("Caught ImageFormatException in createImgVoWithThumbnail()");
                this.log.error((Object)imgex);
                throw new TmaGlobalException("Caught ImageFormatException in createJpgImage()");
            }
        } else if (imagename.trim().toLowerCase().endsWith("jpg") || imagename.trim().toLowerCase().endsWith("jpeg")) {
            this.log.debug("Jpeg image");
            if (image != null) {
                smallimageVO = new SmallimageVO();
                smallimageVO.setImage(image);
                smallimageVO.setScalefactor(new Float(1.0f));
            }
        } else {
            this.log.error("createDonorImageCollection: Wrong Image Format");
            throw new TmaGlobalException("Wrong Image Format: Only jpeg- and tiff-images are supported (*.jpeg,*.jpg,*.tiff,*.tif)");
        }
        return smallimageVO;
    }

    private SmallimageVO createJpgImage(byte[] image) throws IOException, ImageFormatException {
        this.log.debug("Begin createJpgImage");
        JPEGImageEncoder encoder = null;
        ParameterBlock params = null;
        ByteArrayOutputStream jpegObjStream = null;
        TIFFDecodeParam decodeParam = null;
        RenderedOp tiffobj = null;
        JPEGEncodeParam jpegParams = null;
        Object newDescription = null;
        SmallimageVO jpegvo = new SmallimageVO();
        params = new ParameterBlock();
        params.add(new ByteArraySeekableStream(image));
        jpegObjStream = new ByteArrayOutputStream();
        decodeParam = new TIFFDecodeParam();
        decodeParam.setDecodePaletteAsShorts(true);
        tiffobj = JAI.create((String)"tiff", (ParameterBlock)params);
        encoder = JPEGCodec.createJPEGEncoder((OutputStream)jpegObjStream);
        jpegParams = encoder.getDefaultJPEGEncodeParam(tiffobj.getAsBufferedImage());
        jpegParams.setQuality(0.1f, true);
        encoder.encode(this.scaleToSize(400, 600, tiffobj.getAsBufferedImage()));
        jpegvo.setScalefactor(new Float(ImageServiceBeanImpl.calculateScaleFactor(400, 600, tiffobj.getAsBufferedImage())));
        jpegObjStream.flush();
        jpegvo.setImage(jpegObjStream.toByteArray());
        return jpegvo;
    }

    private BufferedImage scaleToSize(int nMaxWidth, int nMaxHeight, BufferedImage imgSrc) {
        int nHeight = imgSrc.getHeight();
        int nWidth = imgSrc.getWidth();
        double scaleX = (double)nMaxWidth / (double)nWidth;
        double scaleY = (double)nMaxHeight / (double)nHeight;
        double fScale = Math.min(scaleX, scaleY);
        return this.scale(fScale, imgSrc);
    }

    private BufferedImage scale(double scale, BufferedImage srcImg) {
        if (scale == 1.0) {
            return srcImg;
        }
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), null);
        return op.filter(srcImg, null);
    }

    public static double calculateScaleFactor(int nMaxWidth, int nMaxHeight, BufferedImage imgSrc) {
        int nHeight = imgSrc.getHeight();
        int nWidth = imgSrc.getWidth();
        double scaleX = (double)nMaxWidth / (double)nWidth;
        double scaleY = (double)nMaxHeight / (double)nHeight;
        double fScale = Math.min(scaleX, scaleY);
        return fScale;
    }

    public void setSessionContext(SessionContext ctx) {
        this.context = ctx;
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws CreateException {
    }
}

