/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.vos;

import at.tugraz.genome.tma.ejb.vos.DonorVO;
import at.tugraz.genome.tma.ejb.vos.TissueVO;
import at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO;
import java.io.Serializable;
import java.util.Date;

public class DonorReportVO
implements Serializable {
    private Long donorid;
    private Long barcodeid;
    private String corecomment;
    private Date date;
    private Long tissueid;
    private Long sampleid;
    private String topography;
    private String morphology;
    private String person;
    private SubmitterVO userVO = null;
    private Long userid;
    private String deletable = null;

    public DonorReportVO() {
    }

    public DonorReportVO(DonorVO vo) {
        this.donorid = vo.getDonorId();
        this.barcodeid = vo.getBarcodeId();
        this.corecomment = vo.getCorecomment();
        this.userVO = vo.getUserVO();
        this.userid = vo.getUserid();
        this.date = vo.getDate();
        TissueVO tissue = vo.getTissue();
        this.tissueid = tissue.getTissueId();
        this.sampleid = tissue.getSampleId();
        this.topography = tissue.getTopography().getTopography();
        this.morphology = tissue.getMorphology().getMorphology();
        this.person = vo.getDatadictionaryPerson().getDatavalue();
        if (vo.getArrayblocks().isEmpty()) {
            this.deletable = "on";
        }
    }

    public Long getDonorid() {
        return this.donorid;
    }

    public Long getTissueid() {
        return this.tissueid;
    }

    public Long getSampleid() {
        return this.sampleid;
    }

    public String getTopography() {
        return this.topography;
    }

    public String getMorphology() {
        return this.morphology;
    }

    public Date getDate() {
        return this.date;
    }

    public Long getBarcodeid() {
        return this.barcodeid;
    }

    public String getCorecomment() {
        return this.corecomment;
    }

    public String getPerson() {
        return this.person;
    }

    public SubmitterVO getUserVO() {
        return this.userVO;
    }

    public Long getUserid() {
        return this.userid;
    }

    public String getDeletable() {
        return this.deletable;
    }
}

