/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.vos;

import at.tugraz.genome.tma.ejb.vos.SectionVO;
import at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO;
import java.io.Serializable;
import java.util.Date;

public class SectionReportVO
implements Serializable {
    private Long barcodeId;
    private Long sectionId;
    private String sectionnumber;
    private Date date;
    private String series;
    private String thickness;
    private String cutter;
    private String microtometype;
    private String slidetype;
    private String paraffintype;
    private String customer;
    private String person;
    private String arrayblockbarcode;
    private String arrayblockname;
    private SubmitterVO userVO = null;
    private Long userid;
    private String deletable = null;
    private String algorithmStartable = null;

    public SectionReportVO() {
    }

    public SectionReportVO(SectionVO vo) {
        this.barcodeId = vo.getBarcodeId();
        this.sectionnumber = vo.getSectionnumber().toString();
        this.userVO = vo.getUserVO();
        this.userid = vo.getUserid();
        this.date = vo.getDate();
        this.series = vo.getSeries().toString();
        this.thickness = vo.getThickness().toString();
        this.cutter = vo.getDatadictionaryCutter().getDatavalue();
        this.customer = vo.getDatadictionaryCustomer().getDatavalue();
        this.microtometype = vo.getDatadictionaryMicrotometype().getDatavalue();
        this.slidetype = vo.getDatadictionarySlidetype().getDatavalue();
        this.paraffintype = vo.getDatadictionaryParaffintype().getDatavalue();
        this.sectionId = vo.getSectionId();
        this.person = vo.getDatadictionaryPerson().getDatavalue();
        this.arrayblockbarcode = vo.getArrayblock().getBarcodeId().toString();
        this.arrayblockname = vo.getArrayblock().getName();
        if (vo.getStained() == 0) {
            this.deletable = "on";
        }
        if (!vo.getPunchs().isEmpty()) {
            this.algorithmStartable = "on";
        }
    }

    public String getSeries() {
        return this.series;
    }

    public String getMicrotometype() {
        return this.microtometype;
    }

    public String getSlidetype() {
        return this.slidetype;
    }

    public String getParaffintype() {
        return this.paraffintype;
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getThickness() {
        return this.thickness;
    }

    public Date getDate() {
        return this.date;
    }

    public Long getBarcodeId() {
        return this.barcodeId;
    }

    public Long getSectionId() {
        return this.sectionId;
    }

    public String getSectionnumber() {
        return this.sectionnumber;
    }

    public String getCutter() {
        return this.cutter;
    }

    public SubmitterVO getUserVO() {
        return this.userVO;
    }

    public Long getUserid() {
        return this.userid;
    }

    public String getPerson() {
        return this.person;
    }

    public String getArrayblockbarcode() {
        return this.arrayblockbarcode;
    }

    public String getArrayblockname() {
        return this.arrayblockname;
    }

    public String getDeletable() {
        return this.deletable;
    }

    public String getAlgorithmStartable() {
        return this.algorithmStartable;
    }
}

