/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.vos;

import java.io.Serializable;

public class TissueDonorResultVO
implements Serializable {
    private int line;
    private boolean error;
    private String sample;
    private String topography;
    private String morphology;
    private String behaviour;
    private String grade;
    private String species;
    private String tissuecomment;
    private String barcode;
    private String corecomment;
    private Long tissueID;
    private Long sampleID;
    private Long topographyID;
    private Long behaviourID;
    private Long gradeID;
    private Long barcodeID;
    private Long morphologyID;

    public int getLine() {
        return this.line;
    }

    public boolean getError() {
        return this.error;
    }

    public String getSample() {
        return this.sample;
    }

    public String getTopography() {
        return this.topography;
    }

    public String getMorphology() {
        return this.morphology;
    }

    public String getBehaviour() {
        return this.behaviour;
    }

    public String getGrade() {
        return this.grade;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getTissueComment() {
        return this.tissuecomment;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public String getCorecomment() {
        return this.corecomment;
    }

    public Long getTissueID() {
        return this.tissueID;
    }

    public Long getSampleID() {
        return this.sampleID;
    }

    public Long getMorphologyID() {
        return this.morphologyID;
    }

    public Long getTopographyID() {
        return this.topographyID;
    }

    public Long getBarcodeID() {
        return this.barcodeID;
    }

    public Long getGradeID() {
        return this.gradeID;
    }

    public Long getBehaviourID() {
        return this.behaviourID;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setError(boolean b) {
        this.error = b;
    }

    public void setSample(String sample) {
        if (sample.length() == 0) {
            this.sample = this.Error("Missing SampleID!");
        } else {
            try {
                this.sampleID = new Long(sample);
                this.sample = sample;
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                this.sample = this.Error(sample);
            }
        }
    }

    public void setMorphology(String morphology) {
        if (morphology.length() == 0) {
            this.morphology = this.Error("Missing Morphologycode!");
        } else if (morphology.startsWith("M")) {
            try {
                this.morphologyID = new Long(morphology.substring(1));
                this.morphology = morphology;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.morphology = this.Error(morphology);
            }
        } else {
            this.morphology = this.Error(morphology);
        }
    }

    public void setMorphologyNotFound(String morphlogy) {
        this.morphology = this.Nonexistent(this.morphology);
    }

    public void setBehaviour(String behaviour) {
        if (behaviour.length() == 0) {
            this.behaviour = this.Error("Misssing Classifictioncode!");
        } else {
            try {
                this.behaviourID = new Long(behaviour);
                this.behaviour = behaviour;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.behaviour = this.Error(behaviour);
            }
        }
    }

    public void setBehaviourNotFound(String behaviour) {
        this.behaviour = this.Nonexistent(behaviour);
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public void setSpeciesMissing() {
        this.species = this.Error("Missing Speciescode!");
    }

    public void setSpeciesNotFound(String species) {
        this.species = this.Nonexistent(species);
    }

    public void setTopography(String topography) {
        if (topography.length() == 0) {
            this.topography = this.topography = this.Error("Missing Topographycode!");
        } else if ((topography.length() == 3 || topography.length() == 5) && topography.startsWith("C")) {
            try {
                StringBuffer topoBuf = new StringBuffer(topography.substring(1, 3));
                if (topography.length() == 5 && !topography.endsWith("9")) {
                    topoBuf.append(topography.charAt(4));
                }
                String topo = topoBuf.toString();
                System.out.print(topo);
                this.topographyID = new Long(topo);
                this.topography = topography;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.topography = this.Error(topography);
            }
        } else {
            this.topography = this.Error(topography);
        }
    }

    public void setTopographyNotFound(String topography) {
        this.topography = this.Nonexistent(topography);
    }

    public void setGrade(String grade) {
        if (grade.length() == 0) {
            this.grade = this.Error("Missing Gradecode!");
        } else {
            try {
                this.gradeID = new Long(grade);
                this.grade = grade;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.grade = this.Error(grade);
            }
        }
    }

    public void setGradeNotFound(String grade) {
        this.grade = this.Nonexistent(grade);
    }

    private String Nonexistent(String str) {
        this.error = true;
        return "<b style='color:red'> nonexistent: " + str + "</b>";
    }

    private String Error(String str) {
        this.error = true;
        return "<b style='color:red'>" + str + "</b>";
    }

    public void setTissueComment(String tissuecomment) {
        this.tissuecomment = tissuecomment;
    }

    public void setBarcode(String barcode) {
        if (barcode.length() == 0) {
            this.barcode = this.Error("Missing ParaffinID!");
        } else {
            try {
                this.barcodeID = new Long(barcode);
                this.barcode = barcode;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.barcode = this.Error(barcode);
            }
        }
    }

    public void setCorecomment(String corecomment) {
        this.corecomment = corecomment;
    }

    public void setTissueID(Long tissueID) {
        this.tissueID = tissueID;
    }
}

