/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.tma.ejb.vos;

import at.tugraz.genome.tma.ejb.vos.TissueVO;
import java.io.Serializable;

public class TissueReportVO
implements Serializable {
    private Long tissueid;
    private Long sampleid;
    private String tissuecomment;
    private String site;
    private String sourcedb;
    private String topography;
    private String morphology;
    private String behaviour;
    private String grade;
    private String species;
    private String icdo;
    private String deletable = null;

    public TissueReportVO() {
    }

    public TissueReportVO(TissueVO vo) {
        String site_ = "";
        if (vo.getDatadictionarySite() != null) {
            site_ = vo.getDatadictionarySite().getDatavalue();
        }
        String sourcedb_ = "";
        if (vo.getDatadictionarySource() != null) {
            sourcedb_ = vo.getDatadictionarySource().getDatavalue();
        }
        this.tissueid = vo.getTissueId();
        this.sampleid = vo.getSampleId();
        this.tissuecomment = vo.getTissuecomment();
        this.site = site_;
        this.sourcedb = sourcedb_;
        this.topography = vo.getTopography().getTopography();
        this.morphology = vo.getMorphology().getMorphology();
        this.behaviour = vo.getBehaviour().getBehaviour();
        this.grade = vo.getGrade().getGrade();
        this.species = vo.getDatadictionarySpecies().getDatavalue();
        if (vo.getDonors().isEmpty()) {
            this.deletable = "on";
        }
        StringBuffer icdo = new StringBuffer("C");
        icdo.append(vo.getTopography().getTopographyId());
        icdo.append(" M-");
        icdo.append(vo.getMorphology().getMorphologyId());
        icdo.append("/");
        int behav = vo.getBehaviour().getBehaviourId().intValue() - 1;
        icdo.append(behav);
        icdo.append(" ");
        icdo.append(vo.getGrade().getGradeId());
        this.icdo = icdo.toString();
    }

    public Long getTissueid() {
        return this.tissueid;
    }

    public Long getSampleid() {
        return this.sampleid;
    }

    public String getTissuecomment() {
        return this.tissuecomment;
    }

    public String getSite() {
        return this.site;
    }

    public String getSourcedb() {
        return this.sourcedb;
    }

    public String getTopography() {
        return this.topography;
    }

    public String getMorphology() {
        return this.morphology;
    }

    public String getBehaviour() {
        return this.behaviour;
    }

    public String getGrade() {
        return this.grade;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getIcdo() {
        return this.icdo;
    }

    public String getDeletable() {
        return this.deletable;
    }
}

