/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermUtilities.remote;

import at.tugraz.genome.usermUtilities.remote.UsermUtilitiesBusinessInterface;
import at.tugraz.genome.usermUtilities.remote.ejb.UserService;
import at.tugraz.genome.usermUtilities.remote.ejb.UserServiceHome;
import at.tugraz.genome.usermUtilities.remote.ejb.UserServiceUtil;
import at.tugraz.genome.usermUtilities.remote.vos.SubmitterVO;
import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBUsermUtilitiesBusinessDelegate
implements UsermUtilitiesBusinessInterface,
Serializable {
    protected static Log log = LogFactory.getLog("at.tugraz.genome.usermUtilities.remote.EJBUsermUtilitiesBusinessDelegate");
    private UserService userServiceSession;

    public EJBUsermUtilitiesBusinessDelegate(Hashtable environment) throws UserSecurityException {
        try {
            UserServiceHome userServiceHome = UserServiceUtil.getHome(environment);
            this.userServiceSession = userServiceHome.create();
            log.debug("successfuly created userServiceSession ");
        }
        catch (NamingException ex) {
            log.error("NamingException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
        catch (CreateException ex) {
            log.error("CreateException thrown!");
            log.error((Object)ex);
            throw new UserSecurityException((Throwable)ex);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public MessageBean changePassword(String username, String authenticationID, String oldPasswd, String newPasswd) throws UserSecurityException {
        try {
            return this.userServiceSession.changePassword(username, authenticationID, oldPasswd, newPasswd);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public Long getIdByUserName(String userName) throws UserSecurityException {
        try {
            return this.userServiceSession.getIdByUserName(userName);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public Vector getIDsByUserNameLike(String userName) throws UserSecurityException {
        try {
            return this.userServiceSession.getIDsByUserNameLike(userName);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public void setUserRights(String username, Collection toAdd, Collection toDel, String authenticationID, String loggedInUserName) throws UserSecurityException {
        try {
            this.userServiceSession.setUserRights(username, toAdd, toDel, authenticationID, loggedInUserName);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public SubmitterVO getSubmitter(Long id) throws UserSecurityException {
        try {
            return this.userServiceSession.getSubmitter(id);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public Collection getAllSubmitters(boolean includeInactive) throws UserSecurityException {
        try {
            return this.userServiceSession.getAllSubmitters(includeInactive);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public Long addSubmitter(SubmitterVO vo, String passwd, String loggedInUserName, String authenticationID, Collection toAdd, Collection toDel) throws UserSecurityException {
        try {
            return this.userServiceSession.addSubmitter(vo, passwd, loggedInUserName, authenticationID, toAdd, toDel);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }

    public void editSubmitter(SubmitterVO vo, String passwd, String loggedInUserName, String authenticationID, Collection toAdd, Collection toDel) throws UserSecurityException {
        try {
            this.userServiceSession.editSubmitter(vo, passwd, loggedInUserName, authenticationID, toAdd, toDel);
        }
        catch (RemoteException ex) {
            log.error("RemoteException thrown!");
            log.error(ex);
            throw new UserSecurityException((Throwable)ex);
        }
    }
}

