/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.sql;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.utils.UtilsConstants;
import at.tugraz.genome.utils.upload.vos.SharedVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SelectShared
extends Exception {
    private Connection conn = null;
    private String tablename;
    Logger log = null;

    public SelectShared(String tablename) throws EJBServerException {
        this.tablename = tablename;
        this.log = Logger.getLogger(this.getClass());
        this.log.info((Object)("SelectShared" + tablename));
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:jdbc/MySqlDS");
            this.conn = ds.getConnection();
        }
        catch (SQLException se) {
            this.log.error((Object)"Cannot connect to Database");
            EJBExceptionFactory.throwEJBServerException(UtilsConstants.getDatabase(), se.getMessage());
        }
        catch (NamingException ne) {
            this.log.error((Object)"Cannot connect to Database");
            EJBExceptionFactory.throwEJBServerException(UtilsConstants.getDatabase(), ne);
        }
    }

    public Collection findByUserId(Long id) throws EJBFinderException {
        Vector result = null;
        String where = " where ";
        if (id != null) {
            where = where + "userid ='" + id + "'";
        }
        UtilsConstants.getInstance();
        if (UtilsConstants.getGuestUserId() != null) {
            StringBuffer stringBuffer = new StringBuffer().append(where).append(" or userid ='");
            UtilsConstants.getInstance();
            where = stringBuffer.append(UtilsConstants.getGuestUserId()).append("'").toString();
        }
        try {
            result = this.createResult(where);
        }
        catch (Exception e) {
            this.log.error((Object)"EJBFinder Exception");
            EJBExceptionFactory.throwEJBFinderException(UtilsConstants.getDatabase(), e.getMessage());
        }
        return result;
    }

    public Collection getUsersByItemId(Long id) throws EJBFinderException {
        Vector<Long> result = new Vector<Long>();
        String sqlStatement = "select userid from shared" + this.tablename + " where (item = ?)";
        try {
            PreparedStatement pStmt = this.conn.prepareStatement(sqlStatement);
            pStmt.setLong(1, id);
            ResultSet rs = pStmt.executeQuery();
            while (rs.next()) {
                Long userID = new Long(rs.getLong(1));
                result.add(userID);
            }
            rs.close();
            pStmt.close();
        }
        catch (SQLException ex) {
            this.log.error((Object)ex);
            EJBExceptionFactory.throwEJBFinderException(UtilsConstants.getDatabase(), ex.getMessage());
        }
        return result;
    }

    private Vector createResult(String where) throws Exception {
        Vector<SharedVO> vector = new Vector<SharedVO>();
        long start = System.currentTimeMillis();
        this.log.debug((Object)"__________________________Create Result Shared______________________________");
        try {
            String query = "select * from shared" + this.tablename + " " + where;
            System.out.println("Query: " + query);
            this.log.debug((Object)("SQL QUERY :" + query));
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                SharedVO object = new SharedVO(new Long(rs.getLong(2)), new Long(rs.getLong(3)));
                vector.add(object);
            }
            rs.close();
            stmt.close();
            this.log.debug((Object)("Time [ms]: " + (System.currentTimeMillis() - start)));
        }
        catch (Exception e) {
            this.log.error((Object)("Error Selecting Shared" + this.tablename));
            throw e;
        }
        return vector;
    }

    public void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

