/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.sql;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.utils.UtilsConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class TransferOwnership {
    private PreparedStatement pStmtShared = null;
    private Logger log = null;
    private String tableName;
    private String fieldName;
    private String queryField;
    private Connection conn = null;

    public TransferOwnership(String tablename, String fieldName, String queryField) throws EJBServerException {
        this.tableName = tablename;
        this.fieldName = fieldName;
        this.queryField = queryField;
        this.log = Logger.getLogger(this.getClass());
        this.log.info((Object)("TransferOwnership" + tablename));
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:jdbc/MySqlDS");
            this.conn = ds.getConnection();
            String sql = "update " + this.tableName + " set " + fieldName + " = ? where " + queryField + " = ?)";
            this.pStmtShared = this.conn.prepareStatement(sql);
        }
        catch (SQLException se) {
            this.log.error((Object)"Cannot connect to Database");
            EJBExceptionFactory.throwEJBServerException(UtilsConstants.getDatabase(), se.getMessage());
        }
        catch (NamingException ne) {
            this.log.error((Object)"Cannot connect to Database");
            EJBExceptionFactory.throwEJBServerException(UtilsConstants.getDatabase(), ne);
        }
    }

    public void transferOwnership(Long newUserID, String queryField) throws EJBServerException {
        long start = System.currentTimeMillis();
        this.log.info((Object)("transferOwnership " + this.tableName));
        try {
            this.pStmtShared.setLong(1, newUserID);
            this.pStmtShared.setString(2, queryField);
            this.pStmtShared.executeUpdate();
            this.log.info((Object)("Time [ms]: " + (System.currentTimeMillis() - start)));
            this.log.info((Object)"... finished");
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1) {
                this.log.info((Object)"Object already exists!");
            }
            this.log.error((Object)e.getMessage());
            throw new EJBServerException("" + e);
        }
    }

    public void close() {
        try {
            if (this.pStmtShared != null) {
                this.pStmtShared.close();
            }
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

