/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.voutils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class ValueTreeBuilder {
    private static Category category = Category.getInstance((String)(class$at$tugraz$genome$voutils$ValueTreeBuilder == null ? (class$at$tugraz$genome$voutils$ValueTreeBuilder = ValueTreeBuilder.class$("at.tugraz.genome.voutils.ValueTreeBuilder")) : class$at$tugraz$genome$voutils$ValueTreeBuilder).getName());
    private static Class LOCAL_TAG_CLASS = class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = ValueTreeBuilder.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$at$tugraz$genome$voutils$ValueTreeBuilder;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Integer;

    public static IncludeTree createIncludeTree(String includePath) {
        return new IncludeTree(IncludeTreeNode.createTree(includePath));
    }

    public static Object getValueTree(Object local, IncludeTree includeTree) {
        HashMap visited = new HashMap();
        return ValueTreeBuilder.populateValueObject(local, visited, includeTree.getRootNode());
    }

    protected static Object populateValueObject(Object local, HashMap visited, IncludeTreeNode pathNode) {
        ValueTreeBuilder.debug("Processing : " + local.getClass().getName());
        Object value = null;
        try {
            value = visited.get(ValueTreeBuilder.getLocalObjectKey(local));
            if (value != null) {
                ValueTreeBuilder.debug("Object already processed, returning");
                return value;
            }
            ValueTreeBuilder.debug("Getting value object (calling getValueObject on local interface)");
            Method getValueObjectMethod = local.getClass().getMethod("getValueObject", null);
            value = getValueObjectMethod.invoke(local, null);
            visited.put(ValueTreeBuilder.getLocalObjectKey(local), value);
            Method[] methods = local.getClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method setMethod;
                IncludeTreeNode nextPathNode;
                String name = methods[i].getName();
                if (!name.startsWith("get") || name.equals("getValueObject")) continue;
                Class<?> returnType = methods[i].getReturnType();
                if (returnType.equals(class$java$util$Collection == null ? ValueTreeBuilder.class$("java.util.Collection") : class$java$util$Collection)) {
                    ValueTreeBuilder.debug("Found valid get method returning a Collection " + name);
                    nextPathNode = pathNode.getPathNode(name);
                    if (nextPathNode != null) {
                        ValueTreeBuilder.debug("Copying the collection for : " + nextPathNode);
                        ValueTreeBuilder.debug("Calling method : " + methods[i].getName());
                        Collection localObjectCollection = (Collection)methods[i].invoke(local, null);
                        String methodName = "set" + name.substring(3);
                        ValueTreeBuilder.debug("Looking for " + methodName + " in " + value.getClass());
                        Method[] detailMethods = value.getClass().getMethods();
                        setMethod = null;
                        for (int k = 0; k < detailMethods.length; ++k) {
                            Method method = detailMethods[k];
                            ValueTreeBuilder.debug("trying to match " + method.getName() + " with " + methodName);
                            if (method.getName().equals(methodName)) {
                                setMethod = method;
                                break;
                            }
                            if (!method.getName().equals(methodName + "s")) continue;
                            ValueTreeBuilder.debug("TOM: the plural form matches: " + methodName + "s");
                            setMethod = method;
                            break;
                        }
                        Class<?> valueObjectArrayClass = setMethod.getParameterTypes()[0];
                        Class<?> valueObjectClass = valueObjectArrayClass.getComponentType();
                        ValueTreeBuilder.debug("creating Value object array");
                        ArrayList<Object> valueObjectCollection = new ArrayList<Object>(localObjectCollection.size());
                        ValueTreeBuilder.debug("iterating over local objects in collection.");
                        if (localObjectCollection == null) continue;
                        Iterator localObjects = localObjectCollection.iterator();
                        int j = 0;
                        while (localObjects.hasNext()) {
                            Object newLocalObject = localObjects.next();
                            ValueTreeBuilder.debug("recursively calling populateValueObject");
                            Object newValueObject = ValueTreeBuilder.populateValueObject(newLocalObject, visited, nextPathNode);
                            ValueTreeBuilder.debug("back from calling populateValueObject");
                            valueObjectCollection.add(newValueObject);
                            ++j;
                        }
                        Object[] args = new Object[]{valueObjectCollection};
                        ValueTreeBuilder.debug("calling " + methodName);
                        setMethod.invoke(value, args);
                        ValueTreeBuilder.debug("collection copied to value object");
                        continue;
                    }
                    ValueTreeBuilder.debug("Collection ignored (not in path)");
                    continue;
                }
                Class<?>[] interfaces = returnType.getInterfaces();
                if (interfaces == null || interfaces.length <= 0 || !interfaces[0].equals(LOCAL_TAG_CLASS)) continue;
                ValueTreeBuilder.debug("Found valid get method : " + returnType + " " + name);
                nextPathNode = pathNode.getPathNode(name);
                if (nextPathNode != null) {
                    ValueTreeBuilder.debug("Copying local object");
                    Object newLocalObject = methods[i].invoke(local, null);
                    if (newLocalObject != null) {
                        ValueTreeBuilder.debug("Recursively calling populateValueObject");
                        Object newValueObject = ValueTreeBuilder.populateValueObject(newLocalObject, visited, nextPathNode);
                        ValueTreeBuilder.debug("Back from calling populateValueObject");
                        String methodName = "set" + name.substring(3);
                        ValueTreeBuilder.debug("Looking for " + methodName + "(...) in " + value.getClass());
                        setMethod = ValueTreeBuilder.getValueObjectMethod(methodName, value);
                        Object[] args = new Object[]{newValueObject};
                        setMethod.invoke(value, args);
                        ValueTreeBuilder.debug("Local object copied");
                        continue;
                    }
                    ValueTreeBuilder.debug("Local object was null, not copied");
                    continue;
                }
                ValueTreeBuilder.debug("Local object ignored");
            }
        }
        catch (Exception e) {
            ValueTreeBuilder.debug("Exception : " + e);
        }
        ValueTreeBuilder.debug("complete");
        return value;
    }

    protected static Method getValueObjectMethod(String name, Object value) {
        int index;
        Method[] methods = value.getClass().getMethods();
        for (index = 0; index < methods.length && !methods[index].getName().equals(name); ++index) {
        }
        return methods[index];
    }

    protected static String getLocalObjectKey(Object local) throws Exception {
        Method getMethod = local.getClass().getDeclaredMethod("getPrimaryKey", null);
        return local.getClass().getName() + getMethod.invoke(local, null);
    }

    protected static Object createValueFromLocal(Class localClass, Object local, String valuesPackage) throws Exception {
        Class[] parameterTypes = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = ValueTreeBuilder.class$("java.lang.Integer")) : class$java$lang$Integer};
        Class<?>[] interfaces = local.getClass().getInterfaces();
        boolean localInterfaceFound = false;
        int currentInterface = 0;
        ValueTreeBuilder.debug("Looking for Local entity interface...");
        while (interfaces[currentInterface].getName().indexOf("Local") == -1) {
            ValueTreeBuilder.debug("Skipping : " + interfaces[currentInterface].getName());
            ++currentInterface;
        }
        ValueTreeBuilder.debug("Using : " + interfaces[currentInterface].getName());
        String localClassName = interfaces[currentInterface].getName();
        StringBuffer buffer = new StringBuffer(valuesPackage);
        int start = localClassName.indexOf("Local") + 5;
        buffer.append(".");
        buffer.append(localClassName.substring(start));
        buffer.append("Value");
        String valueClassName = buffer.toString();
        ValueTreeBuilder.debug("Attempting to construct value object : " + valueClassName);
        Method getMethod = local.getClass().getDeclaredMethod("getPrimaryKey", null);
        Integer id = (Integer)getMethod.invoke(local, null);
        Object[] parameters = new Object[]{id};
        ValueTreeBuilder.debug("Using ID = " + id);
        Class<?> valueObjectClass = Class.forName(valueClassName);
        Object newValueObject = valueObjectClass.getDeclaredConstructor(parameterTypes).newInstance(parameters);
        return newValueObject;
    }

    private static void debug(String s) {
        category.debug((Object)s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class IncludeTreeNode {
        private Map children;
        private String name;
        private boolean copyAll;

        public IncludeTreeNode(String newName) {
            this.name = newName;
            this.children = new HashMap();
        }

        public String getName() {
            return this.name;
        }

        public static IncludeTreeNode createTree(String path) {
            IncludeTreeNode root = new IncludeTreeNode(".");
            StringTokenizer paths = new StringTokenizer(path, ",");
            while (paths.hasMoreTokens()) {
                String currentPath = paths.nextToken();
                StringTokenizer pathElements = new StringTokenizer(currentPath, ".");
                IncludeTreeNode currentNode = root;
                while (pathElements.hasMoreTokens()) {
                    String pathElement = IncludeTreeNode.convertToAccessor(pathElements.nextToken());
                    IncludeTreeNode nextNode = currentNode.getPathNode(pathElement);
                    if (nextNode == null) {
                        IncludeTreeNode newChild = new IncludeTreeNode(pathElement);
                        currentNode.addChild(newChild);
                        currentNode = newChild;
                        continue;
                    }
                    currentNode = nextNode;
                }
            }
            return root;
        }

        protected static String convertToAccessor(String element) {
            StringBuffer newElement = new StringBuffer("get");
            newElement.append(element);
            newElement.setCharAt(3, Character.toUpperCase(element.charAt(0)));
            return newElement.toString();
        }

        public IncludeTreeNode getPathNode(String element) {
            if (this.copyAll) {
                return this;
            }
            return (IncludeTreeNode)this.children.get(element);
        }

        public void addChild(IncludeTreeNode child) {
            this.copyAll = child.getName().endsWith("*");
            if (!this.copyAll) {
                this.children.put(child.getName(), child);
            }
            ValueTreeBuilder.debug(this.name + " adding " + child.getName());
        }

        public String toString() {
            StringBuffer result = new StringBuffer("(name = ) " + this.name);
            return result.toString();
        }
    }

    public static class IncludeTree {
        private IncludeTreeNode rootNode;

        protected IncludeTree(IncludeTreeNode root) {
            this.rootNode = root;
        }

        protected IncludeTreeNode getRootNode() {
            return this.rootNode;
        }
    }
}

