/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyBytesMessage;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyMapMessage;
import org.jboss.mq.SpyObjectMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyStreamMessage;
import org.jboss.mq.SpyTextMessage;
import org.jboss.util.Primitives;
import org.jboss.util.Strings;

public class SpyMessage
implements Serializable,
Message,
Comparable,
Cloneable,
Externalizable {
    private static final long serialVersionUID = 467206190892964404L;
    public static final String PROPERTY_SCHEDULED_DELIVERY = "JMS_JBOSS_SCHEDULED_DELIVERY";
    public static final String PROPERTY_REDELIVERY_DELAY = "JMS_JBOSS_REDELIVERY_DELAY";
    public static final String PROPERTY_REDELIVERY_COUNT = "JMS_JBOSS_REDELIVERY_COUNT";
    public static final String PROPERTY_REDELIVERY_LIMIT = "JMS_JBOSS_REDELIVERY_LIMIT";
    protected static final byte OBJECT_MESS = 1;
    protected static final byte BYTES_MESS = 2;
    protected static final byte MAP_MESS = 3;
    protected static final byte TEXT_MESS = 4;
    protected static final byte STREAM_MESS = 5;
    protected static final byte ENCAP_MESS = 6;
    protected static final byte SPY_MESS = 7;
    protected static final int BYTE = 0;
    protected static final int SHORT = 1;
    protected static final int INT = 2;
    protected static final int LONG = 3;
    protected static final int FLOAT = 4;
    protected static final int DOUBLE = 5;
    protected static final int BOOLEAN = 6;
    protected static final int STRING = 7;
    protected static final int OBJECT = 8;
    protected static final int NULL = 9;
    private static final HashSet reservedIdentifiers = new HashSet();
    public Header header = new Header();
    public transient AcknowledgementRequest ack;
    public transient SpySession session;

    public static void writeMessage(SpyMessage message, ObjectOutput out) throws IOException {
        if (message instanceof SpyEncapsulatedMessage) {
            out.writeByte(6);
        } else if (message instanceof SpyObjectMessage) {
            out.writeByte(1);
        } else if (message instanceof SpyBytesMessage) {
            out.writeByte(2);
        } else if (message instanceof SpyMapMessage) {
            out.writeByte(3);
        } else if (message instanceof SpyTextMessage) {
            out.writeByte(4);
        } else if (message instanceof SpyStreamMessage) {
            out.writeByte(5);
        } else {
            out.writeByte(7);
        }
        message.writeExternal(out);
    }

    public static SpyMessage readMessage(ObjectInput in) throws IOException {
        SpyMessage message = null;
        byte type = in.readByte();
        switch (type) {
            case 1: {
                message = MessagePool.getObjectMessage();
                break;
            }
            case 2: {
                message = MessagePool.getBytesMessage();
                break;
            }
            case 3: {
                message = MessagePool.getMapMessage();
                break;
            }
            case 5: {
                message = MessagePool.getStreamMessage();
                break;
            }
            case 4: {
                message = MessagePool.getTextMessage();
                break;
            }
            case 6: {
                message = MessagePool.getEncapsulatedMessage();
                break;
            }
            default: {
                message = MessagePool.getMessage();
            }
        }
        try {
            message.readExternal(in);
        }
        catch (ClassNotFoundException cnf) {
            throw new IOException("Class not found when reading in spy message.");
        }
        return message;
    }

    public void clearBody() throws JMSException {
        this.header.msgReadOnly = false;
    }

    public void acknowledge() throws JMSException {
        if (this.session == null) {
            throw new JMSException("This message was not recieved from the provider");
        }
        if (this.session.acknowledgeMode == 2) {
            this.doAcknowledge();
        }
    }

    public void setReadOnlyMode() {
        this.header.jmsPropertiesReadWrite = false;
        this.header.msgReadOnly = true;
    }

    public SpyMessage myClone() throws JMSException {
        SpyMessage result = MessagePool.getMessage();
        result.copyProps(this);
        return result;
    }

    public void copyProps(SpyMessage original) throws JMSException {
        try {
            this.setJMSCorrelationID(original.getJMSCorrelationID());
        }
        catch (JMSException e) {
            this.setJMSCorrelationIDAsBytes(original.getJMSCorrelationIDAsBytes());
        }
        this.setJMSDeliveryMode(original.getJMSDeliveryMode());
        this.setJMSDestination(original.getJMSDestination());
        this.setJMSExpiration(original.getJMSExpiration());
        this.setJMSMessageID(original.getJMSMessageID());
        this.setJMSPriority(original.getJMSPriority());
        this.setJMSRedelivered(original.getJMSRedelivered());
        this.setJMSReplyTo(original.getJMSReplyTo());
        this.setJMSTimestamp(original.getJMSTimestamp());
        this.setJMSType(original.getJMSType());
        this.header.jmsProperties.putAll(original.header.jmsProperties);
        this.header.jmsPropertiesReadWrite = original.header.jmsPropertiesReadWrite;
        this.header.msgReadOnly = original.header.msgReadOnly;
        this.header.producerClientId = original.header.producerClientId;
        if (original.header.durableSubscriberID != null) {
            this.header.durableSubscriberID = new DurableSubscriptionID(original.header.durableSubscriberID.clientID, original.header.durableSubscriberID.subscriptionName, original.header.durableSubscriberID.selector);
        }
    }

    public boolean isOutdated() {
        if (this.header.jmsExpiration == 0L) {
            return false;
        }
        long ts = System.currentTimeMillis();
        return this.header.jmsExpiration < ts;
    }

    public void doAcknowledge() throws JMSException {
        if (this.session.closed) {
            throw new IllegalStateException("Session is closed.");
        }
        this.session.doAcknowledge(this, this.getAcknowledgementRequest(true));
    }

    public void doNegAcknowledge() throws JMSException {
        if (this.session.closed) {
            throw new IllegalStateException("Session is closed.");
        }
        this.session.doAcknowledge(this, this.getAcknowledgementRequest(false));
    }

    public void createAcknowledgementRequest(int subscriptionId) {
        this.ack = new AcknowledgementRequest();
        this.ack.destination = this.header.jmsDestination;
        this.ack.messageID = this.header.jmsMessageID;
        this.ack.subscriberId = subscriptionId;
    }

    public AcknowledgementRequest getAcknowledgementRequest(boolean isAck) throws JMSException {
        AcknowledgementRequest item = new AcknowledgementRequest();
        item.destination = this.ack.destination;
        item.messageID = this.ack.messageID;
        item.subscriberId = this.ack.subscriberId;
        item.isAck = isAck;
        return item;
    }

    public int compareTo(Object o) {
        SpyMessage sm = (SpyMessage)o;
        if (this.header.jmsPriority > sm.header.jmsPriority) {
            return -1;
        }
        if (this.header.jmsPriority < sm.header.jmsPriority) {
            return 1;
        }
        return (int)(this.header.messageId - sm.header.messageId);
    }

    public String getJMSMessageID() {
        return this.header.jmsMessageID;
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.header.jmsMessageID = id;
    }

    public long getJMSTimestamp() {
        return this.header.jmsTimeStamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.header.jmsTimeStamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.header.jmsCorrelationID) {
            throw new JMSException("JMSCorrelationID is a string");
        }
        return this.header.jmsCorrelationIDbyte;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.header.jmsCorrelationID = false;
        this.header.jmsCorrelationIDbyte = (byte[])correlationID.clone();
        this.header.jmsCorrelationIDString = null;
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.header.jmsCorrelationID = true;
        this.header.jmsCorrelationIDString = correlationID;
        this.header.jmsCorrelationIDbyte = null;
    }

    public String getJMSCorrelationID() throws JMSException {
        if (!this.header.jmsCorrelationID) {
            throw new JMSException("JMSCorrelationID is an array");
        }
        return this.header.jmsCorrelationIDString;
    }

    public Destination getJMSReplyTo() {
        return this.header.jmsReplyTo;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.header.jmsReplyTo = replyTo;
    }

    public Destination getJMSDestination() {
        return this.header.jmsDestination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.header.jmsDestination = destination;
    }

    public int getJMSDeliveryMode() {
        return this.header.jmsDeliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.header.jmsDeliveryMode = deliveryMode;
    }

    public boolean getJMSRedelivered() {
        return this.header.jmsRedelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.header.jmsRedelivered = redelivered;
    }

    public String getJMSType() {
        return this.header.jmsType;
    }

    public void setJMSType(String type) throws JMSException {
        this.header.jmsType = type;
    }

    public long getJMSExpiration() {
        return this.header.jmsExpiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.header.jmsExpiration = expiration;
    }

    public int getJMSPriority() {
        return this.header.jmsPriority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 10) {
            throw new JMSException("Unsupported priority '" + priority + "': priority must be from 0-10");
        }
        this.header.jmsPriority = priority;
    }

    public void clearProperties() throws JMSException {
        this.header.jmsProperties.clear();
        this.header.jmsPropertiesReadWrite = true;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.header.jmsProperties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            return Float.valueOf(null).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof Byte) {
            return ((Byte)value).toString();
        }
        if (value instanceof Short) {
            return ((Short)value).toString();
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Float) {
            return ((Float)value).toString();
        }
        if (value instanceof Double) {
            return ((Double)value).toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public Object getObjectProperty(String name) throws JMSException {
        Object value = this.header.jmsProperties.get(name);
        return value;
    }

    public Enumeration getPropertyNames() throws JMSException {
        Enumeration names = Collections.enumeration(this.header.jmsProperties.keySet());
        return names;
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        Boolean b = Primitives.valueOf((boolean)value);
        this.checkProperty(name, b);
        this.header.jmsProperties.put(name, b);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        Byte b = new Byte(value);
        this.checkProperty(name, b);
        this.header.jmsProperties.put(name, b);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        Short s = new Short(value);
        this.checkProperty(name, s);
        this.header.jmsProperties.put(name, s);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        Integer i = new Integer(value);
        this.checkProperty(name, i);
        this.header.jmsProperties.put(name, i);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        Long l = new Long(value);
        this.checkProperty(name, l);
        this.header.jmsProperties.put(name, l);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        Float f = new Float(value);
        this.checkProperty(name, f);
        this.header.jmsProperties.put(name, f);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        Double d = new Double(value);
        this.checkProperty(name, d);
        this.header.jmsProperties.put(name, d);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.checkProperty(name, value);
        this.header.jmsProperties.put(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (!this.header.jmsPropertiesReadWrite) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.checkProperty(name, value);
        if (value instanceof Boolean) {
            this.header.jmsProperties.put(name, value);
        } else if (value instanceof Byte) {
            this.header.jmsProperties.put(name, value);
        } else if (value instanceof Short) {
            this.header.jmsProperties.put(name, value);
        } else if (value instanceof Integer) {
            this.header.jmsProperties.put(name, value);
        } else if (value instanceof Long) {
            this.header.jmsProperties.put(name, value);
        } else if (value instanceof Float) {
            this.header.jmsProperties.put(name, value);
        } else if (value instanceof Double) {
            this.header.jmsProperties.put(name, value);
        } else if (value instanceof String) {
            this.header.jmsProperties.put(name, value);
        } else if (value == null) {
            this.header.jmsProperties.put(name, null);
        } else {
            throw new MessageFormatException("Invalid object type");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SpyDestination.writeDest(out, this.header.jmsDestination);
        out.writeInt(this.header.jmsDeliveryMode);
        out.writeLong(this.header.jmsExpiration);
        out.writeInt(this.header.jmsPriority);
        SpyMessage.writeString(out, this.header.jmsMessageID);
        out.writeLong(this.header.jmsTimeStamp);
        out.writeBoolean(this.header.jmsCorrelationID);
        SpyMessage.writeString(out, this.header.jmsCorrelationIDString);
        if (this.header.jmsCorrelationIDbyte == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.header.jmsCorrelationIDbyte.length);
            out.write(this.header.jmsCorrelationIDbyte);
        }
        SpyDestination.writeDest(out, this.header.jmsReplyTo);
        SpyMessage.writeString(out, this.header.jmsType);
        out.writeBoolean(this.header.jmsRedelivered);
        out.writeBoolean(this.header.jmsPropertiesReadWrite);
        out.writeBoolean(this.header.msgReadOnly);
        SpyMessage.writeString(out, this.header.producerClientId);
        Set entrySet = this.header.jmsProperties.entrySet();
        out.writeInt(entrySet.size());
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            out.writeUTF((String)me.getKey());
            Object value = me.getValue();
            if (value == null) {
                out.writeByte(8);
                out.writeObject(value);
                continue;
            }
            if (value instanceof String) {
                out.writeByte(7);
                out.writeUTF((String)value);
                continue;
            }
            if (value instanceof Integer) {
                out.writeByte(2);
                out.writeInt((Integer)value);
                continue;
            }
            if (value instanceof Boolean) {
                out.writeByte(6);
                out.writeBoolean((Boolean)value);
                continue;
            }
            if (value instanceof Byte) {
                out.writeByte(0);
                out.writeByte(((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Short) {
                out.writeByte(1);
                out.writeShort(((Short)value).shortValue());
                continue;
            }
            if (value instanceof Long) {
                out.writeByte(3);
                out.writeLong((Long)value);
                continue;
            }
            if (value instanceof Float) {
                out.writeByte(4);
                out.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                out.writeByte(5);
                out.writeDouble((Double)value);
                continue;
            }
            out.writeByte(8);
            out.writeObject(value);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.header.jmsDestination = SpyDestination.readDest(in);
        this.header.jmsDeliveryMode = in.readInt();
        this.header.jmsExpiration = in.readLong();
        this.header.jmsPriority = in.readInt();
        this.header.jmsMessageID = SpyMessage.readString(in);
        this.header.jmsTimeStamp = in.readLong();
        this.header.jmsCorrelationID = in.readBoolean();
        this.header.jmsCorrelationIDString = SpyMessage.readString(in);
        int length = in.readInt();
        if (length < 0) {
            this.header.jmsCorrelationIDbyte = null;
        } else {
            this.header.jmsCorrelationIDbyte = new byte[length];
            in.readFully(this.header.jmsCorrelationIDbyte);
        }
        this.header.jmsReplyTo = SpyDestination.readDest(in);
        this.header.jmsType = SpyMessage.readString(in);
        this.header.jmsRedelivered = in.readBoolean();
        this.header.jmsPropertiesReadWrite = in.readBoolean();
        this.header.msgReadOnly = in.readBoolean();
        this.header.producerClientId = SpyMessage.readString(in);
        this.header.jmsProperties = new HashMap();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            byte type = in.readByte();
            Object value = null;
            switch (type) {
                case 0: {
                    value = new Byte(in.readByte());
                    break;
                }
                case 1: {
                    value = new Short(in.readShort());
                    break;
                }
                case 2: {
                    value = new Integer(in.readInt());
                    break;
                }
                case 3: {
                    value = new Long(in.readLong());
                    break;
                }
                case 4: {
                    value = new Float(in.readFloat());
                    break;
                }
                case 5: {
                    value = new Double(in.readDouble());
                    break;
                }
                case 6: {
                    value = Primitives.valueOf((boolean)in.readBoolean());
                    break;
                }
                case 7: {
                    value = in.readUTF();
                    break;
                }
                default: {
                    value = in.readObject();
                }
            }
            this.header.jmsProperties.put(key, value);
        }
    }

    public String toString() {
        return this.getClass().getName() + " {\n" + this.header + "\n" + "}";
    }

    void checkProperty(String name, Object value) throws JMSException {
        if (name == null) {
            throw new IllegalArgumentException("The name of a property must not be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("The name of a property must not be an empty String.");
        }
        if (!Strings.isValidJavaIdentifier((String)name)) {
            throw new IllegalArgumentException("The property name '" + name + "' is not a valid java identifier.");
        }
        if (reservedIdentifiers.contains(name)) {
            throw new IllegalArgumentException("The property name '" + name + "' is reserved due to selector syntax.");
        }
        if (name.regionMatches(false, 0, "JMS_", 0, 4)) {
            if (name.equals(PROPERTY_SCHEDULED_DELIVERY)) {
                if (!(value instanceof Long)) {
                    throw new JMSException(name + " must be Long: " + value);
                }
            } else if (name.equals(PROPERTY_REDELIVERY_DELAY)) {
                if (!(value instanceof Number)) {
                    throw new JMSException(name + " must be Number: " + value);
                }
            } else if (name.equals(PROPERTY_REDELIVERY_COUNT)) {
                if (!(value instanceof Number)) {
                    throw new JMSException(name + " must be Number: " + value);
                }
            } else if (name.equals(PROPERTY_REDELIVERY_LIMIT)) {
                if (!(value instanceof Number)) {
                    throw new JMSException(name + " must be Number: " + value);
                }
            } else {
                throw new JMSException("Illegal property name: " + name);
            }
        }
        if (name.regionMatches(false, 0, "JMSX", 0, 4)) {
            if (name.equals("JMSXGroupID")) {
                return;
            }
            if (name.equals("JMSXGroupSeq")) {
                return;
            }
            throw new JMSException("Illegal property name: " + name);
        }
    }

    void clearMessage() throws JMSException {
        this.clearBody();
        this.ack = null;
        this.session = null;
        this.header.jmsDestination = null;
        this.header.jmsDeliveryMode = -1;
        this.header.jmsExpiration = 0L;
        this.header.jmsPriority = -1;
        this.header.jmsMessageID = null;
        this.header.jmsTimeStamp = 0L;
        this.header.jmsCorrelationID = true;
        this.header.jmsCorrelationIDString = null;
        this.header.jmsCorrelationIDbyte = null;
        this.header.jmsReplyTo = null;
        this.header.jmsType = null;
        this.header.jmsRedelivered = false;
        this.header.jmsProperties.clear();
        this.header.jmsPropertiesReadWrite = true;
        this.header.msgReadOnly = false;
        this.header.producerClientId = null;
        this.header.durableSubscriberID = null;
        this.header.messageId = 0L;
    }

    private static void writeString(ObjectOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(9);
        } else {
            out.writeByte(7);
            out.writeUTF(s);
        }
    }

    private static String readString(ObjectInput in) throws IOException {
        byte b = in.readByte();
        if (b == 9) {
            return null;
        }
        return in.readUTF();
    }

    static {
        reservedIdentifiers.add("NULL");
        reservedIdentifiers.add("TRUE");
        reservedIdentifiers.add("FALSE");
        reservedIdentifiers.add("NOT");
        reservedIdentifiers.add("AND");
        reservedIdentifiers.add("OR");
        reservedIdentifiers.add("BETWEEN");
        reservedIdentifiers.add("LIKE");
        reservedIdentifiers.add("IN");
        reservedIdentifiers.add("IS");
        reservedIdentifiers.add("ESCAPE");
    }

    public static class Header {
        public Destination jmsDestination = null;
        public int jmsDeliveryMode = -1;
        public long jmsExpiration = 0L;
        public int jmsPriority = -1;
        public String jmsMessageID = null;
        public long jmsTimeStamp = 0L;
        public boolean jmsCorrelationID = true;
        public String jmsCorrelationIDString = null;
        public byte[] jmsCorrelationIDbyte = null;
        public Destination jmsReplyTo = null;
        public String jmsType = null;
        public boolean jmsRedelivered = false;
        public HashMap jmsProperties = new HashMap();
        public boolean jmsPropertiesReadWrite = true;
        public boolean msgReadOnly = false;
        public String producerClientId;
        public DurableSubscriptionID durableSubscriberID = null;
        public transient long messageId;

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("Header { \n");
            buffer.append("   jmsDestination  : ").append(this.jmsDestination).append('\n');
            buffer.append("   jmsDeliveryMode : ").append(this.jmsDeliveryMode).append('\n');
            buffer.append("   jmsExpiration   : ").append(this.jmsExpiration).append('\n');
            buffer.append("   jmsPriority     : ").append(this.jmsPriority).append('\n');
            buffer.append("   jmsMessageID    : ").append(this.jmsMessageID).append('\n');
            buffer.append("   jmsTimeStamp    : ").append(this.jmsTimeStamp).append('\n');
            buffer.append("   jmsCorrelationID: ").append(this.jmsCorrelationIDString).append('\n');
            buffer.append("   jmsReplyTo      : ").append(this.jmsReplyTo).append('\n');
            buffer.append("   jmsType         : ").append(this.jmsType).append('\n');
            buffer.append("   jmsRedelivered  : ").append(this.jmsRedelivered).append('\n');
            buffer.append("   jmsProperties   : ").append(this.jmsProperties).append('\n');
            buffer.append("   jmsPropReadWrite: ").append(this.jmsPropertiesReadWrite).append('\n');
            buffer.append("   msgReadOnly     : ").append(this.msgReadOnly).append('\n');
            buffer.append("   producerClientId: ").append(this.producerClientId).append('\n');
            buffer.append('}');
            return buffer.toString();
        }
    }
}

