/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;

public class Log4jLogger
implements Logger {
    protected Container container = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected org.jboss.logging.Logger log;
    protected int verbosity = 1;

    public Log4jLogger() {
    }

    public Log4jLogger(org.jboss.logging.Logger log) {
        this.log = log;
    }

    public void setCategory(String category) {
        this.log = org.jboss.logging.Logger.getLogger((String)category);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getInfo() {
        return this.getClass().getName();
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public void setVerbosityLevel(String verbosity) {
        if ("FATAL".equalsIgnoreCase(verbosity)) {
            this.verbosity = Integer.MIN_VALUE;
        } else if ("ERROR".equalsIgnoreCase(verbosity)) {
            this.verbosity = 1;
        } else if ("WARNING".equalsIgnoreCase(verbosity)) {
            this.verbosity = 2;
        } else if ("INFORMATION".equalsIgnoreCase(verbosity)) {
            this.verbosity = 3;
        } else if ("DEBUG".equalsIgnoreCase(verbosity)) {
            this.verbosity = 4;
        } else {
            this.log.warn((Object)("Unknown log level '" + verbosity + "' seen, using DEBUG\n" + "Valid values are: FATAL, ERROR, WARNING, INFORMATION or DEBUG"));
            this.verbosity = 4;
        }
    }

    public void log(String message) {
        this.log.info((Object)message);
    }

    public void log(Exception exception, String message) {
        this.log.error((Object)message, (Throwable)exception);
    }

    public void log(String message, int verbosity) {
        switch (verbosity) {
            case -2147483648: {
                this.log.fatal((Object)message);
                break;
            }
            case 1: {
                this.log.error((Object)message);
                break;
            }
            case 2: {
                this.log.warn((Object)message);
                break;
            }
            case 3: {
                this.log.info((Object)message);
                break;
            }
            case 4: {
                this.log.debug((Object)message);
            }
        }
    }

    public void log(String message, Throwable throwable) {
        Throwable rootCause = null;
        if (throwable instanceof LifecycleException) {
            rootCause = ((LifecycleException)throwable).getThrowable();
        } else if (throwable instanceof ServletException) {
            rootCause = ((ServletException)throwable).getRootCause();
        }
        this.log.error((Object)message, throwable);
        if (rootCause != null) {
            this.log.error((Object)"----- Root Cause -----", rootCause);
        }
    }

    public void log(String message, Throwable throwable, int verbosity) {
        switch (verbosity) {
            case -2147483648: {
                this.log.fatal((Object)message, throwable);
                break;
            }
            case 1: {
                this.log.error((Object)message, throwable);
                break;
            }
            case 2: {
                this.log.warn((Object)message, throwable);
                break;
            }
            case 3: {
                this.log.info((Object)message, throwable);
                break;
            }
            case 4: {
                this.log.debug((Object)message, throwable);
            }
        }
    }
}

