/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.Timestamper;

public class OSCache
implements Cache {
    private GeneralCacheAdministrator cache = new GeneralCacheAdministrator();
    private final int refreshPeriod;
    private final String cron;
    private final String regionName;

    private String toString(Object key) {
        return String.valueOf(key) + '.' + this.regionName;
    }

    public OSCache(int refreshPeriod, String cron, String region) {
        this.refreshPeriod = refreshPeriod;
        this.cron = cron;
        this.regionName = region;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cache.setCacheCapacity(cacheCapacity);
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.cache.getFromCache(this.toString(key), this.refreshPeriod, this.cron);
        }
        catch (NeedsRefreshException e) {
            this.cache.cancelUpdate(this.toString(key));
            return null;
        }
    }

    public void put(Object key, Object value) throws CacheException {
        this.cache.putInCache(this.toString(key), value);
    }

    public void remove(Object key) throws CacheException {
        this.cache.flushEntry(this.toString(key));
    }

    public void clear() throws CacheException {
        this.cache.flushAll();
    }

    public void destroy() throws CacheException {
        this.cache.destroy();
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }
}

