/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.util.StringHelper;

public class InExpression
extends AbstractCriterion {
    private final String propertyName;
    private final Object[] values;

    InExpression(String propertyName, Object[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        String params;
        if (this.values.length > 0) {
            params = StringHelper.repeat("?, ", this.values.length - 1);
            params = params + "?";
        } else {
            params = "";
        }
        String condition = " in (" + params + ')';
        return StringHelper.join(" and ", StringHelper.suffix(InExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias, aliasClasses), condition));
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        TypedValue[] tvs = new TypedValue[this.values.length];
        for (int i = 0; i < tvs.length; ++i) {
            tvs[i] = InExpression.getTypedValue(sessionFactory, persistentClass, this.propertyName, this.values[i], aliasClasses);
        }
        return tvs;
    }

    public String toString() {
        return this.propertyName + " in (" + StringHelper.toString(this.values) + ')';
    }
}

