/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.CacheEntry;
import net.sf.hibernate.impl.ScheduledEntityAction;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

final class ScheduledInsertion
extends ScheduledEntityAction
implements SessionImpl.Executable,
Serializable {
    private final Object[] state;
    private CacheEntry cacheEntry;

    public ScheduledInsertion(Serializable id, Object[] state, Object instance, ClassPersister persister, SessionImplementor session) throws HibernateException {
        super(session, id, instance, persister);
        this.state = state;
    }

    public void execute() throws HibernateException {
        ClassPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object object = this.getInstance();
        Serializable id = this.getId();
        persister.insert(id, this.state, object, session);
        session.postInsert(object);
        if (persister.hasCache() && !persister.isCacheInvalidationRequired()) {
            this.cacheEntry = new CacheEntry(object, persister, session);
            persister.getCache().insert(id, this.cacheEntry);
        }
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        ClassPersister persister = this.getPersister();
        if (success && persister.hasCache() && !persister.isCacheInvalidationRequired()) {
            persister.getCache().afterInsert(this.getId(), this.cacheEntry);
        }
    }
}

