/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.persister;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.Versioning;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.loader.SimpleEntityLoader;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.persister.AbstractEntityPersister;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.Delete;
import net.sf.hibernate.sql.InFragment;
import net.sf.hibernate.sql.Insert;
import net.sf.hibernate.sql.SelectFragment;
import net.sf.hibernate.sql.SimpleSelect;
import net.sf.hibernate.sql.Update;
import net.sf.hibernate.type.DiscriminatorType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.GetGeneratedKeysHelper;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityPersister
extends AbstractEntityPersister
implements Queryable {
    private final SessionFactoryImplementor factory;
    private final String qualifiedTableName;
    private final String[] tableNames;
    private final boolean hasUpdateableColumns;
    private final Class[] subclassClosure;
    private final boolean hasFormulaProperties;
    private final String sqlDeleteString;
    private final String sqlInsertString;
    private final String sqlUpdateString;
    private final String sqlIdentityInsertString;
    private final String sqlConcreteSelectString;
    private final String sqlVersionSelectString;
    private final int[] propertyColumnSpans;
    private final boolean[] propertyDefinedOnSubclass;
    private final String[][] propertyColumnNames;
    private final String[][] propertyColumnAliases;
    private final String[] propertyFormulaTemplates;
    private final String[] subclassColumnClosure;
    private final String[] subclassColumnAliasClosure;
    private final String[] subclassFormulaTemplateClosure;
    private final String[] subclassFormulaClosure;
    private final String[] subclassFormulaAliasClosure;
    private final String[][] subclassPropertyColumnNameClosure;
    private final String[] subclassPropertyNameClosure;
    private final Type[] subclassPropertyTypeClosure;
    private final int[] subclassPropertyEnableJoinedFetch;
    private final HashMap subclassesByDiscriminatorValue = new HashMap();
    private final boolean forceDiscriminator;
    private final String discriminatorColumnName;
    private final String discriminatorAlias;
    private final Type discriminatorType;
    private final Object discriminatorSQLValue;
    private final boolean discriminatorInsertable;
    private final Map loaders = new HashMap();
    private static final Object NULL_DISCRIMINATOR = new Object();
    private static final Object NOT_NULL_DISCRIMINATOR = new Object();
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$persister$EntityPersister == null ? (class$net$sf$hibernate$persister$EntityPersister = EntityPersister.class$("net.sf.hibernate.persister.EntityPersister")) : class$net$sf$hibernate$persister$EntityPersister));
    static /* synthetic */ Class class$net$sf$hibernate$persister$EntityPersister;

    public void postInstantiate() throws MappingException {
        this.initPropertyPaths(this.factory);
        UniqueEntityLoader loader = this.createEntityLoader(this.factory);
        this.loaders.put(LockMode.NONE, loader);
        this.loaders.put(LockMode.READ, loader);
        String selectForUpdate = this.factory.getDialect().supportsForUpdate() ? this.generateSelectForUpdateString() : this.generateSelectString();
        this.loaders.put(LockMode.UPGRADE, new SimpleEntityLoader(this, selectForUpdate, LockMode.UPGRADE));
        String selectForUpdateNowait = this.factory.getDialect().supportsForUpdateNowait() ? this.generateSelectForUpdateNowaitString() : selectForUpdate;
        this.loaders.put(LockMode.UPGRADE_NOWAIT, new SimpleEntityLoader(this, selectForUpdateNowait, LockMode.UPGRADE_NOWAIT));
        this.createUniqueKeyLoaders(this.factory);
    }

    public boolean isDefinedOnSubclass(int i) {
        return this.propertyDefinedOnSubclass[i];
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    public String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }

    public int enableJoinedFetch(int i) {
        return this.subclassPropertyEnableJoinedFetch[i];
    }

    public Type getSubclassPropertyType(int i) {
        return this.subclassPropertyTypeClosure[i];
    }

    public String getSubclassPropertyName(int i) {
        return this.subclassPropertyNameClosure[i];
    }

    public int countSubclassProperties() {
        return this.subclassPropertyTypeClosure.length;
    }

    public String getTableName() {
        return this.qualifiedTableName;
    }

    public String[] getSubclassPropertyColumnNames(int i) {
        return this.subclassPropertyColumnNameClosure[i];
    }

    public String[] getPropertyColumnNames(int i) {
        return this.propertyColumnAliases[i];
    }

    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    public Object getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    public Class[] getSubclassClosure() {
        return this.subclassClosure;
    }

    public Class getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return (Class)this.subclassesByDiscriminatorValue.get(NULL_DISCRIMINATOR);
        }
        Class result = (Class)this.subclassesByDiscriminatorValue.get(value);
        if (result == null) {
            result = (Class)this.subclassesByDiscriminatorValue.get(NOT_NULL_DISCRIMINATOR);
        }
        return result;
    }

    public Serializable getIdentifierSpace() {
        return this.qualifiedTableName;
    }

    public Serializable[] getPropertySpaces() {
        return this.tableNames;
    }

    protected final String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    protected final String getSQLInsertString() {
        return this.sqlInsertString;
    }

    protected final String getSQLIdentityInsertString() {
        return this.sqlIdentityInsertString;
    }

    protected final String getSQLUpdateString() {
        return this.sqlUpdateString;
    }

    protected final String getVersionSelectString() {
        return this.sqlVersionSelectString;
    }

    protected String generateDeleteString() {
        return new Delete().setTableName(this.getTableName()).setPrimaryKeyColumnNames(this.getIdentifierColumnNames()).setVersionColumnName(this.getVersionColumnName()).toStatementString();
    }

    protected String generateInsertString(boolean identityInsert, boolean[] includeProperty) {
        Insert insert = new Insert(this.getDialect()).setTableName(this.getTableName());
        for (int i = 0; i < this.getHydrateSpan(); ++i) {
            if (!includeProperty[i]) continue;
            insert.addColumns(this.propertyColumnNames[i]);
        }
        if (this.discriminatorInsertable) {
            insert.addColumn(this.getDiscriminatorColumnName(), this.discriminatorSQLValue.toString());
        }
        if (!identityInsert) {
            insert.addColumns(this.getIdentifierColumnNames());
        } else {
            insert.addIdentityColumn(this.getIdentifierColumnNames()[0]);
        }
        return insert.toStatementString();
    }

    protected String generateSelectForUpdateString() {
        return this.generateSelectString() + " for update";
    }

    protected String generateSelectForUpdateNowaitString() {
        return this.generateSelectString() + " for update nowait";
    }

    protected String generateSelectString() {
        SimpleSelect select = new SimpleSelect().setTableName(this.getTableName()).addColumns(this.getIdentifierColumnNames()).addColumns(this.subclassColumnClosure, this.subclassColumnAliasClosure).addColumns(this.subclassFormulaClosure, this.subclassFormulaAliasClosure);
        if (this.hasSubclasses()) {
            select.addColumn(this.getDiscriminatorColumnName(), this.getDiscriminatorAlias());
        }
        return select.addCondition(this.getIdentifierColumnNames(), "=?").toStatementString();
    }

    protected String generateConcreteSelectString(boolean[] includeProperty) {
        SimpleSelect select = new SimpleSelect().setTableName(this.getTableName()).addColumns(this.getIdentifierColumnNames());
        for (int i = 0; i < this.getPropertyNames().length; ++i) {
            if (!includeProperty[i]) continue;
            select.addColumns(this.propertyColumnNames[i], this.propertyColumnAliases[i]);
        }
        select.addCondition(this.getIdentifierColumnNames(), "=?");
        if (this.isVersioned()) {
            select.addWhereToken("and").addCondition(this.getVersionColumnName(), "=?");
        }
        return select.toStatementString();
    }

    protected String generateUpdateString(boolean[] includeProperty) {
        return this.generateUpdate(includeProperty).toStatementString();
    }

    protected String generateUpdateString(boolean[] includeProperty, Object[] oldFields) {
        Update update = this.generateUpdate(includeProperty);
        if (this.optimisticLockMode() > 0 && oldFields != null) {
            boolean[] includeInWhere = this.optimisticLockMode() == 2 ? this.getPropertyUpdateability() : includeProperty;
            for (int i = 0; i < this.getHydrateSpan(); ++i) {
                if (!includeInWhere[i]) continue;
                if (oldFields[i] == null) {
                    update.addWhereColumns(this.propertyColumnNames[i], " is null");
                    continue;
                }
                update.addWhereColumns(this.propertyColumnNames[i]);
            }
        }
        return update.toStatementString();
    }

    private Update generateUpdate(boolean[] includeProperty) {
        Update update = new Update().setTableName(this.getTableName()).setPrimaryKeyColumnNames(this.getIdentifierColumnNames());
        for (int i = 0; i < this.getHydrateSpan(); ++i) {
            if (!includeProperty[i]) continue;
            update.addColumns(this.propertyColumnNames[i]);
        }
        if (this.optimisticLockMode() == 0) {
            update.setVersionColumnName(this.getVersionColumnName());
        }
        return update;
    }

    protected String generateLockString() {
        SimpleSelect select = new SimpleSelect().setTableName(this.getTableName()).addColumn(this.getIdentifierColumnNames()[0]).addCondition(this.getIdentifierColumnNames(), "=?");
        if (this.isVersioned()) {
            select.addWhereToken("and").addCondition(this.getVersionColumnName(), "=?");
        }
        return select.toStatementString();
    }

    protected int dehydrate(Serializable id, Object[] fields, boolean[] includeProperty, PreparedStatement st, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dehydrating entity: " + MessageHelper.infoString(this, id)));
        }
        int index = 1;
        for (int j = 0; j < this.getHydrateSpan(); ++j) {
            if (!includeProperty[j]) continue;
            this.getPropertyTypes()[j].nullSafeSet(st, fields[j], index, session);
            index += this.propertyColumnSpans[j];
        }
        if (id != null) {
            this.getIdentifierType().nullSafeSet(st, id, index, session);
            index += this.getIdentifierColumnNames().length;
        }
        return index;
    }

    public Object load(Serializable id, Object optionalObject, LockMode lockMode, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Materializing entity: " + MessageHelper.infoString(this, id)));
        }
        try {
            return ((UniqueEntityLoader)this.loaders.get(lockMode)).load(session, id, optionalObject);
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not load: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    public Serializable insert(Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        if (this.useDynamicInsert()) {
            boolean[] notNull = this.getNotNullInsertableColumns(fields);
            return this.insert(fields, notNull, this.generateInsertString(true, notNull), object, session);
        }
        return this.insert(fields, this.getPropertyInsertability(), this.getSQLIdentityInsertString(), object, session);
    }

    public void insert(Serializable id, Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        if (this.useDynamicInsert()) {
            boolean[] notNull = this.getNotNullInsertableColumns(fields);
            this.insert(id, fields, notNull, this.generateInsertString(false, notNull), object, session);
        } else {
            this.insert(id, fields, this.getPropertyInsertability(), this.getSQLInsertString(), object, session);
        }
    }

    public void insert(Serializable id, Object[] fields, boolean[] notNull, String sql, Object object, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + MessageHelper.infoString(this, id)));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        try {
            PreparedStatement statement = session.getBatcher().prepareBatchStatement(sql);
            try {
                this.dehydrate(id, fields, notNull, statement, session);
                session.getBatcher().addToBatch(1);
            }
            catch (SQLException sqle) {
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not insert: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable insert(Object[] fields, boolean[] notNull, String sql, Object object, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + this.getClassName() + " (native id)"));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        boolean useGetGeneratedKeys = session.getFactory().isGetGeneratedKeysEnabled();
        try {
            String insertSelectSQL;
            String string = insertSelectSQL = useGetGeneratedKeys ? null : this.getDialect().appendIdentitySelectToInsert(sql);
            if (insertSelectSQL != null) {
                PreparedStatement insertSelect = session.getBatcher().prepareStatement(insertSelectSQL);
                try {
                    this.dehydrate(null, fields, notNull, insertSelect, session);
                    if (!insertSelect.execute()) {
                        while (!insertSelect.getMoreResults()) {
                        }
                    }
                    Serializable serializable = this.getGeneratedIdentity(object, session, insertSelect.getResultSet());
                    return serializable;
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                finally {
                    session.getBatcher().closeStatement(insertSelect);
                }
            }
            PreparedStatement statement = session.getBatcher().prepareStatement(sql, useGetGeneratedKeys);
            try {
                this.dehydrate(null, fields, notNull, statement, session);
                statement.executeUpdate();
                if (useGetGeneratedKeys) {
                    Serializable sqle = this.getGeneratedIdentity(object, session, GetGeneratedKeysHelper.getGeneratedKey(statement));
                    return sqle;
                }
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            finally {
                session.getBatcher().closeStatement(statement);
            }
            PreparedStatement idselect = session.getBatcher().prepareStatement(this.sqlIdentitySelect());
            try {
                Serializable serializable = this.getGeneratedIdentity(object, session, idselect.executeQuery());
                return serializable;
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            finally {
                session.getBatcher().closeStatement(idselect);
            }
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not insert: " + MessageHelper.infoString(this), sqle);
        }
    }

    public void delete(Serializable id, Object version, Object object, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting entity: " + MessageHelper.infoString(this, id)));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + version));
            }
        }
        try {
            PreparedStatement statement = this.isVersioned() ? session.getBatcher().prepareStatement(this.getSQLDeleteString()) : session.getBatcher().prepareBatchStatement(this.getSQLDeleteString());
            try {
                this.getIdentifierType().nullSafeSet(statement, id, 1, session);
                if (this.isVersioned()) {
                    this.getVersionType().nullSafeSet(statement, version, this.getIdentifierColumnNames().length + 1, session);
                    this.check(statement.executeUpdate(), id);
                } else {
                    session.getBatcher().addToBatch(1);
                }
            }
            catch (SQLException sqle) {
                if (!this.isVersioned()) {
                    session.getBatcher().abortBatch(sqle);
                } else {
                    JDBCExceptionReporter.logExceptions(sqle);
                }
                throw sqle;
            }
            finally {
                if (this.isVersioned()) {
                    session.getBatcher().closeStatement(statement);
                }
            }
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not delete: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    public void update(Serializable id, Object[] fields, int[] dirtyFields, Object[] oldFields, Object oldVersion, Object object, SessionImplementor session) throws HibernateException {
        String updateString;
        boolean[] propsToUpdate;
        if (this.useDynamicUpdate() && dirtyFields != null) {
            propsToUpdate = this.getPropertiesToUpdate(dirtyFields);
            updateString = this.generateUpdateString(propsToUpdate, oldFields);
        } else {
            propsToUpdate = this.getPropertyUpdateability();
            updateString = this.getSQLUpdateString();
        }
        this.update(id, fields, oldFields, propsToUpdate, oldVersion, object, updateString, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(Serializable id, Object[] fields, Object[] oldFields, boolean[] includeProperty, Object oldVersion, Object object, String sql, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating entity: " + MessageHelper.infoString(this, id)));
            if (this.isVersioned()) {
                log.trace((Object)("Existing version: " + oldVersion + " -> New version: " + fields[this.getVersionProperty()]));
            }
        }
        if (!this.hasUpdateableColumns) {
            return;
        }
        try {
            PreparedStatement statement = this.isBatchable() ? session.getBatcher().prepareBatchStatement(sql) : session.getBatcher().prepareStatement(sql);
            try {
                try {
                    int index = this.dehydrate(id, fields, includeProperty, statement, session);
                    if (this.isVersioned()) {
                        if (0 == this.optimisticLockMode()) {
                            this.getVersionType().nullSafeSet(statement, oldVersion, index, session);
                        } else if (0 < this.optimisticLockMode() && null != oldFields) {
                            boolean[] includeOldField = this.optimisticLockMode() == 2 ? this.getPropertyUpdateability() : includeProperty;
                            for (int j = 0; j < this.getHydrateSpan(); ++j) {
                                if (!includeOldField[j] || oldFields[j] == null) continue;
                                this.getPropertyTypes()[j].nullSafeSet(statement, oldFields[j], index, session);
                                index += this.propertyColumnSpans[j];
                            }
                        }
                    }
                    if (this.isBatchable()) {
                        session.getBatcher().addToBatch(1);
                    }
                    this.check(statement.executeUpdate(), id);
                }
                catch (SQLException sqle) {
                    if (this.isBatchable()) {
                        session.getBatcher().abortBatch(sqle);
                        throw sqle;
                    }
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (this.isBatchable()) throw throwable;
                session.getBatcher().closeStatement(statement);
                throw throwable;
            }
            if (this.isBatchable()) return;
            session.getBatcher().closeStatement(statement);
            return;
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not update: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    public EntityPersister(PersistentClass model, SessionFactoryImplementor factory) throws HibernateException {
        super(model, factory);
        Object discriminatorValue;
        Class mappedClass = model.getMappedClass();
        this.factory = factory;
        Table table = model.getRootTable();
        this.qualifiedTableName = table.getQualifiedName(this.getDialect(), factory.getDefaultSchema());
        this.tableNames = new String[]{this.qualifiedTableName};
        HashSet<String> distinctColumns = new HashSet<String>();
        if (model.isPolymorphic()) {
            Value d = model.getDiscriminator();
            if (d == null) {
                throw new MappingException("discriminator mapping required for polymorphic persistence");
            }
            this.forceDiscriminator = model.isForceDiscriminator();
            Column column = (Column)d.getColumnIterator().next();
            this.discriminatorColumnName = column.getQuotedName(this.getDialect());
            this.discriminatorAlias = column.getAlias();
            this.discriminatorType = model.getDiscriminator().getType();
            if (model.isDiscriminatorValueNull()) {
                discriminatorValue = NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = InFragment.NULL;
                this.discriminatorInsertable = false;
            } else if (model.isDiscriminatorValueNotNull()) {
                discriminatorValue = NOT_NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = InFragment.NOT_NULL;
                this.discriminatorInsertable = false;
            } else {
                this.discriminatorInsertable = model.isDiscriminatorInsertable();
                try {
                    DiscriminatorType dtype = (DiscriminatorType)this.discriminatorType;
                    discriminatorValue = dtype.stringToObject(model.getDiscriminatorValue());
                    this.discriminatorSQLValue = dtype.objectToSQLString(discriminatorValue);
                }
                catch (ClassCastException cce) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception e) {
                    throw new MappingException("Could not format discriminator value to SQL string", e);
                }
                if (this.discriminatorInsertable) {
                    distinctColumns.add(this.discriminatorColumnName);
                }
            }
        } else {
            this.forceDiscriminator = false;
            this.discriminatorInsertable = false;
            this.discriminatorColumnName = null;
            this.discriminatorAlias = null;
            this.discriminatorType = null;
            discriminatorValue = null;
            this.discriminatorSQLValue = null;
        }
        this.checkColumnDuplication(distinctColumns, model.getKey().getColumnIterator());
        int hydrateSpan = this.getHydrateSpan();
        this.propertyColumnNames = new String[hydrateSpan][];
        this.propertyColumnAliases = new String[hydrateSpan][];
        this.propertyColumnSpans = new int[hydrateSpan];
        this.propertyFormulaTemplates = new String[hydrateSpan];
        HashSet<Property> thisClassProperties = new HashSet<Property>();
        Iterator iter = model.getPropertyClosureIterator();
        int i = 0;
        boolean foundColumn = false;
        boolean foundFormula = false;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            thisClassProperties.add(prop);
            if (prop.isFormula()) {
                this.propertyColumnAliases[i] = new String[]{prop.getFormula().getAlias()};
                this.propertyColumnSpans[i] = 1;
                this.propertyFormulaTemplates[i] = prop.getFormula().getTemplate(this.getDialect());
                foundFormula = true;
            } else {
                int span;
                this.propertyColumnSpans[i] = span = prop.getColumnSpan();
                String[] colNames = new String[span];
                String[] colAliases = new String[span];
                Iterator colIter = prop.getColumnIterator();
                int j = 0;
                while (colIter.hasNext()) {
                    Column col = (Column)colIter.next();
                    colAliases[j] = col.getAlias();
                    colNames[j] = col.getQuotedName(this.getDialect());
                    ++j;
                    if (!prop.isUpdateable()) continue;
                    foundColumn = true;
                }
                this.propertyColumnNames[i] = colNames;
                this.propertyColumnAliases[i] = colAliases;
            }
            ++i;
            if (!prop.isUpdateable() && !prop.isInsertable()) continue;
            this.checkColumnDuplication(distinctColumns, prop.getColumnIterator());
        }
        this.hasFormulaProperties = foundFormula;
        this.hasUpdateableColumns = foundColumn;
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> formulas = new ArrayList<String>();
        ArrayList<String> formulaAliases = new ArrayList<String>();
        ArrayList<String> formulaTemplates = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String[]> propColumns = new ArrayList<String[]>();
        ArrayList<Integer> joinedFetchesList = new ArrayList<Integer>();
        ArrayList<Boolean> definedBySubclass = new ArrayList<Boolean>();
        iter = model.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            names.add(prop.getName());
            definedBySubclass.add(new Boolean(!thisClassProperties.contains(prop)));
            types.add(prop.getType());
            if (prop.isFormula()) {
                formulas.add(prop.getFormula().getFormula());
                formulaTemplates.add(prop.getFormula().getTemplate(this.getDialect()));
                propColumns.add(ArrayHelper.EMPTY_STRING_ARRAY);
                formulaAliases.add(prop.getFormula().getAlias());
            } else {
                Iterator colIter = prop.getColumnIterator();
                String[] cols = new String[prop.getColumnSpan()];
                int l = 0;
                while (colIter.hasNext()) {
                    Column col = (Column)colIter.next();
                    columns.add(col.getQuotedName(this.getDialect()));
                    aliases.add(col.getAlias());
                    cols[l++] = col.getQuotedName(this.getDialect());
                }
                propColumns.add(cols);
            }
            joinedFetchesList.add(new Integer(prop.getValue().getOuterJoinFetchSetting()));
        }
        this.subclassColumnClosure = columns.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassFormulaClosure = formulas.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassFormulaTemplateClosure = formulaTemplates.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassPropertyTypeClosure = types.toArray(ArrayHelper.EMPTY_TYPE_ARRAY);
        this.subclassColumnAliasClosure = aliases.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassFormulaAliasClosure = formulaAliases.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassPropertyNameClosure = names.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassPropertyColumnNameClosure = (String[][])propColumns.toArray((T[])new String[propColumns.size()][]);
        this.subclassPropertyEnableJoinedFetch = new int[joinedFetchesList.size()];
        iter = joinedFetchesList.iterator();
        int j = 0;
        while (iter.hasNext()) {
            this.subclassPropertyEnableJoinedFetch[j++] = (Integer)iter.next();
        }
        this.propertyDefinedOnSubclass = new boolean[definedBySubclass.size()];
        iter = definedBySubclass.iterator();
        j = 0;
        while (iter.hasNext()) {
            this.propertyDefinedOnSubclass[j++] = (Boolean)iter.next();
        }
        this.sqlDeleteString = this.generateDeleteString();
        this.sqlInsertString = this.generateInsertString(false, this.getPropertyInsertability());
        this.sqlIdentityInsertString = this.isIdentifierAssignedByInsert() ? this.generateInsertString(true, this.getPropertyInsertability()) : null;
        this.sqlUpdateString = this.generateUpdateString(this.getPropertyUpdateability());
        this.sqlConcreteSelectString = this.generateConcreteSelectString(this.getPropertyUpdateability());
        this.sqlVersionSelectString = this.generateSelectVersionString();
        int subclassSpan = model.getSubclassSpan() + 1;
        this.subclassClosure = new Class[subclassSpan];
        this.subclassClosure[0] = mappedClass;
        if (model.isPolymorphic()) {
            this.subclassesByDiscriminatorValue.put(discriminatorValue, mappedClass);
        }
        if (model.isPolymorphic()) {
            iter = model.getSubclassIterator();
            int k = 1;
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                this.subclassClosure[k++] = sc.getMappedClass();
                if (sc.isDiscriminatorValueNull()) {
                    this.subclassesByDiscriminatorValue.put(NULL_DISCRIMINATOR, sc.getMappedClass());
                    continue;
                }
                if (sc.isDiscriminatorValueNotNull()) {
                    this.subclassesByDiscriminatorValue.put(NOT_NULL_DISCRIMINATOR, sc.getMappedClass());
                    continue;
                }
                try {
                    DiscriminatorType dtype = (DiscriminatorType)this.discriminatorType;
                    this.subclassesByDiscriminatorValue.put(dtype.stringToObject(sc.getDiscriminatorValue()), sc.getMappedClass());
                }
                catch (ClassCastException cce) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception e) {
                    throw new MappingException("Error parsing discriminator value", e);
                }
            }
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(model);
    }

    public String fromTableFragment(String name) {
        return this.getTableName() + ' ' + name;
    }

    public String queryWhereFragment(String name, boolean innerJoin, boolean includeSubclasses) throws MappingException {
        if (innerJoin && (this.forceDiscriminator || this.isInherited())) {
            InFragment frag = new InFragment().setColumn(name, this.getDiscriminatorColumnName());
            Class[] subclasses = this.getSubclassClosure();
            for (int i = 0; i < subclasses.length; ++i) {
                frag.addValue(((Queryable)this.factory.getPersister(subclasses[i])).getDiscriminatorSQLValue());
            }
            StringBuffer buf = new StringBuffer(50).append(" and ").append(frag.toFragmentString());
            if (this.hasWhere()) {
                buf.append(" and ").append(this.getSQLWhereString(name));
            }
            return buf.toString();
        }
        return this.hasWhere() ? " and " + this.getSQLWhereString(name) : "";
    }

    public String[] toColumns(String name, int i) {
        return StringHelper.qualify(name, this.subclassPropertyColumnNameClosure[i]);
    }

    public String getSubclassPropertyTableName(int i) {
        return this.qualifiedTableName;
    }

    public String propertySelectFragment(String name, String suffix) {
        SelectFragment frag = new SelectFragment().setSuffix(suffix);
        if (this.hasSubclasses()) {
            frag.addColumn(name, this.getDiscriminatorColumnName(), this.getDiscriminatorAlias());
        }
        return frag.addColumns(name, this.subclassColumnClosure, this.subclassColumnAliasClosure).addFormulas(name, this.subclassFormulaTemplateClosure, this.subclassFormulaAliasClosure).toFragmentString();
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    protected String[] getActualPropertyColumnNames(int i) {
        return this.propertyColumnNames[i];
    }

    protected String getFormulaTemplate(int i) {
        return this.propertyFormulaTemplates[i];
    }

    protected String getConcreteSelectString() {
        return this.sqlConcreteSelectString;
    }

    public boolean isCacheInvalidationRequired() {
        return this.hasFormulaProperties || !this.isVersioned() && this.useDynamicUpdate();
    }

    protected String getVersionedTableName() {
        return this.qualifiedTableName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

