/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.filter.DynamicEvaluator;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.AbstractObjectPool;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.PortableServer.POA;

public class ApplicationContext
implements Disposable,
Configurable {
    private Configuration configuration_;
    private ORB orb_;
    private POA poa_;
    private TaskProcessor taskProcessor_;
    private AbstractObjectPool evaluationResultPool_;
    private AbstractObjectPool evaluationContextPool_;
    private MessageFactory notificationEventFactory_;
    private DynAnyFactory dynAnyFactory_;
    private DynamicEvaluator dynamicEvaluator_;

    private void setup(ORB oRB, POA pOA) throws InvalidName {
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.dynAnyFactory_ = DynAnyFactoryHelper.narrow(this.orb_.resolve_initial_references("DynAnyFactory"));
        this.dynamicEvaluator_ = new DynamicEvaluator(this.dynAnyFactory_);
        this.evaluationContextPool_ = new AbstractObjectPool("EvaluationContextPool"){

            public Object newInstance() {
                EvaluationContext evaluationContext = new EvaluationContext();
                evaluationContext.setDynamicEvaluator(ApplicationContext.this.dynamicEvaluator_);
                return evaluationContext;
            }

            public void activateObject(Object object) {
                AbstractPoolable abstractPoolable = (AbstractPoolable)object;
                abstractPoolable.configure(ApplicationContext.this.configuration_);
                abstractPoolable.reset();
                abstractPoolable.setObjectPool(this);
            }
        };
        this.evaluationResultPool_ = new AbstractObjectPool("EvaluationResultPool"){

            public Object newInstance() {
                return new EvaluationResult();
            }

            public void activateObject(Object object) {
                AbstractPoolable abstractPoolable = (AbstractPoolable)object;
                abstractPoolable.reset();
                abstractPoolable.setObjectPool(this);
            }
        };
        this.notificationEventFactory_ = new MessageFactory();
        this.taskProcessor_ = new TaskProcessor();
    }

    public ApplicationContext(ORB oRB, POA pOA) throws InvalidName {
        this.setup(oRB, pOA);
    }

    public void configure(Configuration configuration) {
        this.configuration_ = configuration;
        this.dynamicEvaluator_.configure(configuration);
        this.evaluationContextPool_.configure(configuration);
        this.evaluationResultPool_.configure(configuration);
        this.notificationEventFactory_.configure(configuration);
        this.taskProcessor_.configure(configuration);
    }

    public void dispose() {
        if (this.taskProcessor_ != null) {
            this.taskProcessor_.dispose();
            this.taskProcessor_ = null;
        }
        this.evaluationContextPool_.dispose();
        this.notificationEventFactory_.dispose();
        this.orb_.shutdown(true);
    }

    public ORB getOrb() {
        return this.orb_;
    }

    public void setOrb(ORB oRB) {
        this.orb_ = oRB;
    }

    public POA getPoa() {
        return this.poa_;
    }

    public void setPoa(POA pOA) {
        this.poa_ = pOA;
    }

    private EvaluationResult newEvaluationResult() {
        return (EvaluationResult)this.evaluationResultPool_.lendObject();
    }

    public EvaluationContext newEvaluationContext() {
        return (EvaluationContext)this.evaluationContextPool_.lendObject();
    }

    public MessageFactory getMessageFactory() {
        return this.notificationEventFactory_;
    }

    public DynAnyFactory getDynAnyFactory() {
        return this.dynAnyFactory_;
    }

    public DynamicEvaluator getDynamicEvaluator() {
        return this.dynamicEvaluator_;
    }

    public TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }
}

