/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsListModel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectsList;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;

public class ConceptsList
extends RegistryObjectsList {
    public ConceptsList() {
        this(new ConceptsListModel());
    }

    public ConceptsList(ConceptsListModel model) {
        super("Concept", model);
        this.setCellRenderer(new ConceptRenderer());
    }

    class ConceptRenderer
    extends JLabel
    implements ListCellRenderer {
        public ConceptRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            try {
                ConceptsListModel model = (ConceptsListModel)list.getModel();
                Concept concept = (Concept)model.elementAt(index);
                ClassificationScheme scheme = concept.getClassificationScheme();
                String schemeName = RegistryBrowser.getName((RegistryObject)scheme);
                String keyName = RegistryBrowser.getName((RegistryObject)concept);
                String keyValue = concept.getValue();
                String str = schemeName + ":" + keyName + ":" + keyValue;
                this.setText(str);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
            return this;
        }
    }
}

