/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.HyperLinkContainer;
import com.sun.xml.registry.client.browser.HyperLinkLabel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExternalLink;

public class ExternalLinkPanel
extends RegistryObjectPanel {
    HyperLinkLabel externalURILabel = null;
    JTextField externalURIText = null;

    public ExternalLinkPanel() {
        this.setBorder(BorderFactory.createTitledBorder("External Link"));
        HyperLinkLabel externalURILabel = new HyperLinkLabel("External URI:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(externalURILabel, this.c);
        this.add(externalURILabel);
        this.externalURIText = new JTextField();
        this.externalURIText.setEditable(this.editable);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.externalURIText, this.c);
        this.add(this.externalURIText);
        externalURILabel.setHyperLinkContainer(new HyperLinkContainer(){

            public String getURL() {
                return ExternalLinkPanel.this.externalURIText.getText();
            }

            public void setURL(String url) {
                ExternalLinkPanel.this.externalURIText.setText(url);
            }
        });
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof ExternalLink)) {
            throw new InvalidRequestException("Expecting a ExternalLink. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        ExternalLink externalLink = (ExternalLink)obj;
        try {
            String externalURIStr;
            if (externalLink != null && (externalURIStr = externalLink.getExternalURI()) != null) {
                this.externalURIText.setText(externalURIStr);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            ExternalLink externalLink = (ExternalLink)this.model;
            String externalURIStr = this.externalURIText.getText().trim();
            externalLink.setExternalURI(externalURIStr);
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        String externalURIStr = this.externalURIText.getText().trim();
        if (externalURIStr.length() == 0) {
            throw new JAXRException("Error. externalURI attribute must not be empty.");
        }
    }

    public void clear() throws JAXRException {
        super.clear();
        this.externalURIText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.externalURIText.setEditable(editable);
        this.externalURIText.setEditable(editable);
    }
}

