/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.AuditableEventsDialog;
import com.sun.xml.registry.client.browser.ConceptsTreeDialog;
import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.JAXRResourceBundle;
import com.sun.xml.registry.client.browser.JBTabbedPane;
import com.sun.xml.registry.client.browser.LocaleSelectorDialog;
import com.sun.xml.registry.client.browser.conf.bindings.Configuration;
import com.sun.xml.registry.client.browser.conf.bindings.RegistryURIList;
import com.sun.xml.registry.client.browser.registration.UserManager;
import com.sun.xml.registry.ebxml.BusinessLifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.ConnectionImpl;
import com.sun.xml.registry.ebxml.infomodel.InternationalStringImpl;
import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class RegistryBrowser
extends JFrame {
    private static final Log log = LogFactory.getLog((Class)(class$com$sun$xml$registry$client$browser$RegistryBrowser == null ? (class$com$sun$xml$registry$client$browser$RegistryBrowser = RegistryBrowser.class$("com.sun.xml.registry.client.browser.RegistryBrowser")) : class$com$sun$xml$registry$client$browser$RegistryBrowser));
    static JAXRClient client = new JAXRClient();
    static JAXRResourceBundle resourceBundle = JAXRResourceBundle.getInstance();
    public static String PROPERTY_AUTHENTICATED = "PROPERTY_AUTHENTICATED";
    static final String selectAnItem = resourceBundle.getString("listBox.enterURL");
    static RegistryBrowser instance;
    public ClassLoader classLoader;
    Color buttonBackground;
    ConceptsTreeDialog conceptsTreeDialog = null;
    LocaleSelectorDialog localeSelectorDialog = null;
    JMenuBar menuBar;
    JMenuItem newItem;
    JMenuItem openItem;
    JMenuItem saveItem;
    JMenuItem saveAsItem;
    JMenuItem exitItem;
    JMenuItem cutItem;
    JMenuItem copyItem;
    JMenuItem pasteItem;
    JMenuItem aboutItem;
    FileDialog saveFileDialog = new FileDialog(this);
    FileDialog compositionDialog = new FileDialog(this);
    JFileChooser openFileDialog = new JFileChooser();
    JPanel tabbedPaneParent = new JPanel();
    JBTabbedPane tabbedPane = null;
    JPanel topPanel = new JPanel();
    JComboBox registryCombo = new JComboBox();
    JTextField currentUserText = new JTextField();
    JPanel toolbarPanel = new JPanel();
    JToolBar discoveryToolBar = null;
    JPanel registryObjectsPanel = new JPanel();
    static /* synthetic */ Class class$com$sun$xml$registry$client$browser$RegistryBrowser;

    private RegistryBrowser() {
        instance = this;
        this.classLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            this.classLoader.loadClass("javax.xml.messaging.Endpoint");
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Could not find class javax.xml.messaging.Endpoint", (Throwable)e);
        }
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenu editMenu = new JMenu();
        JMenu helpMenu = new JMenu();
        JSeparator JSeparator1 = new JSeparator();
        this.newItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.saveItem = new JMenuItem();
        this.saveAsItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.cutItem = new JMenuItem();
        this.copyItem = new JMenuItem();
        this.pasteItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.setJMenuBar(this.menuBar);
        this.setTitle("Registry Browser");
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((int)(dim.getWidth() * 0.15), (int)(dim.getHeight() * 0.1), (int)(dim.getWidth() * 0.7), (int)(dim.getHeight() * 0.75));
        this.setVisible(false);
        this.saveFileDialog.setMode(1);
        this.saveFileDialog.setTitle("Save");
        this.compositionDialog.setMode(1);
        this.compositionDialog.setTitle("Save");
        GridBagLayout gb = new GridBagLayout();
        this.topPanel.setLayout(gb);
        this.getContentPane().add("North", this.topPanel);
        GridBagConstraints c = new GridBagConstraints();
        this.toolbarPanel.setLayout(new FlowLayout(0, 0, 0));
        this.toolbarPanel.setBounds(0, 0, 488, 29);
        this.discoveryToolBar = this.createDiscoveryToolBar();
        this.toolbarPanel.add(this.discoveryToolBar);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        gb.setConstraints(this.toolbarPanel, c);
        this.topPanel.add(this.toolbarPanel);
        JPanel contextPanel = new JPanel();
        GridBagLayout gb1 = new GridBagLayout();
        contextPanel.setLayout(gb1);
        JLabel locationLabel = new JLabel(resourceBundle.getString("label.registryLocation"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.5;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        gb1.setConstraints(locationLabel, c);
        contextPanel.add(locationLabel);
        String pathSep = System.getProperty("file.separator");
        this.registryCombo.addItem(selectAnItem);
        Configuration cfg = this.getConfiguration();
        RegistryURIList urlList = cfg.getRegistryURIList();
        String[] urls = urlList.getRegistryURI();
        for (int i = 0; i < urls.length; ++i) {
            this.registryCombo.addItem(urls[i]);
        }
        this.registryCombo.setEditable(true);
        this.registryCombo.setEnabled(true);
        this.registryCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String url = (String)RegistryBrowser.this.registryCombo.getSelectedItem();
                if (url.equals(selectAnItem)) {
                    return;
                }
                RegistryBrowser.setWaitCursor();
                RegistryBrowser.this.connectToRegistry(url);
                Thread.currentThread().setContextClassLoader(RegistryBrowser.getInstance().classLoader);
                RegistryBrowser.this.conceptsTreeDialog = null;
                ConceptsTreeDialog.clearCache();
                try {
                    RegistryBrowser.this.tabbedPane = new JBTabbedPane();
                    RegistryBrowser.this.tabbedPaneParent.removeAll();
                    RegistryBrowser.this.tabbedPaneParent.add((Component)RegistryBrowser.this.tabbedPane, "Center");
                    RegistryBrowser.this.getRootPane().updateUI();
                }
                catch (JAXRException e1) {
                    RegistryBrowser.displayError(e1);
                }
                RegistryBrowser.setDefaultCursor();
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.5;
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 5, 0);
        gb1.setConstraints(this.registryCombo, c);
        contextPanel.add(this.registryCombo);
        JLabel currentUserLabel = new JLabel("Current User:", 2);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 5, 0);
        gb1.setConstraints(currentUserLabel, c);
        this.currentUserText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String text = RegistryBrowser.this.currentUserText.getText();
            }
        });
        this.currentUserText.setEditable(false);
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.5;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 5, 5);
        gb1.setConstraints(this.currentUserText, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.9;
        c.weighty = 0.5;
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        gb.setConstraints(contextPanel, c);
        this.topPanel.add((Component)contextPanel, c);
        this.tabbedPaneParent.setBorder(BorderFactory.createBevelBorder(1));
        this.tabbedPaneParent.setLayout(new BorderLayout());
        this.tabbedPaneParent.setToolTipText("Select registry location");
        this.getContentPane().add("Center", this.tabbedPaneParent);
        fileMenu.setText(resourceBundle.getString("menu.file"));
        fileMenu.setActionCommand("File");
        fileMenu.setMnemonic(70);
        this.menuBar.add(fileMenu);
        this.saveItem.setHorizontalTextPosition(4);
        this.saveItem.setText(resourceBundle.getString("menu.file.save"));
        this.saveItem.setActionCommand("Save");
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveItem.setMnemonic(83);
        fileMenu.add(JSeparator1);
        this.exitItem.setText(resourceBundle.getString("menu.file.exit"));
        this.exitItem.setActionCommand("Exit");
        this.exitItem.setMnemonic(88);
        fileMenu.add(this.exitItem);
        editMenu.setText(resourceBundle.getString("menu.edit"));
        editMenu.setActionCommand("Edit");
        editMenu.setMnemonic(69);
        this.cutItem.setHorizontalTextPosition(4);
        this.cutItem.setText(resourceBundle.getString("menu.edit.cut"));
        this.cutItem.setActionCommand("Cut");
        this.cutItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutItem.setMnemonic(84);
        editMenu.add(this.cutItem);
        this.copyItem.setHorizontalTextPosition(4);
        this.copyItem.setText(resourceBundle.getString("menu.edit.copy"));
        this.copyItem.setActionCommand("Copy");
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyItem.setMnemonic(67);
        editMenu.add(this.copyItem);
        this.pasteItem.setHorizontalTextPosition(4);
        this.pasteItem.setText(resourceBundle.getString("menu.edit.paste"));
        this.pasteItem.setActionCommand("Paste");
        this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteItem.setMnemonic(80);
        editMenu.add(this.pasteItem);
        helpMenu.setText(resourceBundle.getString("menu.help"));
        helpMenu.setActionCommand("Help");
        helpMenu.setMnemonic(72);
        this.menuBar.add(helpMenu);
        this.aboutItem.setHorizontalTextPosition(4);
        this.aboutItem.setText(resourceBundle.getString("menu.help.about"));
        this.aboutItem.setActionCommand("About...");
        this.aboutItem.setMnemonic(65);
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(RegistryBrowser.this, "ebxmlrr Registry Browser version: 2.1final1", "About ebXML Registry Browser", 1);
            }
        });
        helpMenu.add(this.aboutItem);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.saveItem.addActionListener(lSymAction);
        this.exitItem.addActionListener(lSymAction);
        SwingUtilities.updateComponentTreeUI(this.getContentPane());
        SwingUtilities.updateComponentTreeUI(this.menuBar);
        SwingUtilities.updateComponentTreeUI(this.openFileDialog);
        String selectedIndexStr = ProviderProperties.getInstance().getProperty("jaxr-ebxml.registryBrowser.registryLocationCombo.initialSelectionIndex", "0");
        int index = Integer.parseInt(selectedIndexStr);
        try {
            this.registryCombo.setSelectedIndex(index);
        }
        catch (IllegalArgumentException e) {
            RegistryBrowser.displayError("Invalid property value '" + index + "' for jaxr-ebxml.registryBrowser.registryLocationCombo.initialSelectionIndex. Check jaxr-ebxml.properties file.", e);
        }
    }

    public static RegistryBrowser getInstance() {
        if (instance == null) {
            instance = new RegistryBrowser();
        }
        return instance;
    }

    public JAXRClient getClient() {
        return client;
    }

    public void findAction() {
        this.tabbedPane.findAction();
    }

    public JToolBar createDiscoveryToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(true);
        URL findUrl = this.getClass().getClassLoader().getResource("icons/find.gif");
        ImageIcon findIcon = new ImageIcon(findUrl);
        JButton findButton = toolBar.add(new AbstractAction("", findIcon){

            public void actionPerformed(ActionEvent e) {
                RegistryBrowser.this.findAction();
            }
        });
        findButton.setToolTipText("Search");
        URL showSchemesUrl = this.getClass().getClassLoader().getResource("icons/schemeViewer.gif");
        ImageIcon showSchemesIcon = new ImageIcon(showSchemesUrl);
        JButton showSchemesButton = toolBar.add(new AbstractAction("", showSchemesIcon){

            public void actionPerformed(ActionEvent e) {
                if (RegistryBrowser.client.connection == null) {
                    RegistryBrowser.displayError("Connect to a registry by specifying Registry Location first.");
                } else {
                    ConceptsTreeDialog.showSchemes(RegistryBrowser.getInstance(), false, RegistryBrowser.this.isAuthenticated());
                }
            }
        });
        showSchemesButton.setToolTipText("Show ClassificationScheme/Concept Dialog");
        URL authenticateUrl = this.getClass().getClassLoader().getResource("icons/authenticate.gif");
        ImageIcon authenticateIcon = new ImageIcon(authenticateUrl);
        JButton authenticateButton = toolBar.add(new AbstractAction("", authenticateIcon){

            public void actionPerformed(ActionEvent e) {
                RegistryBrowser.this.authenticate();
            }
        });
        authenticateButton.setToolTipText("Log on");
        URL logoutUrl = this.getClass().getClassLoader().getResource("icons/logoff.gif");
        ImageIcon logoutIcon = new ImageIcon(logoutUrl);
        JButton logoutButton = toolBar.add(new AbstractAction("", logoutIcon){

            public void actionPerformed(ActionEvent e) {
                RegistryBrowser.this.logout();
            }
        });
        logoutButton.setToolTipText("Log off");
        URL userRegUrl = this.getClass().getClassLoader().getResource("icons/userReg.gif");
        ImageIcon userRegIcon = new ImageIcon(userRegUrl);
        JButton userRegButton = toolBar.add(new AbstractAction("", userRegIcon){

            public void actionPerformed(ActionEvent e) {
                RegistryBrowser.setWaitCursor();
                if (RegistryBrowser.client.connection == null) {
                    RegistryBrowser.displayError("Connect to a registry by specifying Registry Location first.");
                } else {
                    UserManager userMgr = UserManager.getInstance();
                    try {
                        userMgr.registerNewUser();
                    }
                    catch (Exception er) {
                        RegistryBrowser.displayError(er);
                    }
                }
                RegistryBrowser.setDefaultCursor();
            }
        });
        userRegButton.setToolTipText("Show User Registration Wizard");
        URL localeSelUrl = this.getClass().getClassLoader().getResource("icons/localeSel.gif");
        ImageIcon localeSelIcon = new ImageIcon(localeSelUrl);
        JButton localeSelButton = toolBar.add(new AbstractAction("", localeSelIcon){

            public void actionPerformed(ActionEvent e) {
                RegistryBrowser.setWaitCursor();
                if (RegistryBrowser.client.connection == null) {
                    RegistryBrowser.displayError("Connect to a registry by specifying Registry Location first.");
                } else {
                    LocaleSelectorDialog dialog = RegistryBrowser.this.getLocaleSelectorDialog();
                    dialog.setVisible(true);
                }
                RegistryBrowser.setDefaultCursor();
            }
        });
        localeSelButton.setToolTipText("Show Locale Selection Dialog");
        return toolBar;
    }

    public LocaleSelectorDialog getLocaleSelectorDialog() {
        if (this.localeSelectorDialog == null) {
            RegistryBrowser.setWaitCursor();
            this.localeSelectorDialog = new LocaleSelectorDialog(Locale.getDefault(), RegistryBrowser.getInstance(), true);
            RegistryBrowser.setDefaultCursor();
        }
        return this.localeSelectorDialog;
    }

    public Locale getSelectedLocale() {
        return this.getLocaleSelectorDialog().getSelectedLocale();
    }

    public boolean isAuthenticated() {
        boolean authenticated = false;
        if (RegistryBrowser.client.connection == null) {
            RegistryBrowser.displayError(resourceBundle.getString("message.error.noConnection"));
        } else {
            try {
                ConnectionImpl connection = RegistryBrowser.client.connection;
                authenticated = connection.isAuthenticated();
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
        return authenticated;
    }

    public void authenticate() {
        RegistryBrowser.setWaitCursor();
        if (RegistryBrowser.client.connection == null) {
            RegistryBrowser.displayError(resourceBundle.getString("message.error.noConnection"));
        } else {
            try {
                ConnectionImpl connection = RegistryBrowser.client.connection;
                boolean oldValue = connection.isAuthenticated();
                connection.authenticate();
                boolean newValue = connection.isAuthenticated();
                this.firePropertyChange(PROPERTY_AUTHENTICATED, oldValue, newValue);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
        RegistryBrowser.setDefaultCursor();
    }

    public void logout() {
        RegistryBrowser.setWaitCursor();
        if (RegistryBrowser.client.connection == null) {
            RegistryBrowser.displayError(resourceBundle.getString("message.error.noConnection"));
        } else {
            try {
                ConnectionImpl connection = RegistryBrowser.client.connection;
                boolean oldValue = connection.isAuthenticated();
                connection.logoff();
                boolean newValue = connection.isAuthenticated();
                this.firePropertyChange(PROPERTY_AUTHENTICATED, oldValue, newValue);
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
        RegistryBrowser.setDefaultCursor();
    }

    void showUserRegistrationWizard() {
        RegistryBrowser.setWaitCursor();
        if (RegistryBrowser.client.connection == null) {
            RegistryBrowser.displayError(resourceBundle.getString("message.error.noConnection"));
        }
        RegistryBrowser.setDefaultCursor();
    }

    public void connectToRegistry(String url) {
        client.createConnection(url);
    }

    public static void setWaitCursor() {
        instance.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setDefaultCursor() {
        instance.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void displayInfo(String message) {
        log.info((Object)message);
        JOptionPane.showMessageDialog(RegistryBrowser.getInstance(), message, "Information", 1);
    }

    public static void displayError(String message) {
        log.error((Object)message);
        JOptionPane.showMessageDialog(RegistryBrowser.getInstance(), message, "Error", 0);
    }

    public static void displayError(String message, Throwable t) {
        log.error((Object)message, t);
        String msg = t.getMessage();
        if (msg.length() > 200) {
            msg = msg.substring(0, 200);
            msg = msg + "....See stderr for full message.";
        }
        RegistryBrowser.displayError(message + "\n" + msg);
    }

    public static void displayError(Throwable t) {
        log.error((Object)t);
        String msg = t.getMessage();
        if (msg != null && msg.length() > 200) {
            msg = msg.substring(0, 200);
            msg = msg + "....See stderr for full message.";
        }
        RegistryBrowser.displayError(msg);
    }

    public static void main(String[] args) {
        try {
            RegistryBrowser browser = RegistryBrowser.getInstance();
            browser.pack();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            browser.setBounds(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
            browser.setVisible(true);
        }
        catch (Throwable t) {
            log.fatal((Object)t);
            t.printStackTrace();
            System.exit(1);
        }
    }

    void exitApplication(boolean doConfirm, int exitStatus) {
        boolean doExit = true;
        if (doConfirm) {
            try {
                int reply = JOptionPane.showConfirmDialog(this, resourceBundle.getString("message.confirmExit"), "Registry Browser", 0, 3);
                if (reply == 0) {
                    this.setVisible(false);
                    this.dispose();
                    exitStatus = 0;
                } else {
                    doExit = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (doExit) {
            System.exit(exitStatus);
        }
    }

    void RegistryBrowser_windowClosing(WindowEvent event) {
        this.RegistryBrowser_windowClosing_Interaction1(event);
    }

    void RegistryBrowser_windowClosing_Interaction1(WindowEvent event) {
        try {
            this.exitApplication(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void saveItem_actionPerformed(ActionEvent event) {
        if (RegistryBrowser.client.connection != null) {
            try {
                ((BusinessLifeCycleManagerImpl)client.getBusinessLifeCycleManager()).saveAllObjects();
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
        }
    }

    void exitItem_actionPerformed(ActionEvent event) {
        this.exitItem_actionPerformed_Interaction1(event);
    }

    void exitItem_actionPerformed_Interaction1(ActionEvent event) {
        try {
            this.exitApplication(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void saveButton_actionPerformed(ActionEvent event) {
        this.saveButton_actionPerformed_Interaction1(event);
    }

    void saveButton_actionPerformed_Interaction1(ActionEvent event) {
        try {
            this.saveFileDialog.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration getConfiguration() {
        boolean readCfgFromHome;
        File cfgFile;
        InputStream is;
        Configuration cfg;
        block35: {
            IOException e222;
            FilterOutputStream bos;
            BufferedInputStream bis;
            block33: {
                cfg = null;
                is = null;
                cfgFile = null;
                readCfgFromHome = true;
                String jaxrHome = null;
                jaxrHome = ProviderProperties.getInstance().getProperty("jaxr-ebxml.home");
                bis = null;
                bos = null;
                File jaxrHomeDir = new File(jaxrHome);
                if (!jaxrHomeDir.exists()) {
                    jaxrHomeDir.mkdir();
                }
                if (!(cfgFile = new File(jaxrHomeDir, "registry-browser-config.xml")).canRead()) {
                    URL cfgFileUrl = this.getClass().getResource("conf/config.xml");
                    bis = new BufferedInputStream(cfgFileUrl.openStream());
                    bos = new BufferedOutputStream(new FileOutputStream(cfgFile));
                    byte[] buffer = new byte[1024];
                    int bytesRead = 0;
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        ((BufferedOutputStream)bos).write(buffer, 0, bytesRead);
                    }
                }
                Object var13_16 = null;
                if (bis == null) break block33;
                try {
                    bis.close();
                }
                catch (IOException e222) {
                    // empty catch block
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e222) {}
            }
            break block35;
            {
                catch (IOException ioe) {
                    IOException e222;
                    readCfgFromHome = false;
                    log.warn((Object)"Unable to store browser configuration in user home");
                    Object var13_17 = null;
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e222) {
                            // empty catch block
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var13_18 = null;
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e222) {
                        // empty catch block
                    }
                }
                if (bos == null) throw throwable;
                try {
                    bos.close();
                    throw throwable;
                }
                catch (IOException e222) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (readCfgFromHome) {
            is = new FileInputStream(cfgFile);
        } else {
            URL cfgFileUrl = this.getClass().getResource("conf/config.xml");
            is = cfgFileUrl.openStream();
        }
        cfg = Configuration.unmarshal((Reader)new InputStreamReader(is));
        Object var16_23 = null;
        if (is == null) return cfg;
        try {
            is.close();
            return cfg;
        }
        catch (IOException e3) {}
        return cfg;
        {
            catch (IOException e) {
                RegistryBrowser.displayError("Unable to load browser configuration", e);
                Object var16_24 = null;
                if (is == null) return cfg;
                try {
                    is.close();
                    return cfg;
                }
                catch (IOException e3) {}
                return cfg;
            }
            catch (ValidationException e) {
                RegistryBrowser.displayError("Unable to load browser configuration", e);
                Object var16_25 = null;
                if (is == null) return cfg;
                try {
                    is.close();
                    return cfg;
                }
                catch (IOException e3) {}
                return cfg;
            }
            catch (MarshalException e) {
                RegistryBrowser.displayError("Unable to load browser configuration", e);
                Object var16_26 = null;
                if (is == null) return cfg;
                try {
                    is.close();
                    return cfg;
                }
                catch (IOException e3) {}
                return cfg;
            }
        }
        catch (Throwable throwable) {
            Object var16_27 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String getName(RegistryObject ro) throws JAXRException {
        try {
            return ((InternationalStringImpl)ro.getName()).getClosestValue();
        }
        catch (NullPointerException npe) {
            return "";
        }
    }

    public static String getDescription(RegistryObject ro) throws JAXRException {
        try {
            return ((InternationalStringImpl)ro.getDescription()).getClosestValue();
        }
        catch (NullPointerException npe) {
            return "";
        }
    }

    public static void retrieveItem(RegistryObject registryObject) {
        DataHandler repositoryItem = null;
        File defaultItemFile = null;
        try {
            repositoryItem = ((ExtrinsicObject)registryObject).getRepositoryItem();
            if (repositoryItem == null) {
                RegistryBrowser.displayInfo("There is no repository item for this object");
                return;
            }
            String fileName = RegistryBrowser.getName(registryObject);
            defaultItemFile = new File(fileName);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        JFileChooser saveChooser = new JFileChooser();
        saveChooser.setDialogTitle("Save As...");
        saveChooser.setApproveButtonText("Save");
        saveChooser.setSelectedFile(defaultItemFile);
        int returnVal = saveChooser.showDialog(null, null);
        if (returnVal == 0) {
            try {
                InputStream item = repositoryItem.getInputStream();
                File itemFile = saveChooser.getSelectedFile();
                itemFile.createNewFile();
                FileOutputStream itemFileOut = new FileOutputStream(itemFile);
                int size = item.available();
                byte[] buff = new byte[size];
                while (item.read(buff) != -1) {
                    itemFileOut.write(buff);
                }
                itemFileOut.flush();
                itemFileOut.close();
            }
            catch (IOException e) {
                RegistryBrowser.displayError(e);
            }
        }
    }

    public static void showAuditTrail(RegistryObject registryObject) {
        AuditableEventsDialog dialog = new AuditableEventsDialog((JFrame)RegistryBrowser.getInstance(), false, registryObject);
        dialog.setVisible(true);
    }

    public static String getUserName(User user, int registryLevel) throws JAXRException {
        String userName = "";
        if (user != null && user.getPersonName() != null) {
            PersonName personName = user.getPersonName();
            if (registryLevel == 0) {
                userName = personName.getFullName();
            } else {
                String firstName = personName.getFirstName();
                String middleName = personName.getMiddleName();
                String lastName = personName.getLastName();
                if (firstName != null) {
                    userName = firstName;
                }
                if (middleName != null) {
                    userName = userName + " " + middleName;
                }
                if (lastName != null) {
                    userName = userName + " " + lastName;
                }
            }
        }
        return userName;
    }

    public static String getEventTypeAsString(int eventType) throws JAXRException {
        if (eventType == 0) {
            return "Created";
        }
        if (eventType == 1) {
            return "Deleted";
        }
        if (eventType == 2) {
            return "Deprecated";
        }
        if (eventType == 5) {
            return "Undeprecated";
        }
        if (eventType == 3) {
            return "Updated";
        }
        if (eventType == 4) {
            return "Versioned";
        }
        return "Unknown Event Type";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JAXRBrowserClassLoader
    extends ClassLoader {
        JAXRBrowserClassLoader(ClassLoader parent) {
            log.info((Object)("JAXRBrowserClassLoader: Using parent classloader: " + parent));
        }

        protected Class findClass(String className) throws ClassNotFoundException {
            log.info((Object)("findClass: " + className));
            return super.findClass(className);
        }

        protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
            log.info((Object)("loadClass: " + className + " resolve = " + resolve));
            return super.loadClass(className, resolve);
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            Class<?> clazz;
            log.info((Object)("loadClass: " + className));
            try {
                clazz = super.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e);
                clazz = this.getParent().loadClass(className);
            }
            return clazz;
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RegistryBrowser.this.saveItem) {
                RegistryBrowser.this.saveItem_actionPerformed(event);
            } else if (object == RegistryBrowser.this.exitItem) {
                RegistryBrowser.this.exitItem_actionPerformed(event);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == RegistryBrowser.this) {
                RegistryBrowser.this.RegistryBrowser_windowClosing(event);
            }
        }
    }
}

