/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.RegistryObjectPanel;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.RegistryEntry;

public class RegistryEntryPanel
extends RegistryObjectPanel {
    JTextField expirationText = null;
    JComboBox stabilityCombo = null;
    JComboBox statusCombo = null;
    JTextField majorVersionText = null;
    JTextField minorVersionText = null;
    JTextField userVersionText = null;
    String[] stabilityTypes = new String[]{"Dynamic", "DynamicCompatible", "Static"};
    String[] statusTypes = new String[]{"Submitted", "Approved", "Deprecated", "Withdrawn"};

    public RegistryEntryPanel() {
        this.setBorder(BorderFactory.createTitledBorder("RegistryEntry Details"));
        JLabel statusLabel = new JLabel("Status:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(statusLabel, this.c);
        this.add(statusLabel);
        this.statusCombo = new JComboBox<String>(this.statusTypes);
        this.statusCombo.setEnabled(false);
        this.c.gridx = 0;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.statusCombo, this.c);
        this.add(this.statusCombo);
        JLabel expirationLabel = new JLabel("expiration:", 2);
        this.c.gridx = 1;
        this.c.gridy = this.row + 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(expirationLabel, this.c);
        this.add(expirationLabel);
        this.expirationText = new JTextField();
        this.expirationText.setEditable(this.editable);
        this.c.gridx = 1;
        this.c.gridy = this.row + 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.expirationText, this.c);
        this.add(this.expirationText);
        JLabel stabilityLabel = new JLabel("Stability:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(stabilityLabel, this.c);
        this.add(stabilityLabel);
        this.stabilityCombo = new JComboBox<String>(this.stabilityTypes);
        this.stabilityCombo.setEditable(this.editable);
        this.stabilityCombo.setEnabled(this.editable);
        this.c.gridx = 0;
        this.c.gridy = this.row + 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.stabilityCombo, this.c);
        this.add(this.stabilityCombo);
        JLabel majorVersionLabel = new JLabel("Major Version:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(majorVersionLabel, this.c);
        this.majorVersionText = new JTextField();
        this.majorVersionText.setEditable(this.editable);
        this.c.gridx = 0;
        this.c.gridy = this.row + 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.majorVersionText, this.c);
        JLabel minorVersionLabel = new JLabel("Minor Version:", 2);
        this.c.gridx = 1;
        this.c.gridy = this.row + 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(minorVersionLabel, this.c);
        this.minorVersionText = new JTextField();
        this.minorVersionText.setEditable(this.editable);
        this.c.gridx = 1;
        this.c.gridy = this.row + 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.minorVersionText, this.c);
        JLabel userVersionLabel = new JLabel("User Version:", 2);
        this.c.gridx = 0;
        this.c.gridy = this.row + 6;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(userVersionLabel, this.c);
        this.add(userVersionLabel);
        this.userVersionText = new JTextField();
        this.userVersionText.setEditable(this.editable);
        this.c.gridx = 0;
        this.c.gridy = this.row + 7;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.c.insets = new Insets(4, 4, 0, 4);
        this.gbl.setConstraints(this.userVersionText, this.c);
        this.add(this.userVersionText);
        this.row += 8;
    }

    RegistryEntry getRegistryEntry() {
        return (RegistryEntry)this.model;
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof RegistryEntry)) {
            throw new InvalidRequestException("Expecting a RegistryEntry. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        RegistryEntry re = (RegistryEntry)obj;
        try {
            Date expiration = re.getExpiration();
            String userVersion = re.getUserVersion();
            int stability = re.getStability();
            int status = re.getStatus();
            if (expiration != null) {
                this.expirationText.setText(expiration.toLocaleString());
            }
            if (userVersion != null) {
                this.userVersionText.setText(userVersion);
            }
            if (stability < this.stabilityTypes.length) {
                this.stabilityCombo.setSelectedIndex(stability);
            } else {
                RegistryBrowser.displayError("Stability out of bounds: index = " + stability);
            }
            if (status < this.statusTypes.length) {
                this.statusCombo.setSelectedIndex(status);
            } else {
                RegistryBrowser.displayError("Status out of bounds: index = " + status);
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            RegistryEntry re = (RegistryEntry)this.model;
            JAXRClient client = RegistryBrowser.getInstance().getClient();
            re.setUserVersion(this.userVersionText.getText());
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        RegistryEntry re = (RegistryEntry)this.model;
    }

    public void clear() throws JAXRException {
        super.clear();
        this.majorVersionText.setText("");
        this.minorVersionText.setText("");
        this.expirationText.setText("");
        this.userVersionText.setText("");
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.majorVersionText.setEditable(editable);
        this.minorVersionText.setEditable(editable);
        this.expirationText.setEditable(editable);
        this.userVersionText.setEditable(editable);
        this.stabilityCombo.setEditable(editable);
        this.stabilityCombo.setEnabled(editable);
    }
}

