/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTreeModel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class TreeCombo
extends JComboBox {
    static final int OFFSET = 16;
    TreeModel treeModel = null;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public TreeCombo(TreeModel aTreeModel) {
        this.treeModel = aTreeModel;
        this.setModel(new TreeToListModel(aTreeModel));
        this.setRenderer(new ListEntryRenderer());
        this.addActionListener(new TreeComboActionListener());
    }

    public Object getSelectedItemsObject() {
        return ((ListEntry)this.getSelectedItem()).object();
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        URL leafUrl = this.getClass().getClassLoader().getResource("icons/document.gif");
        ImageIcon leafIcon = new ImageIcon(this.leafUrl);
        URL nodeUrl = this.getClass().getClassLoader().getResource("icons/folder.gif");
        ImageIcon nodeIcon = new ImageIcon(this.nodeUrl);

        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListEntry listEntry = (ListEntry)value;
            if (listEntry != null) {
                this.setText(listEntry.object().toString());
                this.setIcon(listEntry.isNode() ? this.nodeIcon : this.leafIcon);
                Border border = index != -1 ? new EmptyBorder(0, 16 * listEntry.level(), 0, 0) : emptyBorder;
                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    if (index == -1) {
                        this.setOpaque(false);
                    } else {
                        this.setOpaque(true);
                    }
                } else {
                    this.setOpaque(true);
                }
                this.setBorder(border);
                if (isSelected) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    public class TreeComboActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            TreeCombo cb = (TreeCombo)e.getSource();
            Object anObject = TreeCombo.this.getSelectedItem();
            if (anObject == null) {
                return;
            }
            if (anObject instanceof ListEntry) {
                ListEntry listEntry = (ListEntry)anObject;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)listEntry.object();
                RegistryBrowser.setWaitCursor();
                int depth = 1;
                if ((e.getModifiers() & 1) != 0) {
                    depth = -1;
                }
                ((ConceptsTreeModel)TreeCombo.this.treeModel).expandTree(node, depth);
                RegistryBrowser.setDefaultCursor();
            }
        }
    }

    class ListEntry {
        Object object;
        int level;
        boolean isNode;

        public ListEntry(Object anObject, int aLevel, boolean isNode) {
            this.object = anObject;
            this.level = aLevel;
            this.isNode = isNode;
        }

        public Object object() {
            return this.object;
        }

        public int level() {
            return this.level;
        }

        public boolean isNode() {
            return this.isNode;
        }

        public String toString() {
            return this.object.toString();
        }
    }

    class TreeToListModel
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        TreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(TreeModel aTreeModel) {
            this.source = aTreeModel;
            aTreeModel.addTreeModelListener(this);
            TreeCombo.this.setRenderer(new ListEntryRenderer());
        }

        public void setSelectedItem(Object anObject) {
            this.currentValue = anObject;
            if (anObject == null) {
                return;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        public Object getElementAt(int index) {
            return this.cache.elementAt(index);
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new Vector();
                this.cacheTree(this.source.getRoot(), 0);
                if (this.cache.size() > 0 && this.currentValue == null) {
                    this.currentValue = this.cache.elementAt(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object anObject, int level) {
            if (this.source.isLeaf(anObject)) {
                this.addListEntry(anObject, level, false);
            } else {
                int c = this.source.getChildCount(anObject);
                this.addListEntry(anObject, level, true);
                ++level;
                for (int i = 0; i < c; ++i) {
                    Object child = this.source.getChild(anObject, i);
                    this.cacheTree(child, level);
                }
                --level;
            }
        }

        void addListEntry(Object anObject, int level, boolean isNode) {
            this.cache.addElement(new ListEntry(anObject, level, isNode));
        }
    }
}

