/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.graph;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.RegistryObject;

public class ReferencePanel
extends JPanel {
    private RegistryObject src = null;
    private RegistryObject target = null;
    private GridBagConstraints c = new GridBagConstraints();
    String[] refAttributes = new String[0];
    JComboBox refAttributeCombo = null;
    boolean isCollectionRef = false;

    public ReferencePanel(RegistryObject src, RegistryObject target) {
        this.src = src;
        this.target = target;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        JLabel refAttributeLabel = new JLabel("Reference Attribute:", 2);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(refAttributeLabel, this.c);
        this.add(refAttributeLabel);
        this.refAttributeCombo = new JComboBox<String>(this.getReferenceAttributes());
        this.refAttributeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.refAttributeCombo.setEditable(true);
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.refAttributeCombo, this.c);
        this.add(this.refAttributeCombo);
    }

    public void setReferenceAttributeOnSourceObject() throws JAXRException {
        String referenceAttribute = (String)this.refAttributeCombo.getSelectedItem();
        try {
            Class<?> srcClass = this.src.getClass();
            Class<?> targetClass = this.target.getClass();
            Class<?> registryObjectClass = null;
            String targetInterfaceName = targetClass.getName();
            targetInterfaceName = targetInterfaceName.substring(targetInterfaceName.lastIndexOf(".") + 1);
            if (targetInterfaceName.endsWith("Impl")) {
                targetInterfaceName = targetInterfaceName.substring(0, targetInterfaceName.length() - 4);
            }
            targetInterfaceName = "javax.xml.registry.infomodel." + targetInterfaceName;
            ClassLoader classLoader = srcClass.getClassLoader();
            try {
                targetClass = classLoader.loadClass(targetInterfaceName);
                registryObjectClass = classLoader.loadClass("javax.xml.registry.infomodel.RegistryObject");
            }
            catch (ClassNotFoundException e) {
                throw new JAXRException("No JAXR interface found by name " + targetInterfaceName);
            }
            String suffix = referenceAttribute.substring(0, 1).toUpperCase() + referenceAttribute.substring(1, referenceAttribute.length());
            Method method = null;
            Class[] paramTypes = new Class[1];
            try {
                paramTypes[0] = targetClass;
                method = srcClass.getMethod("set" + suffix, paramTypes);
                Object[] params = new Object[]{this.target};
                method.invoke((Object)this.src, params);
                this.isCollectionRef = false;
                return;
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            try {
                paramTypes[0] = registryObjectClass;
                method = srcClass.getMethod("set" + suffix, paramTypes);
                Object[] params = new Object[]{this.target};
                method.invoke((Object)this.src, params);
                this.isCollectionRef = false;
                return;
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (suffix.endsWith("s")) {
                suffix = suffix.substring(0, suffix.length() - 1);
            }
            try {
                paramTypes[0] = targetClass;
                method = srcClass.getMethod("add" + suffix, paramTypes);
                Object[] params = new Object[]{this.target};
                method.invoke((Object)this.src, params);
                this.isCollectionRef = true;
                return;
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (suffix.endsWith("e")) {
                suffix = suffix.substring(0, suffix.length() - 1);
            }
            try {
                paramTypes[0] = targetClass;
                method = srcClass.getMethod("add" + suffix, paramTypes);
                Object[] params = new Object[]{this.target};
                method.invoke((Object)this.src, params);
                this.isCollectionRef = true;
                return;
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            throw new JAXRException("No method found for reference attribute " + referenceAttribute + " for src object of type " + srcClass.getName());
        }
        catch (IllegalArgumentException e) {
            throw new JAXRException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JAXRException(e.getCause());
        }
        catch (ExceptionInInitializerError e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public String getReferenceAttribute() {
        String refAttribute = (String)this.refAttributeCombo.getSelectedItem();
        return refAttribute;
    }

    public String[] getReferenceAttributes() {
        return this.refAttributes;
    }

    public void setReferenceAttributes(String[] refAttributes) {
        this.refAttributes = refAttributes;
        this.refAttributeCombo.setModel(new DefaultComboBoxModel<String>(refAttributes));
    }
}

