/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser.registration;

import com.sun.xml.registry.client.browser.swing.RegistryMappedModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.User;

public class PostalAddressModel
extends RegistryMappedModel {
    public static final String[] ADDRESS_TYPES = new String[]{"Home", "Office", "Vacation", "Temporary"};
    private final User user;
    private final Map addresses = new HashMap();

    PostalAddressModel(User u) {
        super(ADDRESS_TYPES[0]);
        this.user = u;
    }

    public void setStreetNum(String streetNum) throws JAXRException {
        streetNum = streetNum.trim();
        if (this.addresses.containsKey(this.key)) {
            PostalAddress postalAddress = (PostalAddress)this.addresses.get(this.key);
            postalAddress.setStreetNumber(streetNum);
        } else {
            PostalAddress postalAddress = this.user.getLifeCycleManager().createPostalAddress(streetNum, "", "", "", "", "", this.key);
            this.addresses.put(this.key, postalAddress);
            this.user.setPostalAddresses(this.addresses.values());
        }
    }

    public void setStreet(String street) throws JAXRException {
        street = street.trim();
        if (this.addresses.containsKey(this.key)) {
            PostalAddress postalAddress = (PostalAddress)this.addresses.get(this.key);
            postalAddress.setStreet(street);
        } else {
            PostalAddress postalAddress = this.user.getLifeCycleManager().createPostalAddress("", street, "", "", "", "", this.key);
            this.addresses.put(this.key, postalAddress);
            this.user.setPostalAddresses(this.addresses.values());
        }
    }

    public void setCity(String city) throws JAXRException {
        city = city.trim();
        if (this.addresses.containsKey(this.key)) {
            PostalAddress postalAddress = (PostalAddress)this.addresses.get(this.key);
            postalAddress.setCity(city);
        } else {
            PostalAddress postalAddress = this.user.getLifeCycleManager().createPostalAddress("", "", city, "", "", "", this.key);
            this.addresses.put(this.key, postalAddress);
            this.user.setPostalAddresses(this.addresses.values());
        }
    }

    public void setState(String state) throws JAXRException {
        state = state.trim();
        if (this.addresses.containsKey(this.key)) {
            PostalAddress postalAddress = (PostalAddress)this.addresses.get(this.key);
            postalAddress.setStateOrProvince(state);
        } else {
            PostalAddress postalAddress = this.user.getLifeCycleManager().createPostalAddress("", "", "", state, "", "", this.key);
            this.addresses.put(this.key, postalAddress);
            this.user.setPostalAddresses(this.addresses.values());
        }
    }

    public void setPostalCode(String code) throws JAXRException {
        code = code.trim();
        if (this.addresses.containsKey(this.key)) {
            PostalAddress postalAddress = (PostalAddress)this.addresses.get(this.key);
            postalAddress.setPostalCode(code);
        } else {
            PostalAddress postalAddress = this.user.getLifeCycleManager().createPostalAddress("", "", "", "", "", code, this.key);
            this.addresses.put(this.key, postalAddress);
            this.user.setPostalAddresses(this.addresses.values());
        }
    }

    public void setCountry(String country) throws JAXRException {
        country = country.trim();
        if (this.addresses.containsKey(this.key)) {
            PostalAddress postalAddress = (PostalAddress)this.addresses.get(this.key);
            postalAddress.setCountry(country);
        } else {
            PostalAddress postalAddress = this.user.getLifeCycleManager().createPostalAddress("", "", "", "", country, "", this.key);
            this.addresses.put(this.key, postalAddress);
            this.user.setPostalAddresses(this.addresses.values());
        }
    }

    public PostalAddress getAddress() {
        PostalAddress address = (PostalAddress)this.addresses.get(this.key);
        return address;
    }

    public void validate() throws JAXRException {
        Collection addressSet = this.addresses.values();
        PostalAddress address = null;
        Iterator i = addressSet.iterator();
        while (i.hasNext()) {
            address = (PostalAddress)i.next();
            String city = address.getCity();
            String country = address.getCountry();
            String code = address.getPostalCode();
            String state = address.getStateOrProvince();
            String street = address.getStreet();
            String number = address.getStreetNumber();
            if (city != null && city.length() != 0 || country != null && country.length() != 0 || code != null && code.length() != 0 || state != null && state.length() != 0 || street != null && street.length() != 0 || number != null && number.length() != 0) continue;
            this.addresses.remove(address.getType());
        }
        this.user.setPostalAddresses(this.addresses.values());
        if (this.addresses.isEmpty()) {
            throw new JAXRException("Missing required PostalAddress on User");
        }
    }
}

