/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.DeclarativeQueryManagerImpl;
import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import com.sun.xml.registry.ebxml.infomodel.UserImpl;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.AssociationType1;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;

public class AssociationImpl
extends RegistryObjectImpl
implements Association {
    public static final String ASSOCIATION_TYPE_RELATED_TO = "RelatedTo";
    public static final String ASSOCIATION_TYPE_HAS_FEDERATION_MEMBER = "HasFederationMember";
    public static final String ASSOCIATION_TYPE_HAS_MEMBER = "HasMember";
    public static final String ASSOCIATION_TYPE_EXTERNALLY_LINKS = "ExternallyLinks";
    public static final String ASSOCIATION_TYPE_CONTAINS = "Contains";
    public static final String ASSOCIATION_TYPE_EQUIVALENT_TO = "EquivalentTo";
    public static final String ASSOCIATION_TYPE_EXTENDS = "Extends";
    public static final String ASSOCIATION_TYPE_IMPLEMENTS = "Implements";
    public static final String ASSOCIATION_TYPE_INSTANCE_OF = "InstanceOf";
    public static final String ASSOCIATION_TYPE_SUPERSEDES = "Supersedes";
    public static final String ASSOCIATION_TYPE_USES = "Uses";
    public static final String ASSOCIATION_TYPE_REPLACES = "Replaces";
    public static final String ASSOCIATION_TYPE_SUBMITTER_OF = "SubmitterOf";
    public static final String ASSOCIATION_TYPE_RESPONSIBLE_FOR = "ResponsibleFor";
    public static final String ASSOCIATION_TYPE_OFFERS_SERVICE = "OffersService";
    public static final String ASSOCIATION_TYPE_CONTENT_MANAGEMENT_SERVICE_FOR = "ContentManagementServiceFor";
    public static final String ASSOCIATION_TYPE_INVOCATION_CONTROL_FILE_FOR = "InvocationControlFileFor";
    public static final String CANONICAL_ID_NODE_ASSOCIATION_TYPE_EXTERNALLY_LINKS = "urn:uuid:92d03292-84a0-4b86-8139-dd244173ddbb";
    private RegistryObjectRef sourceObjectRef = null;
    private RegistryObjectRef targetObjectRef = null;
    private boolean confirmedBySourceOwner;
    private boolean confirmedByTargetOwner;
    Concept assocType = null;
    private static ClassificationScheme assocTypeScheme = null;
    private static HashMap assocTypesMap = null;

    public AssociationImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
    }

    public AssociationImpl(LifeCycleManagerImpl lcm, AssociationType1 ebAss) throws JAXRException {
        super(lcm, ebAss);
        String assocTypeStr = ebAss.getAssociationType();
        DeclarativeQueryManagerImpl dqm = (DeclarativeQueryManagerImpl)lcm.getRegistryService().getDeclarativeQueryManager();
        if (assocTypeScheme == null) {
            assocTypeScheme = (ClassificationScheme)this.bqm.getRegistryObject("urn:uuid:6902675f-2f18-44b8-888b-c91db8b96b4d", "ClassificationScheme");
            AssociationImpl.initializeAssociationTypesMap();
        }
        this.assocType = (Concept)assocTypesMap.get(assocTypeStr);
        if (this.assocType == null) {
            this.assocType = assocTypeStr.startsWith("urn:uuid:") ? (Concept)this.bqm.getRegistryObject(assocTypeStr, "Concept") : this.bqm.findConceptByPath("/" + assocTypeScheme.getKey().getId() + "/" + assocTypeStr);
            if (this.assocType == null) {
                this.assocType = lcm.createConcept((RegistryObject)assocTypeScheme, assocTypeStr, assocTypeStr);
            }
            assocTypesMap.put(assocTypeStr, this.assocType);
        }
        this.sourceObjectRef = new RegistryObjectRef(lcm, ebAss.getSourceObject());
        this.targetObjectRef = new RegistryObjectRef(lcm, ebAss.getTargetObject());
        this.confirmedBySourceOwner = ebAss.getIsConfirmedBySourceOwner();
        this.confirmedByTargetOwner = ebAss.getIsConfirmedByTargetOwner();
    }

    private static void initializeAssociationTypesMap() {
        assocTypesMap = new HashMap();
        try {
            Collection assocTypes = assocTypeScheme.getChildrenConcepts();
            Iterator iter = assocTypes.iterator();
            while (iter.hasNext()) {
                Concept concept = (Concept)iter.next();
                String value = concept.getValue();
                assocTypesMap.put(value, concept);
            }
        }
        catch (JAXRException e) {
            e.printStackTrace();
        }
    }

    public String toXML() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.Association ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (ValidationException x) {
            throw new JAXRException((Throwable)x);
        }
        return sw.toString();
    }

    public RegistryObjectRef getSourceObjectRef() throws JAXRException {
        return this.sourceObjectRef;
    }

    public RegistryObject getSourceObject() throws JAXRException {
        RegistryObject sourceObject = null;
        if (this.sourceObjectRef != null) {
            sourceObject = this.sourceObjectRef.getRegistryObject("RegistryObject");
        }
        return sourceObject;
    }

    void setSourceObjectInternal(RegistryObject sourceObject) throws JAXRException {
        this.sourceObjectRef = new RegistryObjectRef(this.lcm, sourceObject);
        this.setModified(true);
    }

    public void setSourceObject(RegistryObject sourceObject) throws JAXRException {
        sourceObject.addAssociation((Association)this);
    }

    public void setSourceObjectRef(RegistryObjectRef sourceObjectRef) throws JAXRException {
        this.sourceObjectRef = sourceObjectRef;
        this.setModified(true);
    }

    public RegistryObjectRef getTargetObjectRef() throws JAXRException {
        return this.targetObjectRef;
    }

    public RegistryObject getTargetObject() throws JAXRException {
        RegistryObject targetObject = null;
        if (this.targetObjectRef != null) {
            targetObject = this.targetObjectRef.getRegistryObject("RegistryObject");
        }
        return targetObject;
    }

    public void setTargetObject(RegistryObject targetObject) throws JAXRException {
        this.targetObjectRef = new RegistryObjectRef(this.lcm, targetObject);
        this.setModified(true);
    }

    public void setTargetObjectRef(RegistryObjectRef targetObjectRef) throws JAXRException {
        this.targetObjectRef = targetObjectRef;
        this.setModified(true);
    }

    public Concept getAssociationType() throws JAXRException {
        if (this.assocType == null) {
            this.assocType = (Concept)this.bqm.getRegistryObject("urn:uuid:7aad31a7-501e-4cbc-ac37-ddc44fdf3e1a", "Concept");
        }
        return this.assocType;
    }

    public void setAssociationType(Concept par1) throws JAXRException {
        this.assocType = par1;
        this.setModified(true);
        this.confirmedByTargetOwner = false;
    }

    public boolean isExtramural() throws JAXRException {
        RegistryObjectImpl srcObject = (RegistryObjectImpl)this.getSourceObject();
        RegistryObjectImpl targetObject = (RegistryObjectImpl)this.getTargetObject();
        RegistryObjectImpl sourceOwner = null;
        RegistryObjectImpl targetOwner = null;
        if (srcObject != null && targetObject != null) {
            String trgAlias;
            String srcAlias;
            if (srcObject.isNew()) {
                LifeCycleManagerImpl srcLM = (LifeCycleManagerImpl)srcObject.getLifeCycleManager();
                srcAlias = srcLM.getCallerAlias();
            } else {
                srcAlias = srcObject.getOwner().getKey().getId();
            }
            if (targetObject.isNew()) {
                LifeCycleManagerImpl trgLM = (LifeCycleManagerImpl)targetObject.getLifeCycleManager();
                trgAlias = trgLM.getCallerAlias();
            } else {
                trgAlias = targetObject.getOwner().getKey().getId();
            }
            if (this.isNew()) {
                if (srcAlias == null) {
                    return false;
                }
                return !srcAlias.equals(trgAlias);
            }
            String alias = this.getOwner().getKey().getId();
            return !alias.equals(srcAlias) || !alias.equals(trgAlias);
        }
        if (this.isNew() || this.sourceObjectRef == null || this.targetObjectRef == null) {
            return false;
        }
        if (srcObject == null) {
            return false;
        }
        if (targetObject == null) {
            return false;
        }
        UserImpl assOwner = (UserImpl)this.getOwner();
        if (assOwner == null) {
            return false;
        }
        return !assOwner.getId().equals(targetOwner.getId()) || !assOwner.getId().equals(sourceOwner.getId());
    }

    public boolean isConfirmedBySourceOwner() throws JAXRException {
        return !this.isExtramural() || this.confirmedBySourceOwner;
    }

    public boolean isConfirmedByTargetOwner() throws JAXRException {
        return !this.isExtramural() || this.confirmedByTargetOwner;
    }

    public boolean isConfirmed() throws JAXRException {
        boolean confirmed = false;
        if (this.isConfirmedBySourceOwner() && this.isConfirmedByTargetOwner()) {
            confirmed = true;
        }
        return confirmed;
    }

    public void confirm(LifeCycleManager lcm) throws JAXRException {
        String trgAlias;
        String srcAlias;
        LifeCycleManagerImpl lcmImpl = (LifeCycleManagerImpl)lcm;
        String alias = lcmImpl.getCallerAlias();
        RegistryObjectImpl srcObject = (RegistryObjectImpl)this.getSourceObject();
        if (srcObject.isNew()) {
            LifeCycleManagerImpl srcLcm = (LifeCycleManagerImpl)srcObject.getLifeCycleManager();
            srcAlias = srcLcm.getCallerAlias();
        } else {
            srcAlias = srcObject.getOwner().getKey().getId();
        }
        RegistryObjectImpl trgObject = (RegistryObjectImpl)this.getTargetObject();
        if (trgObject.isNew()) {
            LifeCycleManagerImpl trgLcm = (LifeCycleManagerImpl)trgObject.getLifeCycleManager();
            trgAlias = trgLcm.getCallerAlias();
        } else {
            trgAlias = trgObject.getOwner().getKey().getId();
        }
        if (alias.equals(srcAlias)) {
            this.confirmedBySourceOwner = true;
        }
        if (alias.equals(trgAlias)) {
            this.confirmedByTargetOwner = true;
        }
        System.out.println("Association.confirm> alias=" + alias + ", srcAlias=" + srcAlias + ", trgAlias=" + trgAlias);
        this.setModified(true);
    }

    public org.oasis.ebxml.registry.bindings.rim.Association toBindingObject() throws JAXRException {
        org.oasis.ebxml.registry.bindings.rim.Association ebOrg = new org.oasis.ebxml.registry.bindings.rim.Association();
        this.setBindingObject(ebOrg);
        return ebOrg;
    }

    protected void setBindingObject(AssociationType1 ebAssociation) throws JAXRException {
        super.setBindingObject(ebAssociation);
        if (this.assocType != null) {
            ebAssociation.setAssociationType(this.assocType.getKey().getId());
        }
        ObjectRef ebSourceObjectRef = new ObjectRef();
        ebSourceObjectRef.setId(this.sourceObjectRef.getId());
        ebAssociation.setSourceObject(ebSourceObjectRef);
        ObjectRef ebTargetObjectRef = new ObjectRef();
        ebTargetObjectRef.setId(this.targetObjectRef.getId());
        ebAssociation.setTargetObject(ebTargetObjectRef);
        boolean srcConfirmed = this.isConfirmedBySourceOwner();
        System.out.println("Association.setBindingObject> confirmed by source: " + srcConfirmed);
        ebAssociation.setIsConfirmedBySourceOwner(srcConfirmed);
        boolean trgConfirmed = this.isConfirmedByTargetOwner();
        System.out.println("Association.setBindingObject> confirmed by target: " + trgConfirmed);
        ebAssociation.setIsConfirmedByTargetOwner(trgConfirmed);
        System.out.println("Association.setBindingObject> isExtramural: " + this.isExtramural());
    }

    public HashSet getRegistryObjectRefs() {
        HashSet<RegistryObjectRef> refs = new HashSet<RegistryObjectRef>();
        if (this.sourceObjectRef != null) {
            refs.add(this.sourceObjectRef);
        }
        if (this.targetObjectRef != null) {
            refs.add(this.targetObjectRef);
        }
        return refs;
    }
}

