/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import java.io.StringWriter;
import java.sql.Timestamp;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.User;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.AuditableEvent;
import org.oasis.ebxml.registry.bindings.rim.AuditableEventType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.types.EventTypeType;

public class AuditableEventImpl
extends RegistryObjectImpl
implements javax.xml.registry.infomodel.AuditableEvent {
    private RegistryObjectRef userRef = null;
    private Timestamp timestamp = null;
    private int eventType = 0;
    private RegistryObjectRef registryObjectRef = null;

    public AuditableEventImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
    }

    public AuditableEventImpl(LifeCycleManagerImpl lcm, AuditableEventType ebAE) throws JAXRException {
        super(lcm, ebAE);
        EventTypeType ebEventType = ebAE.getEventType();
        if (ebEventType == EventTypeType.CREATED) {
            this.eventType = 0;
        } else if (ebEventType == EventTypeType.DELETED) {
            this.eventType = 1;
        } else if (ebEventType == EventTypeType.DEPRECATED) {
            this.eventType = 2;
        } else if (ebEventType == EventTypeType.UPDATED) {
            this.eventType = 3;
        } else if (ebEventType == EventTypeType.VERSIONED) {
            this.eventType = 4;
        }
        this.registryObjectRef = new RegistryObjectRef(lcm, ebAE.getRegistryObject());
        this.timestamp = new Timestamp(ebAE.getTimestamp().getTime());
        this.userRef = new RegistryObjectRef(lcm, ebAE.getUser());
    }

    public String toXML() throws JAXRException {
        AuditableEvent ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (ValidationException x) {
            throw new JAXRException((Throwable)x);
        }
        return sw.toString();
    }

    public RegistryObjectRef getUserRef() throws JAXRException {
        return this.userRef;
    }

    public User getUser() throws JAXRException {
        User user = null;
        if (this.userRef != null) {
            user = (User)this.userRef.getRegistryObject("User");
        }
        return user;
    }

    public Timestamp getTimestamp() throws JAXRException {
        return this.timestamp;
    }

    public int getEventType() throws JAXRException {
        return this.eventType;
    }

    public RegistryObject getRegistryObject() throws JAXRException {
        RegistryObject ro = null;
        if (this.registryObjectRef != null) {
            ro = this.registryObjectRef.getRegistryObject("RegistryObject");
        }
        return ro;
    }

    public AuditableEvent toBindingObject() throws JAXRException {
        AuditableEvent ebOrg = new AuditableEvent();
        this.setBindingObject(ebOrg);
        return ebOrg;
    }

    protected void setBindingObject(AuditableEventType ebOrg) throws JAXRException {
        super.setBindingObject(ebOrg);
    }
}

