/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.infomodel;

import com.sun.xml.registry.ebxml.LifeCycleManagerImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import com.sun.xml.registry.ebxml.infomodel.ServiceImpl;
import com.sun.xml.registry.ebxml.infomodel.SpecificationLinkImpl;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.rim.ObjectRef;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.ServiceBinding;
import org.oasis.ebxml.registry.bindings.rim.ServiceBindingType;
import org.oasis.ebxml.registry.bindings.rim.SpecificationLink;

public class ServiceBindingImpl
extends RegistryObjectImpl
implements javax.xml.registry.infomodel.ServiceBinding {
    private RegistryObjectRef serviceRef = null;
    private String accessURI = null;
    private RegistryObjectRef targetBindingRef = null;
    private HashSet specLinks = new HashSet();
    private boolean validateURI = true;

    public ServiceBindingImpl(LifeCycleManagerImpl lcm) throws JAXRException {
        super(lcm);
    }

    public ServiceBindingImpl(LifeCycleManagerImpl lcm, ServiceBindingType ebBinding) throws JAXRException {
        super(lcm, ebBinding);
        this.serviceRef = new RegistryObjectRef(lcm, ebBinding.getService());
        this.accessURI = ebBinding.getAccessURI();
        Object targetBindingObj = ebBinding.getTargetBinding();
        if (targetBindingObj != null) {
            this.targetBindingRef = new RegistryObjectRef(lcm, targetBindingObj);
        }
        SpecificationLink[] ebSpecLinks = ebBinding.getSpecificationLink();
        for (int i = 0; i < ebSpecLinks.length; ++i) {
            this.addSpecificationLink(new SpecificationLinkImpl(lcm, ebSpecLinks[i]));
        }
    }

    public String toXML() throws JAXRException {
        ServiceBinding ebObj = this.toBindingObject();
        StringWriter sw = new StringWriter();
        try {
            ((RegistryObjectType)ebObj).marshal(sw);
        }
        catch (MarshalException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (ValidationException x) {
            throw new JAXRException((Throwable)x);
        }
        return sw.toString();
    }

    public String getAccessURI() throws JAXRException {
        return this.accessURI;
    }

    public void setAccessURI(String par1) throws JAXRException {
        if (this.targetBindingRef != null) {
            throw new InvalidRequestException("Service binding is assigned a target binding.");
        }
        this.accessURI = par1;
        this.setModified(true);
    }

    public RegistryObjectRef getTargetBindingRef() throws JAXRException {
        return this.targetBindingRef;
    }

    public javax.xml.registry.infomodel.ServiceBinding getTargetBinding() throws JAXRException {
        javax.xml.registry.infomodel.ServiceBinding targetBinding = null;
        if (this.targetBindingRef != null) {
            targetBinding = (javax.xml.registry.infomodel.ServiceBinding)this.targetBindingRef.getRegistryObject("ServiceBinding");
        }
        return targetBinding;
    }

    void setTargetBindingInternal(javax.xml.registry.infomodel.ServiceBinding targetBinding) throws JAXRException {
        this.targetBindingRef = targetBinding == null ? null : new RegistryObjectRef(this.lcm, (RegistryObject)targetBinding);
        this.setModified(true);
    }

    public void setTargetBinding(javax.xml.registry.infomodel.ServiceBinding _binding) throws JAXRException {
        if (this.accessURI != null) {
            throw new InvalidRequestException("Service binding is assigned the access uri: " + this.accessURI);
        }
        if (this.targetBindingRef != null) {
            if (!_binding.getKey().getId().equals(this.targetBindingRef.getId())) {
                if (!(_binding instanceof ServiceBindingImpl)) {
                    throw new InvalidRequestException("Expected ServiceBindingImpl, got " + _binding);
                }
                this.setTargetBindingInternal(_binding);
            }
        } else {
            this.setTargetBindingInternal(_binding);
        }
    }

    public RegistryObjectRef getServiceRef() throws JAXRException {
        return this.serviceRef;
    }

    public Service getService() throws JAXRException {
        Service service = null;
        if (this.serviceRef != null) {
            service = (Service)this.serviceRef.getRegistryObject("Service");
        }
        return service;
    }

    void setServiceInternal(Service service) throws JAXRException {
        this.serviceRef = service == null ? null : new RegistryObjectRef(this.lcm, (RegistryObject)service);
        this.setModified(true);
    }

    void setService(Service service) throws JAXRException {
        if (this.serviceRef != null && service != null && !service.getKey().getId().equals(this.serviceRef.getId()) && !(service instanceof ServiceImpl)) {
            throw new InvalidRequestException("Expected ServiceImpl, got " + service);
        }
        this.setServiceInternal(service);
    }

    public void addSpecificationLink(javax.xml.registry.infomodel.SpecificationLink specLink) throws JAXRException {
        this.specLinks.add(specLink);
        ((SpecificationLinkImpl)specLink).setServiceBinding(this);
        this.setModified(true);
    }

    public void addSpecificationLinks(Collection _specLinks) throws JAXRException {
        Iterator iter = _specLinks.iterator();
        while (iter.hasNext()) {
            SpecificationLinkImpl obj = (SpecificationLinkImpl)iter.next();
            if (!(obj instanceof SpecificationLinkImpl)) {
                throw new InvalidRequestException("Expected SpecificationLinkImpl, got " + obj);
            }
            SpecificationLinkImpl specLink = obj;
            this.addSpecificationLink(specLink);
        }
    }

    public void removeSpecificationLink(javax.xml.registry.infomodel.SpecificationLink specLink) throws JAXRException {
        this.specLinks.remove(specLink);
        ((SpecificationLinkImpl)specLink).setServiceBinding(null);
        this.setModified(true);
    }

    public void removeSpecificationLinks(Collection _specLinks) throws JAXRException {
        Iterator iter = _specLinks.iterator();
        while (iter.hasNext()) {
            SpecificationLinkImpl obj = (SpecificationLinkImpl)iter.next();
            if (!(obj instanceof SpecificationLinkImpl)) {
                throw new InvalidRequestException("Expected SpecificationLinkImpl, got " + obj);
            }
            SpecificationLinkImpl specLink = obj;
            this.removeSpecificationLink(specLink);
        }
    }

    public Collection getSpecificationLinks() throws JAXRException {
        return (HashSet)this.specLinks.clone();
    }

    public boolean getValidateURI() throws JAXRException {
        return this.validateURI;
    }

    public void setValidateURI(boolean validateURI) throws JAXRException {
        this.validateURI = validateURI;
    }

    public ServiceBinding toBindingObject() throws JAXRException {
        ServiceBinding ebBinding = new ServiceBinding();
        this.setBindingObject(ebBinding);
        return ebBinding;
    }

    protected void setBindingObject(ServiceBindingType ebBinding) throws JAXRException {
        super.setBindingObject(ebBinding);
        if (this.accessURI != null) {
            ebBinding.setAccessURI(this.accessURI);
        }
        if (this.targetBindingRef != null) {
            ObjectRef ebTargetBindingRef = new ObjectRef();
            ebTargetBindingRef.setId(this.targetBindingRef.getId());
            ebBinding.setTargetBinding(ebTargetBindingRef);
        }
        if (this.serviceRef != null) {
            ObjectRef ebServiceRef = new ObjectRef();
            ebServiceRef.setId(this.serviceRef.getId());
            ebBinding.setService(ebServiceRef);
        }
        Iterator iter = this.getSpecificationLinks().iterator();
        while (iter.hasNext()) {
            SpecificationLinkImpl specLink = (SpecificationLinkImpl)iter.next();
            ebBinding.addSpecificationLink(specLink.toBindingObject());
        }
    }

    public void getComposedObjects(HashSet composedObjects) throws JAXRException {
        super.getComposedObjects(composedObjects);
        Collection specLinks = this.getSpecificationLinks();
        composedObjects.addAll(specLinks);
        Iterator iter = specLinks.iterator();
        while (iter.hasNext()) {
            SpecificationLinkImpl specLink = (SpecificationLinkImpl)iter.next();
            specLink.getComposedObjects(composedObjects);
        }
    }

    public HashSet getRegistryObjectRefs() {
        HashSet<RegistryObjectRef> refs = new HashSet<RegistryObjectRef>();
        if (this.targetBindingRef != null) {
            refs.add(this.targetBindingRef);
        }
        if (this.serviceRef != null) {
            refs.add(this.serviceRef);
        }
        return refs;
    }
}

