/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.jaas;

import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;

public class DialogAuthenticationCallbackHandler
implements CallbackHandler {
    private final Log log;
    private static final ResourceBundle authResBundle = ResourceBundle.getBundle("sun.security.util.AuthResources");
    private static final Dimension DIALOG_SIZE = new Dimension(400, 150);
    private static final Dimension PANEL_SIZE = new Dimension(375, 25);
    private static final int OK = 1;
    private static final int CANCEL = 0;
    private JDialog confirmationDialog;
    private Frame ownerFrame;
    private JPanel pnlAlias = new JPanel(null);
    private JLabel lblAlias = new JLabel("Keystore alias:");
    private JTextField txtAlias = new JTextField();
    private JPanel pnlStorepass = new JPanel(null);
    private JLabel lblStorepass = new JLabel("Keystore password:");
    private JPasswordField txtStorepass = new JPasswordField(8);
    private JPanel pnlKeypass = new JPanel(null);
    private JLabel lblKeypass = new JLabel("Private key password(optional):");
    private JPasswordField txtKeypass = new JPasswordField(8);
    private JPanel pnlButtons = new JPanel(null);
    private JButton btnOk = new JButton("OK");
    private JButton btnCancel = new JButton("Cancel");
    private boolean bOkPressed = false;

    public DialogAuthenticationCallbackHandler(Frame frame, Log l) {
        this.ownerFrame = frame;
        this.log = l;
        this.initComponents();
    }

    private void initComponents() {
        int curX = 5;
        int curY = 15;
        int lblWidth = 200;
        int txtWidth = 165;
        int buttonWidth = 75;
        int compHeight = 25;
        int padding = 5;
        this.confirmationDialog = new JDialog(this.ownerFrame, "Keystore login", true);
        this.confirmationDialog.getContentPane().setLayout(null);
        this.confirmationDialog.setLocation(20, 20);
        this.confirmationDialog.setSize(DIALOG_SIZE);
        this.pnlAlias.setSize(PANEL_SIZE);
        this.pnlAlias.setLocation(curX, curY);
        this.lblAlias.setBounds(0, 0, lblWidth, compHeight);
        this.txtAlias.setBounds(lblWidth + padding, 0, txtWidth, compHeight);
        this.pnlAlias.add(this.lblAlias);
        this.pnlAlias.add(this.txtAlias);
        this.confirmationDialog.getContentPane().add(this.pnlAlias);
        curY = curY + DialogAuthenticationCallbackHandler.PANEL_SIZE.height + padding * 2;
        this.txtKeypass.setEchoChar('*');
        this.pnlKeypass.setSize(PANEL_SIZE);
        this.pnlKeypass.setLocation(curX, curY);
        this.lblKeypass.setBounds(0, 0, lblWidth, compHeight);
        this.txtKeypass.setBounds(lblWidth + padding, 0, txtWidth, compHeight);
        this.pnlKeypass.add(this.lblKeypass);
        this.pnlKeypass.add(this.txtKeypass);
        this.confirmationDialog.getContentPane().add(this.pnlKeypass);
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogAuthenticationCallbackHandler.this.bOkPressed = true;
                DialogAuthenticationCallbackHandler.this.confirmationDialog.setVisible(false);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogAuthenticationCallbackHandler.this.bOkPressed = false;
                DialogAuthenticationCallbackHandler.this.confirmationDialog.setVisible(false);
            }
        });
        curY = curY + DialogAuthenticationCallbackHandler.PANEL_SIZE.height + padding * 2;
        this.pnlButtons.setSize(PANEL_SIZE);
        this.pnlButtons.setLocation(curX, curY);
        int buttonsBoundingWidth = buttonWidth * 2 + padding * 2;
        curX = (DialogAuthenticationCallbackHandler.PANEL_SIZE.width - buttonsBoundingWidth) / 2 > 0 ? (DialogAuthenticationCallbackHandler.PANEL_SIZE.width - buttonsBoundingWidth) / 2 : curX;
        this.btnOk.setBounds(curX, 0, buttonWidth, compHeight);
        curX = curX + buttonWidth + padding * 2;
        this.btnCancel.setBounds(curX, 0, buttonWidth, compHeight);
        curX = this.pnlButtons.getLocation().x;
        this.pnlButtons.add(this.btnOk);
        this.pnlButtons.add(this.btnCancel);
        this.confirmationDialog.getContentPane().add(this.pnlButtons);
        this.confirmationDialog.getRootPane().setDefaultButton(this.btnOk);
    }

    private int showDialog() {
        int returnValue = 0;
        this.confirmationDialog.setVisible(true);
        if (this.bOkPressed) {
            returnValue = 1;
            this.bOkPressed = false;
        } else {
            returnValue = 0;
        }
        return returnValue;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        int result = this.showDialog();
        for (int i = 0; i < callbacks.length; ++i) {
            String strPrompt;
            if (callbacks[i] instanceof TextOutputCallback) continue;
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                strPrompt = nc.getPrompt();
                String strName = "";
                if (strPrompt.equals(authResBundle.getString("Keystore alias: "))) {
                    strName = this.txtAlias.getText();
                }
                nc.setName(strName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                strPrompt = pc.getPrompt();
                char[] chrPass = new char[]{};
                if (strPrompt.equals(authResBundle.getString("Keystore password: "))) {
                    chrPass = ProviderProperties.getInstance().getProperty("jaxr-ebxml.security.storepass").toCharArray();
                    if (chrPass == null || chrPass.length == 0) {
                        this.log.error((Object)"Property jaxr-ebxml.security.storepass is undefined");
                    }
                } else if (strPrompt.equals(authResBundle.getString("Private key password (optional): "))) {
                    chrPass = this.txtKeypass.getPassword();
                }
                pc.setPassword(chrPass);
                continue;
            }
            if (callbacks[i] instanceof ConfirmationCallback) {
                ConfirmationCallback cc = (ConfirmationCallback)callbacks[i];
                if (result == 1) {
                    cc.setSelectedIndex(3);
                    continue;
                }
                cc.setSelectedIndex(2);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

