/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;

public class I18nUtil {
    private static final I18nUtil INSTANCE = new I18nUtil();
    private ResourceBundle bundle;

    private I18nUtil() {
        Locale locale = Locale.getDefault();
        String baseName = this.getClass().getPackage().getName() + ".resources.Messages";
        this.bundle = ResourceBundle.getBundle(baseName, locale);
    }

    public static I18nUtil getInstance() {
        return INSTANCE;
    }

    public String getMessage(String key) {
        String message = null;
        try {
            message = this.bundle.getString(key);
        }
        catch (MissingResourceException x) {
            x.printStackTrace();
            message = "[MissingResourceException] key=" + key;
        }
        return message;
    }

    public String getMessage(String key, Object[] params) {
        if (params == null) {
            return this.getMessage(key);
        }
        return MessageFormat.format(this.getMessage(key), params);
    }

    public JAXRException newJAXRException(String key) {
        return new JAXRException(this.getMessage(key));
    }

    public JAXRException newJAXRException(String key, Object[] params) {
        return new JAXRException(this.getMessage(key, params));
    }
}

