/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.ebxml.util;

import com.sun.xml.registry.ebxml.util.ProviderProperties;
import java.io.File;
import javax.xml.registry.JAXRException;

public class KeystoreUtil {
    public static File getKeystoreFile() throws JAXRException {
        String jaxrHomeFileName = ProviderProperties.getInstance().getProperty("jaxr-ebxml.home");
        if (jaxrHomeFileName == null || jaxrHomeFileName.length() == 0) {
            throw new JAXRException("Could not find property jaxr-ebxml.home");
        }
        File jaxrHomeFile = new File(jaxrHomeFileName);
        String keystoreFileName = ProviderProperties.getInstance().getProperty("jaxr-ebxml.security.keystore");
        if (keystoreFileName == null || keystoreFileName.length() == 0) {
            throw new JAXRException("Could not find property jaxr-ebxml.security.keystore");
        }
        return new File(jaxrHomeFile.getAbsolutePath(), keystoreFileName);
    }

    public static void canReadKeystoreFile(File keystoreFile) throws JAXRException {
        try {
            if (!keystoreFile.exists()) {
                throw new JAXRException("Keystore file \"" + keystoreFile.getAbsolutePath() + "\" does not exist");
            }
            if (!keystoreFile.canRead()) {
                throw new JAXRException("Could not read keystore file \"" + keystoreFile.getAbsolutePath() + "\"");
            }
        }
        catch (SecurityException e) {
            throw new JAXRException("Could not read keystore file \"" + keystoreFile.getAbsolutePath() + "\"", (Throwable)e);
        }
    }

    public static void createKeystoreDirectory(File keystoreFile) throws JAXRException {
        File keystoreDir = keystoreFile.getParentFile();
        try {
            keystoreDir.mkdirs();
        }
        catch (SecurityException e) {
            throw new JAXRException("Could not create directory \"" + keystoreDir.getAbsolutePath() + "\" for keystore", (Throwable)e);
        }
    }
}

