/*
 * Decompiled with CFR 0.152.
 */
package org.oasis.ebxml.registry.bindings.rim;

import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.oasis.ebxml.registry.bindings.rim.Classification;
import org.oasis.ebxml.registry.bindings.rim.Description;
import org.oasis.ebxml.registry.bindings.rim.ExternalIdentifier;
import org.oasis.ebxml.registry.bindings.rim.Name;
import org.oasis.ebxml.registry.bindings.rim.Slot;
import org.xml.sax.DocumentHandler;

public abstract class RegistryObjectType
implements Serializable {
    private Object _accessControlPolicy;
    private String _id;
    private String _objectType;
    private Name _name;
    private Description _description;
    private ArrayList _slotList = new ArrayList();
    private ArrayList _classificationList = new ArrayList();
    private ArrayList _externalIdentifierList = new ArrayList();

    public void addClassification(Classification vClassification) throws IndexOutOfBoundsException {
        this._classificationList.add(vClassification);
    }

    public void addClassification(int index, Classification vClassification) throws IndexOutOfBoundsException {
        this._classificationList.add(index, vClassification);
    }

    public void addExternalIdentifier(ExternalIdentifier vExternalIdentifier) throws IndexOutOfBoundsException {
        this._externalIdentifierList.add(vExternalIdentifier);
    }

    public void addExternalIdentifier(int index, ExternalIdentifier vExternalIdentifier) throws IndexOutOfBoundsException {
        this._externalIdentifierList.add(index, vExternalIdentifier);
    }

    public void addSlot(Slot vSlot) throws IndexOutOfBoundsException {
        this._slotList.add(vSlot);
    }

    public void addSlot(int index, Slot vSlot) throws IndexOutOfBoundsException {
        this._slotList.add(index, vSlot);
    }

    public void clearClassification() {
        this._classificationList.clear();
    }

    public void clearExternalIdentifier() {
        this._externalIdentifierList.clear();
    }

    public void clearSlot() {
        this._slotList.clear();
    }

    public Enumeration enumerateClassification() {
        return new IteratorEnumeration(this._classificationList.iterator());
    }

    public Enumeration enumerateExternalIdentifier() {
        return new IteratorEnumeration(this._externalIdentifierList.iterator());
    }

    public Enumeration enumerateSlot() {
        return new IteratorEnumeration(this._slotList.iterator());
    }

    public Object getAccessControlPolicy() {
        return this._accessControlPolicy;
    }

    public Classification getClassification(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._classificationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Classification)this._classificationList.get(index);
    }

    public Classification[] getClassification() {
        int size = this._classificationList.size();
        Classification[] mArray = new Classification[size];
        int index = 0;
        while (index < size) {
            mArray[index] = (Classification)this._classificationList.get(index);
            ++index;
        }
        return mArray;
    }

    public int getClassificationCount() {
        return this._classificationList.size();
    }

    public Description getDescription() {
        return this._description;
    }

    public ExternalIdentifier getExternalIdentifier(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._externalIdentifierList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ExternalIdentifier)this._externalIdentifierList.get(index);
    }

    public ExternalIdentifier[] getExternalIdentifier() {
        int size = this._externalIdentifierList.size();
        ExternalIdentifier[] mArray = new ExternalIdentifier[size];
        int index = 0;
        while (index < size) {
            mArray[index] = (ExternalIdentifier)this._externalIdentifierList.get(index);
            ++index;
        }
        return mArray;
    }

    public int getExternalIdentifierCount() {
        return this._externalIdentifierList.size();
    }

    public String getId() {
        return this._id;
    }

    public Name getName() {
        return this._name;
    }

    public String getObjectType() {
        return this._objectType;
    }

    public Slot getSlot(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._slotList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Slot)this._slotList.get(index);
    }

    public Slot[] getSlot() {
        int size = this._slotList.size();
        Slot[] mArray = new Slot[size];
        int index = 0;
        while (index < size) {
            mArray[index] = (Slot)this._slotList.get(index);
            ++index;
        }
        return mArray;
    }

    public int getSlotCount() {
        return this._slotList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public abstract void marshal(Writer var1) throws MarshalException, ValidationException;

    public abstract void marshal(DocumentHandler var1) throws MarshalException, ValidationException;

    public boolean removeClassification(Classification vClassification) {
        boolean removed = this._classificationList.remove(vClassification);
        return removed;
    }

    public boolean removeExternalIdentifier(ExternalIdentifier vExternalIdentifier) {
        boolean removed = this._externalIdentifierList.remove(vExternalIdentifier);
        return removed;
    }

    public boolean removeSlot(Slot vSlot) {
        boolean removed = this._slotList.remove(vSlot);
        return removed;
    }

    public void setAccessControlPolicy(Object accessControlPolicy) {
        this._accessControlPolicy = accessControlPolicy;
    }

    public void setClassification(int index, Classification vClassification) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._classificationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._classificationList.set(index, vClassification);
    }

    public void setClassification(Classification[] classificationArray) {
        this._classificationList.clear();
        int i = 0;
        while (i < classificationArray.length) {
            this._classificationList.add(classificationArray[i]);
            ++i;
        }
    }

    public void setDescription(Description description) {
        this._description = description;
    }

    public void setExternalIdentifier(int index, ExternalIdentifier vExternalIdentifier) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._externalIdentifierList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._externalIdentifierList.set(index, vExternalIdentifier);
    }

    public void setExternalIdentifier(ExternalIdentifier[] externalIdentifierArray) {
        this._externalIdentifierList.clear();
        int i = 0;
        while (i < externalIdentifierArray.length) {
            this._externalIdentifierList.add(externalIdentifierArray[i]);
            ++i;
        }
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setName(Name name) {
        this._name = name;
    }

    public void setObjectType(String objectType) {
        this._objectType = objectType;
    }

    public void setSlot(int index, Slot vSlot) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._slotList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._slotList.set(index, vSlot);
    }

    public void setSlot(Slot[] slotArray) {
        this._slotList.clear();
        int i = 0;
        while (i < slotArray.length) {
            this._slotList.add(slotArray[i]);
            ++i;
        }
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

