/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.utils.LinkedHashMap;
import org.jboss.webservice.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeanXMLMetaData {
    private Map elementDescMap = new LinkedHashMap();
    private List elementOrderList = new ArrayList();

    private BeanXMLMetaData() {
    }

    public static BeanXMLMetaData parse(Element metaData) {
        BeanXMLMetaData beanMetaData = new BeanXMLMetaData();
        if (metaData != null) {
            ArrayList<QName> qnames = new ArrayList<QName>();
            NodeList nlistElementDesc = metaData.getElementsByTagName("elementDesc");
            for (int i = 0; i < nlistElementDesc.getLength(); ++i) {
                QName xmlType;
                Element elDesc = (Element)nlistElementDesc.item(i);
                String fieldName = DOMUtils.getAttributeValue(elDesc, "fieldName");
                QName xmlName = DOMUtils.getAttributeValueAsQName(elDesc, "xmlName");
                if (xmlName == null) {
                    xmlName = new QName("", fieldName);
                }
                if ((xmlType = DOMUtils.getAttributeValueAsQName(elDesc, "xmlType")) != null) {
                    if (qnames.contains(xmlType)) {
                        throw new IllegalStateException("Duplicate type mapping definition: " + xmlType);
                    }
                    qnames.add(xmlType);
                }
                boolean asAttribute = DOMUtils.getAttributeValueAsBoolean(elDesc, "asAttr");
                boolean asContent = DOMUtils.getAttributeValueAsBoolean(elDesc, "asContent");
                QName itemXmlType = DOMUtils.getAttributeValueAsQName(elDesc, "itemXmlType");
                ElementMetaData elMetaData = new ElementMetaData(fieldName, xmlName, xmlType, itemXmlType, asAttribute, asContent);
                beanMetaData.elementDescMap.put(fieldName, elMetaData);
            }
            Element orderEl = DOMUtils.getFirstChildElement(metaData, "elementOrder");
            if (orderEl != null) {
                NodeList nlistElementOrder = orderEl.getElementsByTagName("element");
                for (int i = 0; i < nlistElementOrder.getLength(); ++i) {
                    Element el = (Element)nlistElementOrder.item(i);
                    String fieldName = el.getAttribute("name");
                    beanMetaData.elementOrderList.add(fieldName);
                }
            }
        }
        return beanMetaData;
    }

    public Iterator getElementMetaData() {
        return this.elementDescMap.values().iterator();
    }

    public Iterator getElementOrder() {
        return this.elementOrderList.iterator();
    }

    public void serializeAsXML(PrintWriter out) {
        String pad = "  ";
        out.println(pad + "<typeDesc>");
        Iterator itElDesc = this.elementDescMap.values().iterator();
        while (itElDesc.hasNext()) {
            ElementMetaData elMetaData = (ElementMetaData)itElDesc.next();
            out.print(pad + pad + "<elementDesc fieldName='" + elMetaData.getFieldName() + "' xmlName='" + elMetaData.getXmlName() + "'");
            if (elMetaData.getXmlType() != null) {
                out.print(" xmlType='" + elMetaData.getXmlType().getPrefix() + ":" + elMetaData.getXmlType().getLocalPart() + "'");
            }
            if (elMetaData.isAsAttribute()) {
                out.print(" asAttr='true'");
            }
            if (elMetaData.isAsContent()) {
                out.print(" asContent='true'");
            }
            out.println("/>");
        }
        if (this.elementOrderList.size() > 0) {
            out.print(pad + pad + "<elementOrder>");
            Iterator itElOrder = this.elementOrderList.iterator();
            while (itElOrder.hasNext()) {
                String fieldName = (String)itElOrder.next();
                out.println(pad + pad + pad + "<element name='" + fieldName + "'/>");
            }
            out.print(pad + pad + "</elementOrder>");
        }
        out.println(pad + "</typeDesc>");
    }

    public static class ElementMetaData {
        private String fieldName;
        private QName xmlName;
        private QName xmlType;
        private QName itemXmlType;
        private boolean asAttribute;
        private boolean asContent;

        public ElementMetaData(String fieldName, QName xmlName, QName xmlType, QName itemXmlType, boolean asAttribute, boolean asContent) {
            this.fieldName = fieldName;
            this.xmlName = xmlName;
            this.xmlType = xmlType;
            this.itemXmlType = itemXmlType;
            this.asAttribute = asAttribute;
            this.asContent = asContent;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public QName getXmlName() {
            return this.xmlName;
        }

        public QName getXmlType() {
            return this.xmlType;
        }

        public QName getItemXmlType() {
            return this.itemXmlType;
        }

        public boolean isAsAttribute() {
            return this.asAttribute;
        }

        public boolean isAsContent() {
            return this.asContent;
        }
    }
}

