/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.handler.HandlerInfo;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;
import org.apache.axis.providers.java.RPCInvocation;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.transport.http.HTTPConstants;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.handler.ServerHandlerChain;
import org.jboss.webservice.metadata.HandlerMetaData;
import org.jboss.webservice.metadata.InitParamMetaData;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.server.JBossRPCInvocation;
import org.jboss.webservice.server.ServiceException;
import org.jboss.webservice.util.WSDLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class InvokerProvider
extends RPCProvider {
    private Logger log = Logger.getLogger((Class)InvokerProvider.class);
    protected MBeanServer server;
    protected PortComponentInfo portComponentInfo;
    protected ServerHandlerChain handlerChain;

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
        this.log.debug((Object)("initServiceDesc: service=" + service.getName()));
        try {
            this.server = MBeanServerLocator.locateJBoss();
            String wsID = (String)service.getOption("webserviceID");
            this.portComponentInfo = (PortComponentInfo)this.server.invoke(AxisServiceMBean.OBJECT_NAME, "getPortComponentInfo", new Object[]{wsID}, new String[]{String.class.getName()});
            if (this.portComponentInfo == null) {
                throw new ServiceException("Cannot obtain port component info for: " + wsID);
            }
            this.initHandlerChain();
        }
        catch (Exception e) {
            throw new ServiceException("Cannot initialize webservice", e);
        }
        super.initServiceDesc(service, msgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandlerChain() throws Exception {
        ClassLoader cl = this.getContextClassLoader();
        HashSet<String> handlerRoles = new HashSet<String>();
        ArrayList<HandlerInfo> handlerInfos = new ArrayList<HandlerInfo>();
        HandlerMetaData[] handlers = this.portComponentInfo.getPortComponentMetaData().getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            HandlerMetaData hMetaData = handlers[i];
            handlerRoles.addAll(Arrays.asList(hMetaData.getSoapRoles()));
            Class<?> hClass = cl.loadClass(hMetaData.getHandlerClass());
            HashMap<String, String> hConfig = new HashMap<String, String>();
            InitParamMetaData[] params = hMetaData.getInitParams();
            for (int j = 0; j < params.length; ++j) {
                InitParamMetaData param = params[j];
                hConfig.put(param.getParamName(), param.getParamValue());
            }
            QName[] hHeaders = hMetaData.getSoapHeaders();
            HandlerInfo info = new HandlerInfo(hClass, hConfig, hHeaders);
            String serviceName = this.portComponentInfo.getPortComponentMetaData().getPortComponentName();
            this.log.debug((Object)("Adding server side handler to service '" + serviceName + "': " + info));
            handlerInfos.add(info);
        }
        this.handlerChain = new ServerHandlerChain(handlerInfos, handlerRoles);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            if (this.handlerChain.getState() == 1) {
                this.handlerChain.init(null);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected abstract ClassLoader getContextClassLoader();

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        HttpServletRequest req = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            throw new IllegalStateException("Cannot obtain HttpServletRequest from msg context");
        }
        String requestURI = req.getRequestURI();
        try {
            String resourcePath = (String)msgContext.getProperty("axis.wsdlgen.resource");
            Document wsdlDocument = this.getDocumentForPath(resourcePath);
            this.modifyImportLocations(requestURI, resourcePath, wsdlDocument.getDocumentElement());
            msgContext.setProperty("WSDL", (Object)wsdlDocument);
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot process WSDL document", (Throwable)e);
        }
    }

    public RPCInvocation createRPCInvocation(MessageContext msgContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object obj) {
        JBossRPCInvocation invocation = new JBossRPCInvocation(this, msgContext, reqEnv, resEnv, obj);
        return invocation;
    }

    public PortComponentInfo getPortComponentInfo() {
        return this.portComponentInfo;
    }

    public Document getDocumentForPath(String resourcePath) {
        WebserviceDescriptionMetaData wsdMetaData = this.portComponentInfo.getPortComponentMetaData().getWebserviceDescription();
        String wsdlFile = wsdMetaData.getWsdlFile();
        if (resourcePath == null) {
            return WSDLUtilities.getWSDLDocument(wsdMetaData.getWsdlDefinition());
        }
        URLClassLoader cl = this.portComponentInfo.getDeploymentInfo().localCl;
        String rootDir = wsdlFile.substring(0, wsdlFile.lastIndexOf("/"));
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        while (resourcePath.startsWith("./")) {
            resourcePath = resourcePath.substring(2);
        }
        while (resourcePath.startsWith("../")) {
            resourcePath = resourcePath.substring(3);
            if (rootDir.indexOf("/wsdl/") <= 0) continue;
            rootDir = rootDir.substring(0, rootDir.lastIndexOf("/"));
        }
        resourcePath = rootDir + "/" + resourcePath;
        URL resURL = cl.findResource(resourcePath);
        if (resURL == null) {
            throw new IllegalStateException("Cannot obtain wsdl resource from: " + resourcePath);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(resURL.openStream());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse wsdl resource: " + resURL);
        }
    }

    private void modifyImportLocations(String requestURI, String resourcePath, Element element) {
        NodeList nlist = element.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node childNode = nlist.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            String nodeName = childElement.getLocalName();
            if ("import".equals(nodeName) || "include".equals(nodeName)) {
                boolean isAbsolute;
                Attr locationAttr = childElement.getAttributeNode("schemaLocation");
                if (locationAttr == null) {
                    locationAttr = childElement.getAttributeNode("location");
                }
                if (locationAttr == null) continue;
                String orgLocation = locationAttr.getNodeValue();
                boolean bl = isAbsolute = orgLocation.startsWith("http://") || orgLocation.startsWith("https://");
                if (isAbsolute || orgLocation.startsWith(requestURI)) continue;
                String newResourcePath = orgLocation;
                if (resourcePath != null && resourcePath.indexOf("/") > 0 && !orgLocation.startsWith("../")) {
                    newResourcePath = resourcePath.substring(0, resourcePath.indexOf("/") + 1) + orgLocation;
                }
                String newLocation = requestURI + "?wsdl&resource=" + newResourcePath;
                locationAttr.setNodeValue(newLocation);
                this.log.debug((Object)("Mapping import from '" + orgLocation + "' to '" + newLocation + "'"));
                continue;
            }
            this.modifyImportLocations(requestURI, resourcePath, childElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getServiceClass(String clsName, SOAPService service, MessageContext msgContext) throws AxisFault {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            String seiName = this.portComponentInfo.getPortComponentMetaData().getServiceEndpointInterface();
            Class clazz = super.getServiceClass(seiName, service, msgContext);
            return clazz;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected String getServiceClassName(Handler handler) {
        return this.portComponentInfo.getPortComponentMetaData().getServiceEndpointInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object invokeMethod(MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getContextClassLoader());
            Object object = this.invokeServiceEndpoint(msgContext, method, obj, argValues);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected abstract Object invokeServiceEndpoint(MessageContext var1, Method var2, Object var3, Object[] var4) throws Exception;
}

