/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.server.AxisServer;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.util.NestedRuntimeException;
import org.jboss.webservice.AxisServiceMBean;

public class DelegatingMessageDrivenBean
implements MessageDrivenBean,
MessageListener {
    protected Logger log = Logger.getLogger((Class)DelegatingMessageDrivenBean.class);
    private MessageDrivenContext mdbCtx;
    private QueueConnectionFactory queueFactory;

    protected AxisServer getAxisServer() {
        AxisServer axisServer;
        try {
            MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
            axisServer = (AxisServer)mbeanServer.getAttribute(AxisServiceMBean.OBJECT_NAME, "AxisServer");
            this.log.debug((Object)("got AxisServer: " + axisServer));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot obtain axis server", e);
        }
        return axisServer;
    }

    public void onMessage(javax.jms.Message message) {
        try {
            if (message instanceof BytesMessage) {
                this.processSOAPMessage((BytesMessage)message);
            } else {
                this.log.warn((Object)("Ingnore message, because it is not a javax.jms.BytesMessage: " + message));
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    protected void processSOAPMessage(BytesMessage message) throws Exception {
        ByteArrayInputStream in = null;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
        try {
            int read = message.readBytes(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = message.readBytes(buffer);
            }
            in = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot get bytes from message", (Throwable)e);
            return;
        }
        this.log.debug((Object)("onMessage: " + new String(out.toByteArray())));
        AxisServer axisServer = this.getAxisServer();
        Message axisRequest = new Message((Object)in);
        MessageContext msgContext = new MessageContext((AxisEngine)axisServer);
        msgContext.setRequestMessage(axisRequest);
        HashMap serviceOperations = this.getServiceOperationsMap(axisServer);
        String targetService = null;
        Iterator it = axisRequest.getSOAPEnvelope().getBody().getChildElements();
        while (it.hasNext()) {
            SOAPElement soapElement = (SOAPElement)it.next();
            String namespace = soapElement.getElementName().getURI();
            String localName = soapElement.getElementName().getLocalName();
            QName qname = new QName(namespace, localName);
            this.log.debug((Object)("maybe operation: " + qname));
            targetService = (String)serviceOperations.get(qname);
        }
        if (targetService != null) {
            this.log.debug((Object)("setTargetService: " + targetService));
            msgContext.setTargetService(targetService);
        }
        Message axisResponse = null;
        try {
            axisServer.invoke(msgContext);
            axisResponse = msgContext.getResponseMessage();
        }
        catch (AxisFault af) {
            axisResponse = new Message((Object)af);
            axisResponse.setMessageContext(msgContext);
        }
        catch (Exception e) {
            axisResponse = new Message((Object)new AxisFault(e.toString()));
            axisResponse.setMessageContext(msgContext);
        }
        Queue replyQueue = this.getReplyQueue(message);
        if (replyQueue != null) {
            this.sendResponse(replyQueue, axisResponse);
        }
    }

    private HashMap getServiceOperationsMap(AxisServer server) {
        HashMap<QName, String> serviceOperations = new HashMap<QName, String>();
        try {
            EngineConfiguration config = server.getConfig();
            Iterator it = config.getDeployedServices();
            while (it.hasNext()) {
                ServiceDesc service = (ServiceDesc)it.next();
                this.log.debug((Object)("service: [name=" + service.getName() + ",ns=" + service.getDefaultNamespace() + "]"));
                Iterator opit = service.getOperations().iterator();
                while (opit.hasNext()) {
                    OperationDesc operation = (OperationDesc)opit.next();
                    QName qname = operation.getElementQName();
                    this.log.debug((Object)("  operation: [qname=" + qname + "]"));
                    serviceOperations.put(qname, service.getName());
                }
            }
        }
        catch (ConfigurationException e) {
            this.log.error((Object)"Cannot map service operations", (Throwable)e);
        }
        return serviceOperations;
    }

    protected Queue getReplyQueue(BytesMessage message) throws JMSException {
        Queue replyQueue = (Queue)message.getJMSReplyTo();
        return replyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Queue replyQueue, Message axisResponse) throws SOAPException, IOException, JMSException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        axisResponse.writeTo((OutputStream)out);
        QueueConnection qc = this.queueFactory.createQueueConnection();
        QueueSession session = qc.createQueueSession(false, 1);
        QueueSender sender = null;
        try {
            sender = session.createSender(replyQueue);
            BytesMessage responseMessage = session.createBytesMessage();
            responseMessage.writeBytes(out.toByteArray());
            sender.send((javax.jms.Message)responseMessage);
            this.log.info((Object)"Sent response");
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                sender.close();
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            try {
                session.close();
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            try {
                qc.close();
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            sender.close();
        }
        catch (JMSException ignored) {
            // empty catch block
        }
        try {
            session.close();
        }
        catch (JMSException ignored) {
            // empty catch block
        }
        try {
            qc.close();
        }
        catch (JMSException ignored) {}
    }

    public void ejbCreate() {
        try {
            InitialContext ctx = new InitialContext();
            this.queueFactory = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
        this.mdbCtx = ctx;
    }
}

