/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.login;

import at.tugraz.genome.crypt.DesEncrypter;
import at.tugraz.genome.crypt.SecurityFactory;
import at.tugraz.genome.usermanagement.UserManagementConstants;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Login {
    private static Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$login$Login == null ? (class$at$tugraz$genome$usermanagement$login$Login = Login.class$("at.tugraz.genome.usermanagement.login.Login")) : class$at$tugraz$genome$usermanagement$login$Login));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$login$Login;

    public static void doLoginActions(HttpServletRequest request, UserVO userVO, String username, String applicationname, String authenticationID) {
        request.getSession().setAttribute(UserManagementConstants.USER, (Object)userVO);
        request.getSession().setAttribute(UserManagementConstants.LOGGED_USER, (Object)username);
        request.getSession().setAttribute(UserManagementConstants.APPLICATIONNAME, (Object)applicationname);
    }

    public static boolean checkSuccessfullLogin(HttpServletRequest request, HttpServletResponse response, String appName) {
        return Login.checkSuccessfullLogin(request, response, appName, null);
    }

    public static boolean checkSuccessfullLogin(HttpServletRequest request, HttpServletResponse response, String appName, String appKey) {
        String applicationKey = null;
        HttpSession session = request.getSession();
        if (session != null) {
            if (appName == null) {
                logger_.error((Object)"Application Name not defined");
                return false;
            }
            applicationKey = appKey != null ? appKey : ConfigLoader.getInstance(appName).getProperties().getProperty("applicationPassword");
            if (session.getAttribute(UserManagementConstants.USER) != null) {
                if (session.getAttribute("Authentication_Id") == null) {
                    logger_.info((Object)"No AthenticationID for User in session ");
                    boolean result = Login.checkCookie(request, response, appName, applicationKey);
                    return result;
                }
                try {
                    String authId = (String)session.getAttribute("Authentication_Id");
                    String username = null;
                    UserVO userVO = (UserVO)session.getAttribute(UserManagementConstants.USER);
                    username = userVO.getName();
                    boolean returnvalue = Login.isCookiePresent(request, response, userVO, appName, applicationKey, authId);
                    if (!returnvalue) {
                        Login.logout(request, appName);
                        session.removeAttribute(UserManagementConstants.USER);
                    }
                    if (returnvalue) {
                        String actualAuthId = (String)session.getAttribute("Authentication_Id");
                        returnvalue = ServerConnectionManager.getInstance().getConnection(appName).checkLogin(username, actualAuthId, appName);
                    }
                    return returnvalue;
                }
                catch (UserSecurityException ex) {
                    ex.printStackTrace();
                }
            } else {
                return Login.checkCookie(request, response, appName, applicationKey);
            }
        }
        logger_.error((Object)"No session found");
        return false;
    }

    private static boolean isCookiePresent(HttpServletRequest request, HttpServletResponse response, UserVO userVO, String appliactionName, String applicationKey, String sessionAuthId) {
        if (userVO.isCookieUsed()) {
            Cookie[] cookies = request.getCookies();
            HttpSession session = request.getSession();
            int nrOfCookies = 0;
            if (cookies != null) {
                nrOfCookies = cookies.length;
            }
            int i = 0;
            while (i < nrOfCookies) {
                if (cookies[i].getName().equalsIgnoreCase(UserManagementConstants.COOKIENAME)) {
                    Cookie cookie = cookies[i];
                    int point = cookies[i].getValue().indexOf(":");
                    int secondPoint = cookies[i].getValue().substring(point + 1).indexOf(":") + point + 1;
                    String cookieVersion = cookie.getValue().substring(cookie.getValue().length() - 5);
                    String expectedTimeOutServer = cookie.getValue().substring(secondPoint + 1, cookie.getValue().length() - 5);
                    if (SecurityFactory.getInstance().getActualVersion().equalsIgnoreCase("00000") || !SecurityFactory.getInstance().getActualVersion().equalsIgnoreCase(cookieVersion)) {
                        SecurityFactory.getInstance().getNewestCookieEncrypter(appliactionName);
                        return Login.checkCookie(request, response, appliactionName, applicationKey);
                    }
                    if (new Long(expectedTimeOutServer) < System.currentTimeMillis() / 1000L) {
                        return Login.refreshAuthentication(request, response, cookie, userVO.getName(), appliactionName, sessionAuthId);
                    }
                    cookie.setMaxAge(ConfigLoader.getInstance(appliactionName).getCookieMaxAge());
                    cookie.setPath("/");
                    if (ConfigLoader.getInstance(appliactionName).getCookieDomain() != null) {
                        cookie.setDomain(ConfigLoader.getInstance(appliactionName).getCookieDomain());
                    }
                    logger_.info((Object)("Cookie Updated: Name:" + cookie.getName() + " Age: " + cookie.getMaxAge() + " Path: " + cookie.getPath() + " Domain: " + cookie.getDomain()));
                    response.addCookie(cookie);
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private static boolean checkCookie(HttpServletRequest request, HttpServletResponse response, String applicationName, String applicationKey) {
        logger_.debug((Object)("checkCookie " + applicationName + " " + applicationKey));
        ServerConnection serverConnection = null;
        Cookie[] cookies = request.getCookies();
        HttpSession session = request.getSession();
        int nrOfCookies = 0;
        if (cookies != null) {
            nrOfCookies = cookies.length;
        }
        int i = 0;
        while (i < nrOfCookies) {
            if (cookies[i].getName().equalsIgnoreCase(UserManagementConstants.COOKIENAME)) {
                if (cookies[i].getValue() != null && (cookies[i].getValue().length() < 1 || cookies[i].getValue().indexOf(":") == -1)) {
                    logger_.debug((Object)"Cookie had invalid data");
                    return false;
                }
                int point = cookies[i].getValue().indexOf(":");
                int secondPoint = cookies[i].getValue().substring(point + 1).indexOf(":") + point + 1;
                String userNameInTheCookie = cookies[i].getValue().substring(0, point);
                String authTokenInTheCookie = cookies[i].getValue().substring(point + 1, secondPoint);
                DesEncrypter des = SecurityFactory.getInstance().getCookieEncrypter();
                if (des == null) {
                    des = SecurityFactory.getInstance().getNewestCookieEncrypter(applicationName);
                }
                String cookieusername = des.decrypt(userNameInTheCookie);
                String authToken = des.decrypt(authTokenInTheCookie);
                logger_.debug((Object)("Username: " + cookieusername));
                logger_.debug((Object)("authToken: " + authToken));
                String expectedTimeOutServer = cookies[i].getValue().substring(secondPoint + 1, cookies[i].getValue().length() - 5);
                try {
                    DesEncrypter oldDes;
                    serverConnection = ServerConnectionManager.getInstance().getConnection(applicationName);
                    boolean returnvalue = false;
                    try {
                        returnvalue = ServerConnectionManager.getInstance().getConnection(applicationName).checkLogin(cookieusername, authToken, applicationName);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (!returnvalue && (oldDes = SecurityFactory.getInstance().getOldCookieEncrypter()) != null) {
                        cookieusername = oldDes.decrypt(userNameInTheCookie);
                        authToken = oldDes.decrypt(authTokenInTheCookie);
                        logger_.debug((Object)("Username: " + cookieusername));
                        logger_.debug((Object)("authToken: " + authToken));
                        logger_.debug((Object)("applicationKey: " + applicationKey));
                        returnvalue = ServerConnectionManager.getInstance().getConnection(applicationName).checkLogin(cookieusername, authToken, applicationName);
                        if (returnvalue) {
                            String username = des.encrypt(cookieusername);
                            String authID = des.encrypt(authToken);
                            String cookievalue = username + ":" + authID + ":" + expectedTimeOutServer + SecurityFactory.getInstance().getActualVersion();
                            Cookie cookie = new Cookie(UserManagementConstants.COOKIENAME, cookievalue);
                            cookie.setComment("This cookie is used for the usermanagementsystem of genome.tugraz.at");
                            cookie.setMaxAge(ConfigLoader.getInstance(applicationName).getCookieMaxAge());
                            cookie.setPath("/");
                            if (ConfigLoader.getInstance(applicationName).getCookieDomain() != null) {
                                cookie.setDomain(ConfigLoader.getInstance(applicationName).getCookieDomain());
                            }
                            response.addCookie(cookie);
                            logger_.info((Object)("Cookie Updated: Name:" + cookie.getName() + " Age: " + cookie.getMaxAge() + " Path: " + cookie.getPath() + " Domain: " + cookie.getDomain()));
                        }
                    }
                    logger_.debug((Object)("Username: " + cookieusername));
                    logger_.debug((Object)("authToken: " + authToken));
                    logger_.debug((Object)("applicationKey: " + applicationKey));
                    if (returnvalue) {
                        ExtendedUserVO vo = serverConnection.getUserVOExtended(cookieusername, authToken, applicationName, applicationKey);
                        vo.setCookieInUse(true);
                        session.setAttribute(UserManagementConstants.USER, (Object)vo);
                        session.setAttribute(UserManagementConstants.LOGGED_USER, (Object)cookieusername);
                        session.setAttribute(UserManagementConstants.APPLICATIONNAME, (Object)applicationName);
                        session.setAttribute("Authentication_Id", (Object)authToken);
                        request.getSession().setAttribute("loadUserBar", (Object)"true");
                        return true;
                    }
                    return false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            ++i;
        }
        logger_.error((Object)"No Cookie found");
        return false;
    }

    private static boolean refreshAuthentication(HttpServletRequest request, HttpServletResponse response, Cookie cookie, String username, String applicationName, String sessionAuthId) {
        ServerConnection serverConnection = null;
        try {
            serverConnection = ServerConnectionManager.getInstance().getConnection(applicationName);
            int point = cookie.getValue().indexOf(":");
            int secondPoint = cookie.getValue().substring(point + 1).indexOf(":") + point + 1;
            String authTokenInTheCookie = cookie.getValue().substring(point + 1, secondPoint);
            DesEncrypter des = SecurityFactory.getInstance().getCookieEncrypter();
            if (des == null) {
                des = SecurityFactory.getInstance().getNewestCookieEncrypter(applicationName);
            }
            String newAuthToken = serverConnection.refreshAuthenticationId(username, sessionAuthId, applicationName);
            username = des.encrypt(username);
            String authID = des.encrypt(newAuthToken);
            String cookievalue = username + ":" + authID + ":" + (System.currentTimeMillis() / 1000L + (long)ConfigLoader.getInstance(applicationName).getCookieMaxAge()) + SecurityFactory.getInstance().getActualVersion();
            cookie = new Cookie(UserManagementConstants.COOKIENAME, cookievalue);
            cookie.setComment("This cookie is used for the usermanagementsystem of genome.tugraz.at");
            cookie.setMaxAge(ConfigLoader.getInstance(applicationName).getCookieMaxAge());
            cookie.setPath("/");
            if (ConfigLoader.getInstance(applicationName).getCookieDomain() != null) {
                cookie.setDomain(ConfigLoader.getInstance(applicationName).getCookieDomain());
            }
            request.getSession().setAttribute("Authentication_Id", (Object)newAuthToken);
            logger_.debug((Object)"new AuthenticationId set");
            response.addCookie(cookie);
            logger_.info((Object)("Cookie Updated: Name:" + cookie.getName() + " Age: " + cookie.getMaxAge() + " Path: " + cookie.getPath() + " Domain: " + cookie.getDomain()));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static void logout(HttpServletRequest request, String applicationname) {
        try {
            UserVO userVO = (UserVO)request.getSession().getAttribute(UserManagementConstants.USER);
            ServerConnectionManager.getInstance().getConnection(applicationname).logoutUser(userVO.getName(), applicationname);
        }
        catch (Exception ex) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

