/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection.cache;

import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.cache.PermissionCacheVO;
import at.tugraz.genome.usermanagement.serverconnection.exception.CacheException;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import java.rmi.RemoteException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionCache {
    private static Vector permissions = new Vector();
    private static long CACHETIME = 10000L;
    private static boolean useCache = true;
    private static Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$serverconnection$cache$PermissionCache == null ? (class$at$tugraz$genome$usermanagement$serverconnection$cache$PermissionCache = PermissionCache.class$("at.tugraz.genome.usermanagement.serverconnection.cache.PermissionCache")) : class$at$tugraz$genome$usermanagement$serverconnection$cache$PermissionCache));
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$cache$PermissionCache;

    public static boolean hasPermission(String username, String authenticationID, String applicationname, String resource, String accessLevel, String applicationPassword) throws UserSecurityException, CacheException {
        String cachingTime;
        String cacheYN = ConfigLoader.getInstance(applicationname).getProperties().getProperty("PermissionCache");
        if (cacheYN != null && cacheYN.equalsIgnoreCase("OFF")) {
            logger_.info((Object)"Cache turned off in Properties File");
            useCache = false;
        }
        if ((cachingTime = ConfigLoader.getInstance(applicationname).getProperties().getProperty("PermissionCachingTime")) != null) {
            try {
                Long time = new Long(cachingTime);
                CACHETIME = time;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean result = false;
        if (useCache) {
            PermissionCacheVO vo;
            long currTime = System.currentTimeMillis();
            int i = 0;
            while (i < permissions.size()) {
                vo = (PermissionCacheVO)permissions.get(i);
                if (currTime > vo.getInitTime() + CACHETIME) {
                    permissions.remove(i);
                } else if (vo.equals(username, applicationname, resource, accessLevel)) {
                    return vo.isHasPermission();
                }
                ++i;
            }
            vo = new PermissionCacheVO(username, applicationname, resource, accessLevel);
            result = PermissionCache.getUserAccessLevel(username, authenticationID, applicationname, resource, accessLevel, applicationPassword);
            vo.setHasPermission(result);
            permissions.add(vo);
        } else {
            result = PermissionCache.getUserAccessLevel(username, authenticationID, applicationname, resource, accessLevel, applicationPassword);
        }
        return result;
    }

    private static boolean getUserAccessLevel(String username, String authenticationID, String applicationname, String resource, String accessLevel, String applicationPassword) throws CacheException, UserSecurityException {
        ServerConnection serverConnection = ServerConnectionManager.getInstance().getConnection(applicationname);
        if (serverConnection == null) {
            throw new CacheException("[PermissionCache] No ServerConnection found");
        }
        try {
            logger_.info((Object)("[PermissionCache] loading form server " + username + " " + resource + " " + accessLevel));
            return serverConnection.hasUserAccessLevel(username, authenticationID, applicationname, resource, accessLevel, applicationPassword);
        }
        catch (RemoteException ex) {
            throw new CacheException("[PermissionCache] No ServerConnection found: RMI");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

