/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection.ejb;

import at.tugraz.genome.crypt.SecurityFactory;
import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.server.acl.VO.AclVO;
import at.tugraz.genome.usermanagement.server.application.VO.ApplicationVO;
import at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ejb.Connection;
import at.tugraz.genome.usermanagement.serverconnection.ejb.util.AuthenticationHandler;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import com.opensymphony.module.user.DuplicateEntityException;
import com.opensymphony.module.user.ImmutableException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.Management.acl.AclManager;
import server.Management.application.ApplicationManager;
import server.Management.group.GroupManagement;
import server.Management.institut.InstitutManager;
import server.Management.resource.ResourceManager;
import server.Management.rights.RightsManagement;
import server.Management.user.UserManagement;
import server.Management.util.FilterDoubleEntries;
import server.Management.util.MessageFromServer;

public class ServerConnectionEJB
implements ServerConnection {
    private Context serverContext_ = null;
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$serverconnection$ejb$ServerConnectionEJB == null ? (class$at$tugraz$genome$usermanagement$serverconnection$ejb$ServerConnectionEJB = ServerConnectionEJB.class$("at.tugraz.genome.usermanagement.serverconnection.ejb.ServerConnectionEJB")) : class$at$tugraz$genome$usermanagement$serverconnection$ejb$ServerConnectionEJB));
    private RightsManagement rightsManagement_;
    private GroupManagement groupManagement_;
    private UserManagement userManagement_;
    private AclManager aclManager_;
    private InstitutManager institutManager_;
    private ResourceManager resourceManager_;
    private ApplicationManager applicationManager_;
    private Connection serverConnection_;
    private AuthenticationHandler authenticationHandler_;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$ejb$ServerConnectionEJB;

    public ServerConnectionEJB(ConfigLoader config) throws Exception {
        this.serverConnection_ = Connection.getInstance(config);
        this.rightsManagement_ = this.serverConnection_.getRightsManagement();
        this.userManagement_ = this.serverConnection_.getUserManagement();
        this.applicationManager_ = this.serverConnection_.getApplicationManager();
        this.groupManagement_ = this.serverConnection_.getGroupManagement();
        this.aclManager_ = this.serverConnection_.getAclManager();
        this.institutManager_ = this.serverConnection_.getInstitutManager();
        this.authenticationHandler_ = AuthenticationHandler.getInstance(config);
        this.resourceManager_ = this.serverConnection_.getResourceManager();
    }

    public ExtendedUserVO getUserVOExtended(String username, String authenticationID, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || applicationname == null || authenticationID == null || applicationPassword == null) {
            throw new UserSecurityException("wrong amount of data");
        }
        if (!this.checkRegisteredAndisLogged(username, applicationPassword, authenticationID, applicationname)) {
            throw new UserSecurityException("user not logged in");
        }
        try {
            ExtendedUserVO vo = this.userManagement_.getUserVOExtended(username);
            vo.setNameOfCurrentAplication(applicationname);
            return vo;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public UserVO getUserVO(String username, String authenticationID, String applicationname, String applicationPassword) {
        if (username == null || username.length() == 0) {
            return null;
        }
        try {
            this.checkRegisteredAndisLogged(username, applicationPassword, authenticationID, applicationname);
        }
        catch (UserSecurityException ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
        try {
            return this.userManagement_.getUserVO(username);
        }
        catch (Exception ex) {
            logger_.error((Object)ex.toString());
            return null;
        }
    }

    public boolean hasUserAccessLevel(String username, String authenticationID, String applicationname, String resource, String accessLevel, String applicationPassword) throws RemoteException {
        if (username == null || applicationname == null || resource == null || accessLevel == null) {
            return false;
        }
        try {
            this.checkRegisteredAndisLogged(username, applicationPassword, authenticationID, applicationname);
        }
        catch (UserSecurityException ex) {
            logger_.error((Object)ex.toString());
            return false;
        }
        return this.rightsManagement_.hasUserAccessLevel(username, applicationname, resource, accessLevel);
    }

    public AuthenticationToken authenticateUser(String realm, String username, String password, String applicationpassword, String ipAddress) throws RemoteException {
        if (username == null || realm == null || password == null || applicationpassword == null || ipAddress == null) {
            return new AuthenticationToken("data null");
        }
        String encryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(realm).encrypt(password);
        AuthenticationToken resultOfAthentication = this.rightsManagement_.authenticateUser(realm, username, encryptedPassword, ipAddress, new Long(ConfigLoader.getInstance(realm).getCookieMaxAge()));
        if (!resultOfAthentication.isError()) {
            resultOfAthentication.setAuthenticationID(AuthenticationHandler.getID(username));
        }
        return resultOfAthentication;
    }

    public MessageBean changePassword(String username, String adminusername, String authenticationID, String newpassword, String oldpassword, String changePeriode, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || newpassword == null || authenticationID == null || applicationname == null || applicationPassword == null || oldpassword == null) {
            return new MessageBean("username or new password null");
        }
        if (newpassword != null && newpassword.length() < 8) {
            return new MessageBean("password must execced 8 characters, cannot change password");
        }
        if (!newpassword.matches("(.)*([0-9])+(.)*")) {
            return new MessageBean("password must contain at least one number (0-9), cannot change password");
        }
        if (!newpassword.matches("(.)*(\\p{Punct})+(.)*")) {
            return new MessageBean("password must contain at least one special character (!@#$%^&*()), cannot change password");
        }
        if (adminusername == null) {
            adminusername = "";
        }
        if (oldpassword == null) {
            oldpassword = "";
        }
        String newPasswordEncrypted = SecurityFactory.getInstance().getCookieEncrypter().encrypt(newpassword);
        String oldPasswordEncrypted = SecurityFactory.getInstance().getCookieEncrypter().encrypt(oldpassword);
        if (adminusername.length() > 0 && this.checkRegisteredAndisAdmin(adminusername, applicationPassword, authenticationID, applicationname)) {
            logger_.debug((Object)("admin will change password for User " + username));
            try {
                if (!this.userManagement_.getApplicationsForUser(username).contains(new ApplicationVO(applicationname))) {
                    return new MessageBean("administrator " + adminusername + " is not responsible for user " + username);
                }
            }
            catch (RemoteException ex2) {
                return new MessageBean("internal error: " + ex2);
            }
            try {
                MessageBean msg = new MessageBean();
                msg = this.userManagement_.setPassword(username, newPasswordEncrypted, changePeriode, true, true);
                if (!msg.isError()) {
                    logger_.info((Object)("administrator set new password for user: " + username));
                } else {
                    logger_.info((Object)("could not set new password for user as adminstrator : " + msg.getMessage()));
                }
                return msg;
            }
            catch (RemoteException ex1) {
                ex1.printStackTrace();
                logger_.error((Object)("Error could not change password ad admin: " + ex1));
                return new MessageBean("could not change password : " + ex1);
            }
        }
        if (!this.checkRegisteredAndisLogged(username, applicationPassword, authenticationID, applicationname)) {
            MessageBean msg = new MessageBean("user not loged in or application not registered");
            return msg;
        }
        logger_.debug((Object)("change password for User " + username));
        try {
            if (!this.userManagement_.checkPassword(username, oldPasswordEncrypted)) {
                return new MessageBean("passwords do not match");
            }
            return this.userManagement_.setPassword(username, newPasswordEncrypted, changePeriode, true, true);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            MessageBean msg = new MessageBean("internal error, could not change password");
            return msg;
        }
    }

    public Vector getExtendedUsersOfApplication(String applicationname, String applicationPassword, boolean withGroupMembers, boolean includeGlobalyDisabledUsers) throws UserSecurityException {
        if (applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!this.checkApplicationIsRegistered(applicationname, applicationPassword)) {
            return null;
        }
        Vector result = new Vector();
        try {
            result = withGroupMembers ? this.applicationManager_.getAllUsersOfApplicationWithGroups(applicationname, includeGlobalyDisabledUsers) : this.applicationManager_.getAllUsersEnabledInApplication(applicationname, includeGlobalyDisabledUsers);
            if (result == null) {
                result = new Vector();
            }
            return result;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public Vector getExtendedUsersOfApplication(String applicationname, String applicationPassword, boolean withGroupMembers) throws UserSecurityException {
        return this.getExtendedUsersOfApplication(applicationname, applicationPassword, withGroupMembers, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageBean addUser(ExtendedUserVO userVO, String applicationname, String templateUser, String password, String changePeriode, String authenticationID, String adminUsername, String applicationPassword, boolean addToApplication) throws UserSecurityException {
        try {
            if (this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
                // empty if block
            }
        }
        catch (UserSecurityException ex) {
            return new MessageBean(ex.toString());
        }
        MessageFromServer message = this.existsUser(userVO.getName(), userVO.getFullname(), userVO.getEmail(), authenticationID, adminUsername, applicationname, applicationPassword);
        if (message.isError()) {
            throw new UserSecurityException(message.getMessage());
        }
        if (password != null && password.length() < 8) {
            return new MessageBean("password must execced 8 characters, cannot create new user");
        }
        if (!password.matches("(.)*([0-9])+(.)*")) {
            return new MessageBean("password must contain at least one number (0-9), cannot create new user");
        }
        if (!password.matches("(.)*(\\p{Punct})+(.)*")) {
            return new MessageBean("password must contain at least special character (!@#$%^&*()), cannot create new user");
        }
        String passwd = SecurityFactory.getInstance().getCookieEncrypter().encrypt(password);
        String templateUserName = templateUser;
        String realmToEnable = applicationname;
        logger_.debug((Object)("will make user: " + userVO.getName() + ", passwd: " + passwd));
        logger_.debug((Object)("start: " + userVO.getAccountStartDate() + ", stop: " + userVO.getAccountExpireDate()));
        Long newId = new Long(0L);
        if (templateUserName == null) return null;
        logger_.debug((Object)"try to make user");
        try {
            MessageBean msg = null;
            msg = this.userManagement_.createUser(userVO.getName(), userVO.getFullname(), passwd, true, changePeriode);
            if (msg.isError()) throw new UserSecurityException(msg.getMessage());
            ExtendedUserVO createdUser = this.userManagement_.getUserVOExtended(userVO.getName());
            if (createdUser == null) return null;
            logger_.debug((Object)"created user");
            if (!this.copyToAdd(templateUserName, createdUser.getName(), realmToEnable)) {
                newId = new Long(0L);
            } else {
                logger_.debug((Object)"copied user successfully");
                newId = createdUser.getID();
            }
            newId = createdUser.getID();
            this.userManagement_.setUserVO(userVO, true);
            if (addToApplication) {
                this.applicationManager_.addUserToApplication(applicationname, userVO.getName());
                return new MessageBean();
            }
            logger_.debug((Object)"created user, but dit not add the user to the application =>add user to group");
            return new MessageBean();
        }
        catch (DuplicateEntityException ex3) {
            throw new UserSecurityException("user already exists");
        }
        catch (ImmutableException ex3) {
            throw new UserSecurityException("cannot create user (interanl error)");
        }
        catch (RemoteException ex3) {
            throw new UserSecurityException("cannot create user (interanl error)");
        }
    }

    public void editUser(ExtendedUserVO VO, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (VO == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return;
        }
        try {
            this.userManagement_.setUserVO(VO, true);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return;
        }
    }

    public void editUser(ExtendedUserVO VO, String authenticationID, String applicationname, String applicationPassword) throws UserSecurityException {
        if (VO == null || authenticationID == null || applicationname == null || applicationPassword == null) {
            return;
        }
        if (!this.checkRegisteredAndisLogged(VO.getName(), applicationPassword, authenticationID, applicationname)) {
            return;
        }
        try {
            this.userManagement_.setUserVO(VO, false);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
            return;
        }
    }

    public ExtendedUserVO getUserByIDExtended(Long id, String adminUsername, String authenticationID, String applicationname, String applicationPassword) throws UserSecurityException {
        if (id == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!this.checkRegisteredAndisAdmin(adminUsername, applicationPassword, authenticationID, applicationname)) {
            return null;
        }
        try {
            ExtendedUserVO vo = this.userManagement_.getUserByIDExtended(id);
            vo.setNameOfCurrentAplication(applicationname);
            return vo;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public ExtendedUserVO getUserByIDExtended(Long id, String applicationname, String applicationPassword) throws UserSecurityException {
        if (id == null || applicationname == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(applicationname, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            ExtendedUserVO vo = this.userManagement_.getUserByIDExtended(id);
            vo.setNameOfCurrentAplication(applicationname);
            return vo;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public UserVO getUserByID(Long id, String applicationname, String applicationPassword) throws UserSecurityException {
        if (id == null || applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!AuthenticationHandler.isApplicationRegistered(applicationname, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            return null;
        }
        try {
            return this.userManagement_.getUserByID(id);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getUsersOfApplication(String applicationname, String applicationPassword, boolean withGroupMembers, boolean includeGlobalyDisabledUsers) throws UserSecurityException {
        if (applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!this.checkApplicationIsRegistered(applicationname, applicationPassword)) {
            return null;
        }
        Vector userList = new Vector();
        try {
            userList = !withGroupMembers ? this.applicationManager_.getAllUsersEnabledInApplication(applicationname, includeGlobalyDisabledUsers) : this.applicationManager_.getAllUsersOfApplicationWithGroups(applicationname, includeGlobalyDisabledUsers);
            int i = 0;
            while (i < userList.size()) {
                userList.set(i, (UserVO)userList.get(i));
                ++i;
            }
            return userList;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getUsersOfApplication(String applicationname, String applicationPassword, boolean withGroupMembers) throws UserSecurityException {
        return this.getUsersOfApplication(applicationname, applicationPassword, withGroupMembers, true);
    }

    public MessageFromServer existsUser(String username, String fullname, String email, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || fullname == null || email == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return null;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return null;
        }
        try {
            return this.userManagement_.existsUser(username, fullname, email);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public boolean enableUserInApplication(String username, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return false;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return false;
        }
        try {
            return this.applicationManager_.enableUserInApplication(applicationname, username);
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean disableUserInApplication(String username, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (username == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return false;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return false;
        }
        try {
            return this.applicationManager_.disableUserInApplication(applicationname, username);
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean copyAcl(String sourceUser, String destinationUser, String authenticationID, String adminUsername, String applicationname, String applicationPassword) throws UserSecurityException {
        if (sourceUser == null || destinationUser == null || authenticationID == null || adminUsername == null || applicationname == null || applicationPassword == null) {
            return false;
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, applicationname, adminUsername)) {
            return false;
        }
        return this.copy(sourceUser, destinationUser, applicationname);
    }

    private boolean copy(String templateUser, String newUser, String realm) {
        if (templateUser == null || newUser == null) {
            return false;
        }
        if (templateUser.length() == 0 || newUser.length() == 0) {
            return false;
        }
        try {
            Serializable vo;
            Vector AclTmp = new Vector();
            Vector AppTmp = new Vector();
            Vector GroupTmp = new Vector();
            AclTmp = this.aclManager_.getAllAclOfRealmOfUser(realm, templateUser);
            AppTmp = this.userManagement_.getApplicationsForUser(templateUser);
            GroupTmp = this.groupManagement_.getAllGroupsOfUser(templateUser);
            if (AclTmp == null) {
                AclTmp = new Vector();
            }
            if (AppTmp == null) {
                AppTmp = new Vector();
            }
            if (GroupTmp == null) {
                GroupTmp = new Vector();
            }
            logger_.debug((Object)"got Template User data");
            logger_.debug((Object)("AclTmp : " + AclTmp.size()));
            logger_.debug((Object)("AppTmp : " + AppTmp.size()));
            logger_.debug((Object)("GroupTmp : " + GroupTmp.size()));
            Iterator iter = ((AbstractList)AclTmp).iterator();
            while (iter.hasNext()) {
                vo = (AclVO)iter.next();
                logger_.debug((Object)("acl=> key : " + ((AclVO)vo).getResourceKey() + "userID: " + ((AclVO)vo).getUserId() + " groupId: " + ((AclVO)vo).getGroupId() + " access: " + ((AclVO)vo).getAccessLevel() + " realm:  " + ((AclVO)vo).getRealm()));
                if (!this.aclManager_.createAcl(((AclVO)vo).getRealm(), ((AclVO)vo).getResourceKey(), newUser, null, ((AclVO)vo).getAccessLevel()).isError()) continue;
                logger_.error((Object)("ERROR: could not create Acl " + ((AclVO)vo).getRealm() + ", " + ((AclVO)vo).getResourceKey()));
            }
            logger_.debug((Object)"copied ACLs");
            iter = ((AbstractList)AppTmp).iterator();
            while (iter.hasNext()) {
                vo = (ApplicationVO)iter.next();
                logger_.debug((Object)("app: " + ((ApplicationVO)vo).getApplicationname()));
                this.applicationManager_.enableUserInApplication(((ApplicationVO)vo).getApplicationname(), newUser);
            }
            logger_.debug((Object)"copied Apps");
            iter = ((AbstractList)GroupTmp).iterator();
            while (iter.hasNext()) {
                vo = (SmallGroupVO)iter.next();
                logger_.debug((Object)("group : " + ((SmallGroupVO)vo).getName()));
                this.groupManagement_.addUserToGroup(newUser, ((SmallGroupVO)vo).getName());
            }
            logger_.debug((Object)"copied groups");
            return true;
        }
        catch (Exception ex) {
            logger_.error((Object)("could not copy from template user " + ex.toString()));
            return false;
        }
    }

    private boolean checkAll(String username, String applicationPassword, String authenticationID, String applicationname, String adminUsername) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandler.isApplicationRegistered(applicationname, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandler.isUserAdminOfApplication(adminUsername, applicationname)) {
            checkAll = false;
            logger_.error((Object)"user is not adminstrator of this application");
            throw new UserSecurityException("user is not adminstrator of this application");
        }
        if (!AuthenticationHandler.isLogged(username, authenticationID)) {
            checkAll = false;
            logger_.error((Object)("User is not logged in, ID unknown (ValueObject created at Client?) " + username));
            throw new UserSecurityException("User is not logged in, ID unknown (ValueObject created at Client?)");
        }
        return checkAll;
    }

    private boolean checkRegisteredAndisLogged(String username, String applicationPassword, String authenticationID, String applicationname) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandler.isApplicationRegistered(applicationname, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandler.isLogged(username, authenticationID)) {
            checkAll = false;
            logger_.error((Object)"User is not logged in, ID unknown (ValueObject created at Client?)");
            throw new UserSecurityException("User is not logged in, ID unknown (ValueObject created at Client?)");
        }
        return checkAll;
    }

    private boolean checkRegisteredAndisAdmin(String username, String applicationPassword, String authenticationID, String applicationname) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandler.isApplicationRegistered(applicationname, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)("Application is not registered under this name and password: " + applicationname));
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandler.isUserAdminOfApplication(username, applicationname)) {
            checkAll = false;
            logger_.error((Object)"user is not adminstrator of this application");
            throw new UserSecurityException("user is not adminstrator of this application");
        }
        return checkAll;
    }

    private boolean checkApplicationIsRegistered(String application, String applicationPassword) throws UserSecurityException {
        boolean checkAll = true;
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            checkAll = false;
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        return checkAll;
    }

    private boolean copyToAdd(String templateUser, String newUser, String realmToEnable) {
        if (templateUser == null || newUser == null) {
            logger_.error((Object)"templateUser and newUser null");
            return false;
        }
        if (templateUser.length() == 0 || newUser.length() == 0) {
            logger_.error((Object)"no zero length strings");
            return false;
        }
        try {
            Serializable vo;
            Vector appList = this.applicationManager_.getAllApplications();
            Vector AclTmp = new Vector();
            Vector AppTmp = new Vector();
            Vector GroupTmp = new Vector();
            Iterator app = ((AbstractList)appList).iterator();
            while (app.hasNext()) {
                String realm = ((ApplicationVO)app.next()).getApplicationname();
                AclTmp.addAll(this.aclManager_.getAllAclOfRealmOfUser(realm, templateUser));
            }
            AppTmp = this.userManagement_.getApplicationsForUser(templateUser);
            GroupTmp = this.groupManagement_.getAllGroupsOfUser(templateUser);
            if (AclTmp == null) {
                AclTmp = new Vector();
            }
            if (AppTmp == null) {
                AppTmp = new Vector();
            }
            if (GroupTmp == null) {
                GroupTmp = new Vector();
            }
            logger_.debug((Object)"got Template User data");
            logger_.debug((Object)("AclTmp : " + AclTmp.size()));
            logger_.debug((Object)("AppTmp : " + AppTmp.size()));
            logger_.debug((Object)("GroupTmp : " + GroupTmp.size()));
            Iterator iter = ((AbstractList)AclTmp).iterator();
            while (iter.hasNext()) {
                vo = (AclVO)iter.next();
                logger_.debug((Object)("acl=> key : " + ((AclVO)vo).getResourceKey() + "userID: " + ((AclVO)vo).getUserId() + " groupId: " + ((AclVO)vo).getGroupId() + " access: " + ((AclVO)vo).getAccessLevel() + " realm:  " + ((AclVO)vo).getRealm()));
                if (!this.aclManager_.createAcl(((AclVO)vo).getRealm(), ((AclVO)vo).getResourceKey(), newUser, null, ((AclVO)vo).getAccessLevel()).isError()) continue;
                logger_.debug((Object)"ERROR");
            }
            logger_.debug((Object)"copied ACLs successfully");
            this.applicationManager_.enableUserInApplication(realmToEnable, newUser);
            logger_.debug((Object)("enabled user in : " + realmToEnable));
            logger_.debug((Object)"copied Apps");
            iter = ((AbstractList)GroupTmp).iterator();
            while (iter.hasNext()) {
                vo = (SmallGroupVO)iter.next();
                logger_.debug((Object)("group : " + ((SmallGroupVO)vo).getName()));
                this.groupManagement_.addUserToGroup(newUser, ((SmallGroupVO)vo).getName());
            }
            logger_.debug((Object)"copied groups");
            return true;
        }
        catch (Exception ex) {
            logger_.debug((Object)("could not copy from template user " + ex.toString()));
            return false;
        }
    }

    public Long getUserIDFromName(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            return null;
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.userManagement_.getUserIDFromName(username);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getGroupsEnabledInApplication(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            Vector list = this.applicationManager_.getAllGroupsEnabledInApplication(application);
            Iterator iter = ((AbstractList)list).iterator();
            while (iter.hasNext()) {
                SmallGroupVO vo = (SmallGroupVO)iter.next();
                vo.setNameOfCurrentAplication(application);
            }
            return list;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public boolean addUserToGroup(String username, String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.groupManagement_.addUserToGroup(username, groupname);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public boolean removeUserFromGroup(String username, String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || groupname == null || application == null || applicationPassword == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        try {
            return this.groupManagement_.deleteUserFromGroup(username, groupname);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public Vector getUserVORegEx(String regExpression, String application, String applicationPassword) throws UserSecurityException {
        if (regExpression == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return new Vector(this.userManagement_.findUserVOByRegEx(regExpression, application));
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public Vector getUserVOExtendedRegEx(String regExpression, String application, String applicationPassword) throws UserSecurityException {
        if (regExpression == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return new Vector(this.userManagement_.findUserVOExtendedByRegEx(regExpression, application));
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public boolean createGroup(String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null || authenticationID == null || applicationPassword == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        try {
            if (this.groupManagement_.createGroup(groupname)) {
                return this.applicationManager_.enableGroupInApplication(groupname, application);
            }
            return false;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
        catch (DuplicateEntityException ex) {
            throw new UserSecurityException("group already exists");
        }
    }

    public boolean deleteGroup(String groupname, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || adminUsername == null || authenticationID == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        try {
            int size = this.groupManagement_.getAllUsersOfGroup(groupname).size();
            if (size > 0) {
                throw new UserSecurityException("not allowed to delete groups, which contain users (" + size + ")");
            }
            return this.groupManagement_.deleteGroup(groupname);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public Vector getAclsOfUser(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.aclManager_.getAllAclOfRealmOfUser(application, username);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getAclsOfGroup(String groupname, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.aclManager_.getAllAclOfRealmOfGroup(application, groupname);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public boolean setAclsOfUser(String username, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null || id == null || accessLevel == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        try {
            if (accessLevel.length() == 0) {
                String key = this.aclManager_.getAclByID(id).getResourceKey();
                return this.aclManager_.deleteAclOfUser(application, key, username);
            }
            return this.aclManager_.updateAcl(id, accessLevel);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean setAclsOfGroup(String groupname, Long id, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || application == null || applicationPassword == null || id == null || accessLevel == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.aclManager_.updateAcl(id, accessLevel);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public Vector getAllResourcesOfApplication(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.resourceManager_.getResourcesOfApplication(application);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public AclVO getAclOfResourceByUser(String username, String resourceKey, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || resourceKey == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.aclManager_.getAclByRealmAndResourceKeyAndUser(application, resourceKey, username);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public AclVO getAclOfResourceByGroup(String groupname, String resourceKey, String application, String applicationPassword) throws UserSecurityException {
        if (groupname == null || resourceKey == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.aclManager_.getAclByRealmAndResourceKeyAndGroup(application, resourceKey, groupname);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public boolean createAcl(String username, String groupname, String resourceKey, String accessLevel, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null || adminUsername == null || authenticationID == null || resourceKey == null || accessLevel == null || groupname == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        if (username == null) {
            username = "";
        }
        if (groupname == null) {
            groupname = "";
        }
        try {
            MessageBean message = this.aclManager_.createAcl(application, resourceKey, username, groupname, accessLevel);
            if (message.isError()) {
                throw new UserSecurityException(message.getMessage());
            }
            return true;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public boolean deleteAcl(Long id, String authenticationID, String adminUsername, String application, String applicationPassword) throws UserSecurityException {
        if (id == null || application == null || applicationPassword == null || authenticationID == null || adminUsername == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!this.checkAll(adminUsername, applicationPassword, authenticationID, application, adminUsername)) {
            return false;
        }
        try {
            return this.aclManager_.deleteAclById(id);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public Vector getAccessrightsByUser(Long id, String application, String applicationPassword) throws UserSecurityException {
        if (id == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            UserVO user = this.userManagement_.getUserByID(id);
            return this.rightsManagement_.getRightOfResource(application, user.getName());
        }
        catch (RemoteException ex) {
            logger_.error((Object)("getAccessrightsByUser " + ex));
            return null;
        }
    }

    public Vector getAccessrightsByUser(String username, String application, String applicationPassword) throws UserSecurityException {
        if (username == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.rightsManagement_.getRightOfResource(application, username);
        }
        catch (RemoteException ex) {
            logger_.error((Object)("getAccessrightsByUser " + ex));
            return null;
        }
    }

    public boolean checkLogin(String username, String id, String application) throws UserSecurityException {
        if (username == null || application == null || id == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, ConfigLoader.getInstance(application).getProperties().getProperty("applicationPassword"))) {
            return false;
        }
        if (!AuthenticationHandler.isLogged(username, id)) {
            return false;
        }
        return AuthenticationHandler.isUserallowedInApplication(username, application);
    }

    public Vector getAllInstitutes(String application, String applicationPassword) throws UserSecurityException {
        if (application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        try {
            return this.institutManager_.getAll();
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getAllUsersFromInstitut(Long institutId, String adminusername, String application, String applicationPassword) throws UserSecurityException {
        if (institutId == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandler.isUserAdminOfApplication(adminusername, application)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        Vector result = null;
        try {
            result = this.institutManager_.getAllUsersOfInstitut(institutId);
            return result;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public Vector getAllUsersWithProperty(String propertyKey, String adminusername, String application, String applicationPassword) throws UserSecurityException {
        if (propertyKey == null || application == null || applicationPassword == null) {
            throw new UserSecurityException("unsufficient data");
        }
        if (!AuthenticationHandler.isApplicationRegistered(application, applicationPassword)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        if (!AuthenticationHandler.isUserAdminOfApplication(adminusername, application)) {
            logger_.error((Object)"Application is not registered under this name and password");
            throw new UserSecurityException("Application is not registered under this name and password");
        }
        AbstractList userList = null;
        Vector<ExtendedUserVO> result = new Vector<ExtendedUserVO>();
        try {
            userList = this.applicationManager_.getAllUsersEnabledInApplication(application, true);
            userList = FilterDoubleEntries.filterUsers((Vector)userList);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        Iterator iter = userList.iterator();
        while (iter.hasNext()) {
            ExtendedUserVO vo = (ExtendedUserVO)iter.next();
            if (!vo.getProperties().getKeys().contains(propertyKey)) continue;
            result.add(vo);
        }
        return result;
    }

    public boolean logoutUser(String username, String applicationname) throws UserSecurityException {
        try {
            return this.rightsManagement_.logoutUser(username, applicationname);
        }
        catch (Exception ex) {
            throw new UserSecurityException(ex);
        }
    }

    public String refreshAuthenticationId(String username, String authenticationId, String realm) throws UserSecurityException {
        try {
            String authId = this.rightsManagement_.refreshAuthenticationID(username, authenticationId, new Long(ConfigLoader.getInstance(realm).getCookieMaxAge()));
            if (authId.equalsIgnoreCase("false")) {
                throw new UserSecurityException("The refresh of the authentication ID did not work");
            }
            return authId;
        }
        catch (Exception ex) {
            throw new UserSecurityException(ex);
        }
    }

    public String getCookieKey(String applicationname) throws UserSecurityException {
        String cookieKey = "";
        cookieKey = AuthenticationHandler.getCookieKey(applicationname);
        return cookieKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

