/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.serverconnection.ejb.util;

import at.tugraz.genome.crypt.SecurityFactory;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import server.security.AuthenticationManager;
import server.security.AuthenticationManagerHome;

public class AuthenticationHandler {
    private static final Log logger_ = LogFactory.getLog((Class)(class$at$tugraz$genome$usermanagement$serverconnection$ejb$util$AuthenticationHandler == null ? (class$at$tugraz$genome$usermanagement$serverconnection$ejb$util$AuthenticationHandler = AuthenticationHandler.class$("at.tugraz.genome.usermanagement.serverconnection.ejb.util.AuthenticationHandler")) : class$at$tugraz$genome$usermanagement$serverconnection$ejb$util$AuthenticationHandler));
    private static AuthenticationHandler handler_ = null;
    private static AuthenticationManager authenticationManager_;
    static /* synthetic */ Class class$at$tugraz$genome$usermanagement$serverconnection$ejb$util$AuthenticationHandler;
    static /* synthetic */ Class class$server$security$AuthenticationManagerHome;

    private AuthenticationHandler(ConfigLoader config) {
        try {
            authenticationManager_ = this.getAuthenticationManager(config);
        }
        catch (Exception ex) {
            logger_.error((Object)ex);
        }
    }

    public static AuthenticationHandler getInstance(ConfigLoader config) {
        if (handler_ == null) {
            handler_ = new AuthenticationHandler(config);
        }
        return handler_;
    }

    public static String getID(String username) {
        try {
            return authenticationManager_.getAuthenticationID(username);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return null;
        }
    }

    public static boolean isLogged(String username, String id) {
        try {
            return authenticationManager_.isLogged(username, id);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public static boolean isUserallowedInApplication(String username, String application) {
        try {
            return authenticationManager_.isUserallowedInApplication(username, application);
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public static boolean isApplicationRegistered(String application, String password) {
        String enryptedPassword = SecurityFactory.getInstance().getCookieEncrypter().encrypt(password);
        String version = SecurityFactory.getInstance().getActualVersion();
        try {
            int status = authenticationManager_.isApplicationRegistered(application, enryptedPassword, version);
            if (status == 2) {
                enryptedPassword = SecurityFactory.getInstance().getNewestCookieEncrypter(application).encrypt(password);
                version = SecurityFactory.getInstance().getActualVersion();
                status = authenticationManager_.isApplicationRegistered(application, enryptedPassword, version);
            }
            if (status == 0) {
                return false;
            }
            return status == 1;
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public static boolean isUserAdminOfApplication(String username, String applicationname) {
        try {
            return authenticationManager_.isUserAdminOfApplication(username, applicationname);
        }
        catch (RemoteException ex) {
            logger_.error((Object)ex);
            return false;
        }
    }

    public static String getCookieKey(String applicationname) {
        try {
            return authenticationManager_.getCookieKey(applicationname);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private AuthenticationManager getAuthenticationManager(ConfigLoader config) throws Exception {
        InitialContext ctx = new InitialContext(config.getProperties());
        Object ref = ctx.lookup("AuthenticationManager");
        AuthenticationManagerHome securityManagerHome = (AuthenticationManagerHome)PortableRemoteObject.narrow((Object)ref, (Class)(class$server$security$AuthenticationManagerHome == null ? (class$server$security$AuthenticationManagerHome = AuthenticationHandler.class$("server.security.AuthenticationManagerHome")) : class$server$security$AuthenticationManagerHome));
        return securityManagerHome.create();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

