/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.usermanagement.testclasses;

import at.tugraz.genome.usermanagement.server.MessageBean;
import at.tugraz.genome.usermanagement.server.acl.VO.AclVO;
import at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken;
import at.tugraz.genome.usermanagement.server.group.VO.SmallGroupVO;
import at.tugraz.genome.usermanagement.server.institut.VO.InstitutMembersVO;
import at.tugraz.genome.usermanagement.server.institut.VO.InstitutVO;
import at.tugraz.genome.usermanagement.server.resource.VO.ResourceVO;
import at.tugraz.genome.usermanagement.server.right.VO.RightOfResourceVO;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.server.user.VO.UserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import at.tugraz.genome.usermanagement.serverconnection.util.ConfigLoader;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import server.Management.util.MessageFromServer;
import server.security.AuthenticationManager;
import server.security.AuthenticationManagerHome;

public class TestAdmin {
    private ServerConnection serverConnection = null;
    private String applicationname = "maspectras";
    private String username = "hartler";
    private String pswdUser = "2";
    private String adminUsername = "hartler";
    static /* synthetic */ Class class$server$security$AuthenticationManagerHome;

    public TestAdmin() {
        try {
            this.serverConnection = ServerConnectionManager.getInstance().getConnection(this.applicationname);
        }
        catch (Exception ex) {}
    }

    private void startTest() {
        try {
            this.triggerLoginRefresh();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addUserToGroup() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.addUserToGroup("test5", "maspectrasUser", auth.getAuthenticationID(), this.username, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private AuthenticationToken testAddUser() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        ExtendedUserVO userVO = new ExtendedUserVO("test5");
        userVO.setStartDate(new Long(System.currentTimeMillis() - 2000000000L));
        userVO.setExpireDate(new Long(System.currentTimeMillis() + 2000000000L));
        userVO.setFullname("Test Test5");
        userVO.setEmail("test5.hartler@tugraz.at");
        userVO.setChangePeriode("monthly");
        this.triggerCookieRefresh();
        MessageBean msg = this.serverConnection.addUser(userVO, this.applicationname, null, "1234567890!", "weekly", auth.getAuthenticationID(), this.adminUsername, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"), true);
        System.out.println(msg.getMessage());
        return auth;
    }

    private void testChangePassword() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.changePassword("test5", null, auth.getAuthenticationID(), "12345678!", "123456789!", "weekly", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testCheckLogin() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        System.out.println(this.serverConnection.checkLogin(this.username, auth.getAuthenticationID(), this.applicationname));
    }

    private void testCopyAcls() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.copyAcl(this.username, "test5", auth.getAuthenticationID(), this.username, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testCreateAcl() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.createAcl(null, "maspectrasPowerUser", "entityB", "R|U|N|D|", auth.getAuthenticationID(), this.username, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testCreateGroup() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.createGroup("test", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private AuthenticationToken testAuthentication() throws RemoteException, UserSecurityException {
        AuthenticationToken atoken = this.serverConnection.authenticateUser(this.applicationname, this.username, this.pswdUser, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"), "10.2.0.66");
        return atoken;
    }

    public static void main(String[] args) {
        TestAdmin test = new TestAdmin();
        test.startTest();
    }

    private void triggerCookieRefresh() {
        try {
            InitialContext ctx = new InitialContext();
            Hashtable<String, String> prop = new Hashtable<String, String>();
            prop.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            prop.put("java.naming.provider.url", "localhost:17099");
            prop.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            ctx = new InitialContext(prop);
            System.out.println("Hallo");
            Object control = ctx.lookup("AuthenticationManager");
            System.out.println("Hallo1");
            Object myObject = PortableRemoteObject.narrow((Object)control, (Class)(class$server$security$AuthenticationManagerHome == null ? (class$server$security$AuthenticationManagerHome = TestAdmin.class$("server.security.AuthenticationManagerHome")) : class$server$security$AuthenticationManagerHome));
            if (myObject == null) {
                System.out.println("No lookup");
            }
            AuthenticationManagerHome authManagerHome = (AuthenticationManagerHome)myObject;
            AuthenticationManager sb = authManagerHome.create();
            System.out.println("Hallo2");
            sb.triggerCookieKey();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void triggerLoginRefresh() {
        try {
            InitialContext ctx = new InitialContext();
            Hashtable<String, String> prop = new Hashtable<String, String>();
            prop.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            prop.put("java.naming.provider.url", "localhost:17099");
            prop.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            ctx = new InitialContext(prop);
            System.out.println("Hallo");
            Object control = ctx.lookup("AuthenticationManager");
            System.out.println("Hallo1");
            Object myObject = PortableRemoteObject.narrow((Object)control, (Class)(class$server$security$AuthenticationManagerHome == null ? (class$server$security$AuthenticationManagerHome = TestAdmin.class$("server.security.AuthenticationManagerHome")) : class$server$security$AuthenticationManagerHome));
            if (myObject == null) {
                System.out.println("No lookup");
            }
            AuthenticationManagerHome authManagerHome = (AuthenticationManagerHome)myObject;
            AuthenticationManager sb = authManagerHome.create();
            System.out.println("Hallo2");
            sb.triggerLoginHandlerUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void testDeleteAcl() throws RemoteException, UserSecurityException {
        AclVO vo = this.testGetAclOfResourceByUser();
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.deleteAcl(vo.getId(), auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testDeleteGroup() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.deleteGroup("test", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testDisableUserInApplication() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.disableUserInApplication("test5", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testEditOtherUser() throws RemoteException, UserSecurityException {
        ExtendedUserVO vo = this.testGetUserByIdExtended();
        vo.setFullname("Test Test55");
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.editUser(vo, auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testEditOwnUser() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        ExtendedUserVO vo = this.testGetUserVOExtended(auth);
        vo.setFullname("Test Test55");
        this.triggerCookieRefresh();
        System.out.println("I edit now my own user");
        this.serverConnection.editUser(vo, auth.getAuthenticationID(), this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testEnableUserInApplication() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.enableUserInApplication("test5", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testExistsUser() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        MessageFromServer msg = this.serverConnection.existsUser("test5", "Test Test55", "test5.hartler@tugraz.at", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(msg.getMessage());
    }

    private void testGetAccessrightsByUser() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector acls = this.serverConnection.getAccessrightsByUser(this.username, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println("Found by Name");
        int i = 0;
        while (i != acls.size()) {
            RightOfResourceVO vo = (RightOfResourceVO)acls.get(i);
            System.out.println(vo.getResource().getResourceKey() + ": " + vo.getAllAccessLevel());
            ++i;
        }
        Long userid = this.testGetUserIDFromName();
        this.triggerCookieRefresh();
        acls = this.serverConnection.getAccessrightsByUser(userid, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println("Found by Id");
        int i2 = 0;
        while (i2 != acls.size()) {
            RightOfResourceVO vo = (RightOfResourceVO)acls.get(i2);
            System.out.println(vo.getResource().getResourceKey() + ": " + vo.getAllAccessLevel());
            ++i2;
        }
    }

    private AclVO testGetAclOfResourceByGroup() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        AclVO vo = this.serverConnection.getAclOfResourceByGroup("maspectrasPowerUser", "entityB", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        if (vo != null) {
            System.out.println(vo.toString());
        }
        return vo;
    }

    private AclVO testGetAclOfResourceByUser() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        AclVO vo = this.serverConnection.getAclOfResourceByUser("test5", "entityB", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        if (vo != null) {
            System.out.println(vo.toString());
        }
        return vo;
    }

    private void testGetAclsOfGroup() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector acls = this.serverConnection.getAclsOfGroup("maspectrasAdmin", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != acls.size()) {
            AclVO vo = (AclVO)acls.get(i);
            System.out.println(vo.getResourceKey() + ": " + vo.getAccessLevel());
            ++i;
        }
    }

    private void testGetAclsOfUser() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector acls = this.serverConnection.getAclsOfUser("test5", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != acls.size()) {
            AclVO vo = (AclVO)acls.get(i);
            System.out.println(vo.getResourceKey() + ": " + vo.getAccessLevel());
            ++i;
        }
    }

    private Vector testGetAllInstitutes() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector institues = this.serverConnection.getAllInstitutes(this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != institues.size()) {
            InstitutVO vo = (InstitutVO)institues.get(i);
            System.out.println(vo.getName());
            ++i;
        }
        return institues;
    }

    private void testGetAllResourcesOfApplication() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector resources = this.serverConnection.getAllResourcesOfApplication(this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != resources.size()) {
            ResourceVO vo = (ResourceVO)resources.get(i);
            System.out.println(vo.getResourceKey());
            ++i;
        }
    }

    private void testGetAllUsersFromInstitute() throws RemoteException, UserSecurityException {
        InstitutVO instVO = (InstitutVO)this.testGetAllInstitutes().get(0);
        this.triggerCookieRefresh();
        Vector users = this.serverConnection.getAllUsersFromInstitut(instVO.getId(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != users.size()) {
            InstitutMembersVO vo = (InstitutMembersVO)users.get(i);
            System.out.println(vo);
            ++i;
        }
    }

    private void testGetAllUsersWithProperty() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector usersWithProperty = this.serverConnection.getAllUsersWithProperty("email", this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != usersWithProperty.size()) {
            System.out.println(((ExtendedUserVO)usersWithProperty.get(i)).getFullname());
            ++i;
        }
    }

    private void testGetExtendedUsersOfApplication() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector users = this.serverConnection.getExtendedUsersOfApplication(this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"), true, false);
        int i = 0;
        while (i != users.size()) {
            System.out.println(((ExtendedUserVO)users.get(i)).getFullname());
            ++i;
        }
    }

    private void testGetGroupsEnabledInApplication() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector groups = this.serverConnection.getGroupsEnabledInApplication(this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != groups.size()) {
            SmallGroupVO vo = (SmallGroupVO)groups.get(i);
            System.out.println(vo);
            ++i;
        }
    }

    private void testGetUserById() throws RemoteException, UserSecurityException {
        Long id = this.testGetUserIDFromName();
        this.triggerCookieRefresh();
        UserVO vo = this.serverConnection.getUserByID(id, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(vo);
    }

    private void testGetUserByIdExtendedSecure() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        Long userId = this.testGetUserIDFromName();
        this.triggerCookieRefresh();
        ExtendedUserVO vo = this.serverConnection.getUserByIDExtended(userId, this.adminUsername, auth.getAuthenticationID(), this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(vo);
    }

    private ExtendedUserVO testGetUserByIdExtended() throws RemoteException, UserSecurityException {
        Long userId = this.testGetUserIDFromName();
        this.triggerCookieRefresh();
        ExtendedUserVO vo = this.serverConnection.getUserByIDExtended(userId, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(vo);
        return vo;
    }

    private Long testGetUserIDFromName() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Long id = this.serverConnection.getUserIDFromName("test5", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(id);
        return id;
    }

    private void testGetUsersOfApplication() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector users = this.serverConnection.getUsersOfApplication(this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"), true, false);
        int i = 0;
        while (i != users.size()) {
            System.out.println(((UserVO)users.get(i)).getFullUsername());
            ++i;
        }
    }

    private void testGetUserVO() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        UserVO vo = this.serverConnection.getUserVO(this.username, auth.getAuthenticationID(), this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(vo);
    }

    private ExtendedUserVO testGetUserVOExtended(AuthenticationToken auth) throws RemoteException, UserSecurityException {
        if (auth == null) {
            auth = this.testAuthentication();
        }
        this.triggerCookieRefresh();
        ExtendedUserVO vo = this.serverConnection.getUserVOExtended("test5", auth.getAuthenticationID(), this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(vo);
        return vo;
    }

    private void testUserVOExtendedRegex() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector users = this.serverConnection.getUserVOExtendedRegEx("Juergen Har*", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != users.size()) {
            ExtendedUserVO vo = (ExtendedUserVO)users.get(i);
            System.out.println(vo);
            ++i;
        }
    }

    private void testUserVORegex() throws RemoteException, UserSecurityException {
        this.triggerCookieRefresh();
        Vector users = this.serverConnection.getUserVORegEx("Juergen Har*", this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        int i = 0;
        while (i != users.size()) {
            UserVO vo = (UserVO)users.get(i);
            System.out.println(vo);
            System.out.println(vo.getFullUsername());
            ++i;
        }
    }

    private void testHasUserAccessLevel() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        System.out.println(this.serverConnection.hasUserAccessLevel(this.username, auth.getAuthenticationID(), this.applicationname, "sample", "R", ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword")));
    }

    private void testRemoveUserFromGroup() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        this.triggerCookieRefresh();
        this.serverConnection.removeUserFromGroup("test5", "maspectrasUser", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testSetAclsOfGroup() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        AclVO vo = this.testGetAclOfResourceByGroup();
        this.triggerCookieRefresh();
        this.serverConnection.setAclsOfGroup("maspectrasAdmin", vo.getId(), "R|", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
    }

    private void testSetAclsOfUser() throws RemoteException, UserSecurityException {
        AuthenticationToken auth = this.testAuthentication();
        AclVO vo = this.testGetAclOfResourceByUser();
        this.triggerCookieRefresh();
        boolean result = this.serverConnection.setAclsOfUser("test5", vo.getId(), "R|", auth.getAuthenticationID(), this.adminUsername, this.applicationname, ConfigLoader.getInstance(this.applicationname).getProperties().getProperty("applicationPassword"));
        System.out.println(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

