/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SARDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.deployment.XSLSubDeployerMBean;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSLSubDeployer
extends SubDeployerSupport
implements XSLSubDeployerMBean {
    protected String xslUrl;
    protected String packageSuffix;
    protected String ddSuffix;
    protected DocumentBuilderFactory dbf;
    private Templates templates;
    protected ObjectName delegateName = SARDeployerMBean.OBJECT_NAME;
    protected SubDeployer delegate;

    public void setXslUrl(String xslUrl) {
        this.xslUrl = xslUrl;
    }

    public String getXslUrl() {
        return this.xslUrl;
    }

    public void setPackageSuffix(String packageSuffix) {
        this.packageSuffix = packageSuffix;
    }

    public String getPackageSuffix() {
        return this.packageSuffix;
    }

    public void setDdSuffix(String ddSuffix) {
        this.ddSuffix = ddSuffix;
    }

    public String getDdSuffix() {
        return this.ddSuffix;
    }

    public void setDelegateName(ObjectName delegateName) {
        this.delegateName = delegateName;
    }

    public ObjectName getDelegateName() {
        return this.delegateName;
    }

    protected void createService() throws Exception {
        super.createService();
        this.delegate = (SubDeployer)MBeanProxy.get((Class)SubDeployer.class, (ObjectName)this.delegateName, (MBeanServer)this.server);
        TransformerFactory tf = TransformerFactory.newInstance();
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setNamespaceAware(true);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xslUrl);
        StreamSource ss = new StreamSource(is);
        this.templates = tf.newTemplates(ss);
        this.log.debug((Object)("Created templates: " + this.templates));
    }

    protected void destroyService() throws Exception {
        this.templates = null;
        super.destroyService();
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return this.packageSuffix != null && (urlStr.endsWith(this.packageSuffix) || urlStr.endsWith(this.packageSuffix + "/")) || this.ddSuffix != null && urlStr.endsWith(this.ddSuffix);
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        if (di.document == null) {
            this.findDd(di);
        }
        try {
            Transformer trans = this.templates.newTransformer();
            DOMSource s = new DOMSource(di.document);
            DOMResult r = new DOMResult();
            this.setParameters(trans);
            trans.transform(s, r);
            di.document = (Document)r.getNode();
            this.log.debug((Object)("transformed into doc: " + di.document));
            if (this.log.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                DOMWriter w = new DOMWriter((Writer)sw, false);
                w.print((Node)di.document, true);
                this.log.debug((Object)("transformed into doc: " + sw.getBuffer().toString()));
            }
        }
        catch (TransformerException ce) {
            throw new DeploymentException("Problem with xsl transformation", ce);
        }
        this.delegate.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        this.delegate.create(di);
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        this.delegate.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        this.delegate.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.delegate.destroy(di);
    }

    protected void setParameters(Transformer trans) throws TransformerException {
    }

    protected void findDd(DeploymentInfo di) throws DeploymentException {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            String urlStr = di.url.toString();
            if (this.ddSuffix != null && urlStr.endsWith(this.ddSuffix)) {
                di.document = db.parse(di.url.openStream());
            }
        }
        catch (SAXException se) {
            throw new DeploymentException("Could not parse dd", se);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not read dd", ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new DeploymentException("Could not create document builder for dd", pce);
        }
    }
}

