/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.components.encoding.UTF16Encoder;
import org.apache.axis.components.encoding.UTF8Encoder;
import org.apache.axis.components.encoding.XMLEncoder;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.jboss.logging.Logger;

public class XMLEncoderFactory {
    private static Logger log = Logger.getLogger((String)XMLEncoderFactory.class.getName());
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_UTF_16 = "UTF-16";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static Map encoderMap = new HashMap();
    private static final String PLUGABLE_PROVIDER_FILENAME = "org.apache.axis.components.encoding.XMLEncoder";

    public static XMLEncoder getDefaultEncoder() {
        try {
            return XMLEncoderFactory.getEncoder("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(Messages.getMessage("unsupportedDefaultEncoding00", "UTF-8"));
        }
    }

    public static XMLEncoder getEncoder(String encoding) throws UnsupportedEncodingException {
        XMLEncoder encoder = (XMLEncoder)encoderMap.get(encoding.toUpperCase());
        if (encoder == null) {
            throw new UnsupportedEncodingException(Messages.getMessage("unsupportedEncoding00", encoding));
        }
        "test".getBytes(encoder.getEncoding());
        return encoder;
    }

    private static void loadPluggableEncoders() {
        ClassLoader clzLoader = XMLEncoder.class.getClassLoader();
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(clzLoader);
        DiscoverServiceNames dsn = new DiscoverServiceNames(loaders);
        ResourceNameIterator iter = dsn.findResourceNames(PLUGABLE_PROVIDER_FILENAME);
        while (iter.hasNext()) {
            String className = iter.nextResourceName();
            try {
                Object o = Class.forName(className).newInstance();
                if (!(o instanceof XMLEncoder)) continue;
                XMLEncoder encoder = (XMLEncoder)o;
                encoderMap.put(encoder.getEncoding(), encoder);
            }
            catch (Exception e) {
                String msg = e + JavaUtils.LS + JavaUtils.stackToString(e);
                log.info((Object)Messages.getMessage("exception01", msg));
            }
        }
    }

    static {
        encoderMap.put("UTF-8", new UTF8Encoder());
        encoderMap.put(ENCODING_UTF_16, new UTF16Encoder());
        try {
            XMLEncoderFactory.loadPluggableEncoders();
        }
        catch (Throwable t) {
            String msg = t + JavaUtils.LS + JavaUtils.stackToString(t);
            log.info((Object)Messages.getMessage("exception01", msg));
        }
    }
}

