/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.encoding.ser.EnumDeserializer;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.JavaUtils;

public class BeanDeserializerFactory
extends BaseDeserializerFactory {
    protected TypeDesc typeDesc = null;
    protected Map propertyMap = null;

    public BeanDeserializerFactory(Class javaType, QName xmlType) {
        super(BeanDeserializer.class, xmlType, javaType);
        if (JavaUtils.isEnumClass(javaType)) {
            this.deserClass = EnumDeserializer.class;
        }
        this.typeDesc = TypeDesc.getTypeDescForClass(javaType);
        this.propertyMap = BeanDeserializerFactory.getProperties(javaType, this.typeDesc);
    }

    public static Map getProperties(Class javaType, TypeDesc typeDesc) {
        HashMap<String, BeanPropertyDescriptor> propertyMap = null;
        if (typeDesc != null) {
            propertyMap = typeDesc.getPropertyDescriptorMap();
        } else {
            BeanPropertyDescriptor[] pd = BeanUtils.getPd(javaType, null);
            propertyMap = new HashMap<String, BeanPropertyDescriptor>();
            for (int i = 0; i < pd.length; ++i) {
                BeanPropertyDescriptor descriptor = pd[i];
                propertyMap.put(descriptor.getName(), descriptor);
            }
        }
        return propertyMap;
    }

    protected Deserializer getGeneralPurpose(String mechanismType) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.deserClass == EnumDeserializer.class) {
            return super.getGeneralPurpose(mechanismType);
        }
        return new BeanDeserializer(this.javaType, this.xmlType, this.typeDesc, this.propertyMap);
    }
}

