/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelopeAxisImpl;
import org.apache.axis.message.SOAPHeaderElementAxisImpl;
import org.apache.axis.utils.Messages;
import org.jboss.logging.Logger;

public class DebugHandler
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)DebugHandler.class.getName());
    public static final String NS_URI_DEBUG = "http://xml.apache.org/axis/debug";

    public void invoke(MessageContext msgContext) throws AxisFault {
        log.debug((Object)"Enter: DebugHandler::invoke");
        try {
            Message msg = msgContext.getRequestMessage();
            SOAPEnvelopeAxisImpl message = msg.getSOAPEnvelope();
            SOAPHeaderElementAxisImpl header = message.getHeaderByName(NS_URI_DEBUG, "Debug");
            if (header != null) {
                Integer i = (Integer)header.getValueAsType(Constants.XSD_INT);
                if (i == null) {
                    throw new AxisFault(Messages.getMessage("cantConvert03"));
                }
                int debugVal = i;
                log.debug((Object)Messages.getMessage("debugLevel00", "" + debugVal));
                header.setProcessed(true);
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        log.debug((Object)"Exit: DebugHandler::invoke");
    }

    public void onFault(MessageContext msgContext) {
        log.debug((Object)"Enter: DebugHandler::onFault");
        log.debug((Object)"Exit: DebugHandler::onFault");
    }
}

