/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ebxml.registry.util;

import com.sun.ebxml.registry.util.UUID;
import java.security.SecureRandom;

public class UUIDFactory {
    private final SecureRandom secRand = new SecureRandom();
    private final byte[] secRandBuf16 = new byte[16];
    private final byte[] secRandBuf8 = new byte[8];
    private static UUIDFactory instance = null;
    static /* synthetic */ Class class$com$sun$ebxml$registry$util$UUIDFactory;

    protected UUIDFactory() {
    }

    public UUID newUUID() {
        this.secRand.nextBytes(this.secRandBuf16);
        this.secRandBuf16[6] = (byte)(this.secRandBuf16[6] & 0xF);
        this.secRandBuf16[6] = (byte)(this.secRandBuf16[6] | 0x40);
        this.secRandBuf16[8] = (byte)(this.secRandBuf16[8] & 0x3F);
        this.secRandBuf16[8] = (byte)(this.secRandBuf16[8] | 0x80);
        this.secRandBuf16[10] = (byte)(this.secRandBuf16[10] | 0x80);
        long mostSig = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSig = mostSig << 8 | (long)(this.secRandBuf16[i] & 0xFF);
        }
        long leastSig = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSig = leastSig << 8 | (long)(this.secRandBuf16[i] & 0xFF);
        }
        return new UUID(mostSig, leastSig);
    }

    public boolean isValidUUID(String uuid) {
        boolean isValid = true;
        int len = uuid.length();
        String hexDigits = "0123456789abcdef";
        for (int i = 0; i < len; ++i) {
            char c = uuid.charAt(i);
            if (i == 8 || i == 13 || i == 18 || i == 23) {
                if (c == '-') continue;
                isValid = false;
                break;
            }
            if (hexDigits.indexOf(c) != -1) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    private static void printUsage() {
        System.err.println("...UUIDFactory [help] cnt=<number of uuids required>");
        System.exit(-1);
    }

    public static void main(String[] args) {
        int cnt = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("help")) {
                UUIDFactory.printUsage();
                continue;
            }
            if (args[i].startsWith("cnt=")) {
                cnt = Integer.parseInt(args[i].substring(4, args[i].length()));
                continue;
            }
            System.err.println("Unknown parameter: '" + args[i] + "' at position " + i);
            if (i > 0) {
                System.err.println("Last valid parameter was '" + args[i - 1] + "'");
            }
            UUIDFactory.printUsage();
        }
        UUIDFactory uf = UUIDFactory.getInstance();
        for (int i = 0; i < cnt; ++i) {
            UUID id = uf.newUUID();
            System.out.println("new UUID : " + id.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUIDFactory getInstance() {
        if (instance == null) {
            Class clazz = class$com$sun$ebxml$registry$util$UUIDFactory == null ? (class$com$sun$ebxml$registry$util$UUIDFactory = UUIDFactory.class$("com.sun.ebxml.registry.util.UUIDFactory")) : class$com$sun$ebxml$registry$util$UUIDFactory;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new UUIDFactory();
                }
            }
        }
        return instance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

