/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.ConceptsTreeModel;
import com.sun.xml.registry.client.browser.FindParamsPanel;
import com.sun.xml.registry.client.browser.JAXRClient;
import com.sun.xml.registry.client.browser.NodeInfo;
import com.sun.xml.registry.client.browser.QueryPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.client.browser.TreeCombo;
import com.sun.xml.registry.client.browser.conf.bindings.Configuration;
import com.sun.xml.registry.client.browser.conf.bindings.Parameter;
import com.sun.xml.registry.client.browser.conf.bindings.Query;
import com.sun.xml.registry.client.browser.conf.bindings.QueryTypeChoice;
import com.sun.xml.registry.client.browser.conf.bindings.SlotList;
import com.sun.xml.registry.client.browser.conf.bindings.types.DatatypeType;
import com.sun.xml.registry.ebxml.QueryManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.oasis.ebxml.registry.bindings.query.FilterQuery;
import org.oasis.ebxml.registry.bindings.rim.Description;
import org.oasis.ebxml.registry.bindings.rim.InternationalStringType;
import org.oasis.ebxml.registry.bindings.rim.InternationalStringTypeItem;
import org.oasis.ebxml.registry.bindings.rim.LocalizedString;
import org.oasis.ebxml.registry.bindings.rim.Name;
import org.oasis.ebxml.registry.bindings.rim.Slot;
import org.oasis.ebxml.registry.bindings.rim.ValueList;
import org.oasis.ebxml.registry.bindings.rim.ValueListTypeItem;

public class AdhocQueryPanel
extends QueryPanel {
    private GridBagConstraints c = new GridBagConstraints();
    private FindParamsPanel findParamsPanel;
    private ArrayList queries = new ArrayList();
    private JComboBox selectQueryCombo = null;
    private JTextField queryNameText = null;
    private JTextArea queryDescText = null;
    private JPanel parentOfEntryPanel = null;
    private ArrayList paramComponents = new ArrayList();
    private Query query = null;
    private Log log = LogFactory.getLog(this.getClass());

    public AdhocQueryPanel(FindParamsPanel findParamsPanel, Configuration cfg) {
        super(findParamsPanel, cfg);
        this.processConfiguration();
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        JPanel querySelectionPanel = this.createQuerySelectionPanel();
        this.parentOfEntryPanel = this.createParentOfEntryPanels();
        JScrollPane querySelectionScrollPane = new JScrollPane(querySelectionPanel);
        JScrollPane parentOfEntryScrollPane = new JScrollPane(this.parentOfEntryPanel);
        JSplitPane splitPane = new JSplitPane(0, false, querySelectionScrollPane, parentOfEntryScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.setQuery((Query)this.queries.get(0));
    }

    private JPanel createQuerySelectionPanel() {
        JPanel querySelectionPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        querySelectionPanel.setLayout(gbl);
        JLabel selectQueryLabel = new JLabel("Select Query:", 2);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(selectQueryLabel, this.c);
        querySelectionPanel.add(selectQueryLabel);
        this.selectQueryCombo = new JComboBox<String>(this.getQueryNames());
        this.selectQueryCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 2) {
                    return;
                }
                String item = (String)ev.getItem();
                int index = ((JComboBox)ev.getSource()).getSelectedIndex();
                Query query = (Query)AdhocQueryPanel.this.queries.get(index);
                AdhocQueryPanel.this.setQuery(query);
            }
        });
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(this.selectQueryCombo, this.c);
        querySelectionPanel.add(this.selectQueryCombo);
        JLabel queryNameLabel = new JLabel("Name:", 2);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(queryNameLabel, this.c);
        querySelectionPanel.add(queryNameLabel);
        this.queryNameText = new JTextField();
        this.queryNameText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(this.queryNameText, this.c);
        querySelectionPanel.add(this.queryNameText);
        JLabel queryDescLabel = new JLabel("Description:", 2);
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(queryDescLabel, this.c);
        querySelectionPanel.add(queryDescLabel);
        this.queryDescText = new JTextArea(4, 25);
        this.queryDescText.setLineWrap(true);
        this.queryDescText.setEditable(false);
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.5;
        this.c.weighty = 0.5;
        this.c.fill = 1;
        this.c.anchor = 13;
        this.c.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(this.queryDescText, this.c);
        querySelectionPanel.add(this.queryDescText);
        return querySelectionPanel;
    }

    private void setQuery(Query query) {
        if (this.query != null) {
            String queryStr = this.getQuery();
            System.err.println("queryStr='" + queryStr + "'");
        }
        this.query = query;
        String name = this.getQueryName(query);
        this.queryNameText.setText(name);
        this.queryDescText.setText(this.getQueryDescription(query));
        JPanel parameterEntryPanel = this.createParameterEntryPanel(query);
        this.parentOfEntryPanel.setVisible(false);
        this.parentOfEntryPanel.removeAll();
        this.parentOfEntryPanel.add(parameterEntryPanel);
        this.parentOfEntryPanel.setVisible(true);
    }

    protected void processConfiguration() {
        Query[] _queries = this.cfg.getQuery();
        for (int i = 0; i < _queries.length; ++i) {
            this.queries.add(_queries[i]);
        }
    }

    private String getQueryDescription(Query query) {
        String queryDesc = null;
        Description desc = query.getDescription();
        queryDesc = this.getLocalizedValue(desc);
        return queryDesc;
    }

    private String getQueryName(Query query) {
        String queryName = null;
        Name name = query.getName();
        queryName = this.getLocalizedValue(name);
        return queryName;
    }

    private String[] getQueryNames() {
        String[] queryNames = new String[this.queries.size()];
        int i = 0;
        Iterator iter = this.queries.iterator();
        while (iter.hasNext()) {
            Query query = (Query)iter.next();
            queryNames[i++] = this.getQueryName(query);
        }
        return queryNames;
    }

    private String getLocalizedValue(InternationalStringType i18n) {
        String value = "";
        InternationalStringTypeItem[] items = i18n.getInternationalStringTypeItem();
        if (items.length > 0) {
            LocalizedString l10n = items[0].getLocalizedString();
            value = l10n.getValue();
        }
        return value;
    }

    private JPanel createParentOfEntryPanels() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Ad Hoc Query Parameters"));
        BorderLayout bl = new BorderLayout();
        panel.setLayout(bl);
        return panel;
    }

    private JPanel createParameterEntryPanel(Query query) {
        JPanel parameterEntryPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        parameterEntryPanel.setLayout(gbl);
        this.paramComponents.clear();
        Parameter[] params = query.getParameter();
        int i = 0;
        while (i < params.length) {
            Parameter param = params[i];
            String tooltip = this.getLocalizedValue(param.getDescription());
            JLabel label = new JLabel(this.getLocalizedValue(param.getName()) + ":", 4);
            label.setToolTipText(tooltip);
            this.c.gridx = 0;
            this.c.gridy = i;
            this.c.gridwidth = 1;
            this.c.gridheight = 1;
            this.c.weightx = 0.0;
            this.c.weighty = 0.0;
            this.c.fill = 0;
            this.c.anchor = 13;
            this.c.insets = new Insets(4, 4, 0, 4);
            gbl.setConstraints(label, this.c);
            parameterEntryPanel.add(label);
            String defaultValue = param.getDefaultValue();
            JComponent comp = this.getComponentForParameter(param, defaultValue);
            this.c.gridx = 1;
            this.c.gridy = i++;
            this.c.gridwidth = 1;
            this.c.gridheight = 1;
            this.c.weightx = 0.5;
            this.c.weighty = 0.0;
            this.c.fill = 2;
            this.c.anchor = 13;
            this.c.insets = new Insets(4, 4, 4, 4);
            gbl.setConstraints(comp, this.c);
            parameterEntryPanel.add(comp);
            this.paramComponents.add(comp);
        }
        return parameterEntryPanel;
    }

    private JComponent getComponentForParameter(Parameter param, String defaultValue) {
        JComponent comp = null;
        DatatypeType type = param.getDatatype();
        if (type.getType() == 1) {
            boolean val = false;
            if (defaultValue.equalsIgnoreCase("true")) {
                val = true;
            }
            comp = new JCheckBox("", val);
        } else if (type.getType() == 5) {
            String domainId = null;
            SlotList slotList = param.getSlotList();
            Slot[] slots = slotList.getSlot();
            for (int i = 0; i < slots.length; ++i) {
                ValueList valList;
                if (!slots[i].getName().equalsIgnoreCase("domain") || (valList = slots[i].getValueList()) == null) continue;
                ValueListTypeItem[] vlti = valList.getValueListTypeItem();
                domainId = vlti[0].getValue();
            }
            RegistryObject ro = null;
            try {
                JAXRClient client = RegistryBrowser.getInstance().getClient();
                BusinessQueryManager bqm = client.getBusinessQueryManager();
                ro = bqm.getRegistryObject(domainId);
            }
            catch (JAXRException e) {
                this.log.error((Object)e);
                System.exit(-1);
            }
            ConceptsTreeModel domainTreeModel = new ConceptsTreeModel(true, ro);
            comp = new TreeCombo(domainTreeModel);
        } else {
            comp = new JTextField(defaultValue);
            comp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RegistryBrowser.getInstance().findAction();
                }
            });
        }
        return comp;
    }

    private String getQuery() {
        String query = null;
        QueryTypeChoice qtc = this.query.getQueryTypeChoice();
        query = qtc.getSQLQuery();
        if (query == null) {
            FilterQuery fq = qtc.getFilterQuery();
            StringWriter sw = new StringWriter();
            try {
                fq.marshal(sw);
                query = sw.toString();
            }
            catch (MarshalException e) {
                e.printStackTrace();
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
        }
        int paramCnt = this.paramComponents.size();
        for (int i = paramCnt - 1; i >= 0; --i) {
            Component comp = (Component)this.paramComponents.get(i);
            query = this.replaceQueryParameter(query, i, comp);
        }
        query = this.replaceSpecialVariables(query);
        return query;
    }

    private String replaceQueryParameter(String query, int paramPosition, Component component) {
        String newQuery = query;
        try {
            String paramValue = null;
            if (component instanceof JTextComponent) {
                paramValue = ((JTextComponent)component).getText();
            } else if (component instanceof AbstractButton) {
                boolean selected = ((AbstractButton)component).isSelected();
                paramValue = selected ? "TRUE" : "FALSE";
            } else if (component instanceof TreeCombo) {
                Object conceptsTreeNode = ((TreeCombo)component).getSelectedItemsObject();
                Object nodeInfo = ((DefaultMutableTreeNode)conceptsTreeNode).getUserObject();
                if (nodeInfo instanceof NodeInfo) {
                    RegistryObject obj = ((NodeInfo)nodeInfo).obj;
                    if (obj instanceof ClassificationScheme) {
                        paramValue = "/" + ((ClassificationScheme)obj).getKey().getId();
                    } else if (obj instanceof Concept) {
                        paramValue = ((Concept)obj).getPath();
                    }
                }
            } else {
                RegistryBrowser.displayError("Internal error: unsupported component class: " + component.getClass().getName());
            }
            String paramName = "$" + (paramPosition + 1);
            int index = 0;
            while (index != -1) {
                index = query.indexOf(paramName);
                if (index == -1) continue;
                newQuery = query.substring(0, index);
                newQuery = newQuery + paramValue;
                query = newQuery = newQuery + query.substring(index + paramName.length());
            }
        }
        catch (JAXRException e) {
            this.log.error((Object)e);
        }
        return newQuery;
    }

    private String replaceSpecialVariables(String query) {
        String newQuery = query;
        String paramName = "$callerId";
        if (query.indexOf(paramName) > 0) {
            String paramValue = null;
            try {
                RegistryBrowser.getInstance();
                Connection connection = RegistryBrowser.client.getConnection();
                RegistryService service = connection.getRegistryService();
                DeclarativeQueryManager dqm = service.getDeclarativeQueryManager();
                paramValue = ((QueryManagerImpl)((Object)dqm)).getCallersUser().getKey().getId();
            }
            catch (JAXRException e) {
                RegistryBrowser.displayError(e);
            }
            int index = 0;
            while (index != -1) {
                index = query.indexOf(paramName);
                if (index == -1) continue;
                newQuery = query.substring(0, index);
                newQuery = newQuery + paramValue;
                query = newQuery = newQuery + query.substring(index + paramName.length());
            }
        }
        return newQuery;
    }

    BulkResponse executeQuery() {
        BulkResponse resp = null;
        try {
            RegistryBrowser.getInstance();
            Connection connection = RegistryBrowser.client.getConnection();
            RegistryService service = connection.getRegistryService();
            DeclarativeQueryManager dqm = service.getDeclarativeQueryManager();
            String queryStr = this.getQuery();
            javax.xml.registry.Query query = dqm.createQuery(0, queryStr);
            resp = dqm.executeQuery(query);
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return resp;
    }
}

