/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.RegistryBrowser;
import com.sun.xml.registry.ebxml.infomodel.AuditableEventImpl;
import com.sun.xml.registry.ebxml.infomodel.RegistryObjectRef;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.AuditableEvent;
import javax.xml.registry.infomodel.User;

public class AuditableEventsTableModel
extends AbstractTableModel {
    String[] columnNames = new String[]{"Event Type", "Timestamp", "User"};
    ArrayList auditableEvents = new ArrayList();
    RegistryBrowser registryBrowser = RegistryBrowser.getInstance();

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.auditableEvents.size();
    }

    public AuditableEvent getObjectAt(int row) {
        AuditableEvent ae = (AuditableEvent)this.auditableEvents.get(row);
        return ae;
    }

    public Object getValueAt(int row, int col) {
        AuditableEvent auditableEvent = (AuditableEvent)this.auditableEvents.get(row);
        String value = null;
        Object iString = null;
        try {
            switch (col) {
                case 0: {
                    value = RegistryBrowser.getEventTypeAsString(auditableEvent.getEventType());
                    break;
                }
                case 1: {
                    value = auditableEvent.getTimestamp().toString();
                    break;
                }
                case 2: {
                    User user = null;
                    try {
                        user = auditableEvent.getUser();
                    }
                    catch (JAXRException e) {
                        // empty catch block
                    }
                    if (user != null) {
                        value = RegistryBrowser.getUserName(auditableEvent.getUser(), 1);
                        break;
                    }
                    RegistryObjectRef userRef = ((AuditableEventImpl)auditableEvent).getUserRef();
                    value = userRef.getId();
                }
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
        return value;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    void update(Collection auditableEvents) {
        if (auditableEvents.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No Audit Trail found.", "Registry Browser", 1);
            auditableEvents = new ArrayList();
        }
        this.setAuditableEvents(auditableEvents);
    }

    ArrayList getAuditableEvents() {
        return this.auditableEvents;
    }

    void setAuditableEvents(Collection objects) {
        this.auditableEvents.clear();
        this.auditableEvents.addAll(objects);
        this.fireTableDataChanged();
    }
}

