/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.client.browser;

import com.sun.xml.registry.client.browser.JBPanel;
import com.sun.xml.registry.client.browser.RegistryBrowser;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.EmailAddress;

public class EmailAddressPanel
extends JBPanel {
    JTextField addressText = null;
    String[] emailTypes = new String[]{"Office email", "Home email"};
    JComboBox typeCombo = null;

    public EmailAddressPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gbl);
        JLabel addressLabel = new JLabel("Email Address:", 2);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(addressLabel, c);
        this.add(addressLabel);
        this.addressText = new JTextField();
        this.addressText.setEditable(this.editable);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.addressText, c);
        this.add(this.addressText);
        JLabel typeLabel = new JLabel("Address Type:", 2);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(typeLabel, c);
        this.add(typeLabel);
        this.typeCombo = new JComboBox<String>(this.emailTypes);
        this.typeCombo.setEditable(true);
        this.typeCombo.setEnabled(this.editable);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 0, 4);
        gbl.setConstraints(this.typeCombo, c);
        this.add(this.typeCombo);
    }

    public EmailAddress getEmailAddress() throws JAXRException {
        EmailAddress email = null;
        if (this.model != null) {
            email = (EmailAddress)this.getModel();
        }
        return email;
    }

    public void setEmailAddress(EmailAddress email) throws JAXRException {
        this.setModel(email);
    }

    public void setModel(Object obj) throws JAXRException {
        if (!(obj instanceof EmailAddress)) {
            throw new InvalidRequestException("Expecting a EmailAddress. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        EmailAddress email = (EmailAddress)obj;
        try {
            if (email != null) {
                this.addressText.setText(email.getAddress());
                this.typeCombo.setSelectedItem(email.getType());
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public void setEmailAddress(Object obj) throws JAXRException {
        if (!(obj instanceof EmailAddress)) {
            throw new InvalidRequestException("Expecting a EmailAddress. Got a " + obj.getClass().getName());
        }
        super.setModel(obj);
        EmailAddress email = (EmailAddress)obj;
        try {
            if (email != null) {
                this.addressText.setText(email.getAddress());
                this.typeCombo.setSelectedItem(email.getType());
            }
        }
        catch (JAXRException e) {
            RegistryBrowser.displayError(e);
        }
    }

    public Object getModel() throws JAXRException {
        super.getModel();
        if (this.model != null) {
            EmailAddress emailAddress = (EmailAddress)this.model;
            emailAddress.setAddress(this.addressText.getText());
            emailAddress.setType((String)this.typeCombo.getSelectedItem());
            RegistryBrowser.getInstance().getRootPane().updateUI();
        }
        return this.model;
    }

    protected void validateInput() throws JAXRException {
        super.validateInput();
        EmailAddress emailAddress = (EmailAddress)this.model;
    }

    public void clear() throws JAXRException {
        super.clear();
        this.addressText.setText("");
        this.typeCombo.setSelectedIndex(0);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.addressText.setEditable(editable);
        this.typeCombo.setEnabled(editable);
    }
}

